/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.ssvd;

import org.apache.mahout.math.CholeskyDecomposition;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.RandomTrinaryMatrix;
import org.apache.mahout.math.SingularValueDecomposition;
import org.apache.mahout.math.Vector;

public class SequentialBigSvd {
    private final Matrix y;
    private final CholeskyDecomposition cd1;
    private final CholeskyDecomposition cd2;
    private final SingularValueDecomposition svd;
    private final Matrix b;

    public SequentialBigSvd(Matrix A, int p) {
        this.y = A.times(new RandomTrinaryMatrix(A.columnSize(), p));
        this.cd1 = new CholeskyDecomposition(this.y.transpose().times(this.y));
        this.b = this.cd1.solveRight(this.y).transpose().times(A);
        this.cd2 = new CholeskyDecomposition(this.b.times(this.b.transpose()));
        this.svd = new SingularValueDecomposition(this.cd2.getL());
    }

    public Vector getSingularValues() {
        return new DenseVector(this.svd.getSingularValues());
    }

    public Matrix getU() {
        return this.cd1.solveRight(this.y).times(this.svd.getU());
    }

    public Matrix getV() {
        return this.cd2.solveRight(this.b.transpose()).times(this.svd.getV());
    }
}

