/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractFloatSet
extends AbstractSet {
    public boolean contains(final float key) {
        return !this.forEachKey(new FloatProcedure(){

            @Override
            public boolean apply(float iterKey) {
                return key != iterKey;
            }
        });
    }

    public AbstractFloatSet copy() {
        return (AbstractFloatSet)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractFloatSet)) {
            return false;
        }
        final AbstractFloatSet other = (AbstractFloatSet)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachKey(new FloatProcedure(){

            @Override
            public boolean apply(float key) {
                return other.contains(key);
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachKey(new FloatProcedure(){
            int i = 0;

            @Override
            public boolean apply(float iterKey) {
                buf[this.i++] = HashUtils.hash(iterKey);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(FloatProcedure var1);

    public FloatArrayList keys() {
        FloatArrayList list = new FloatArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final FloatArrayList list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            @Override
            public boolean apply(float key) {
                list.add(key);
                return true;
            }
        });
    }

    public abstract boolean add(float var1);

    public abstract boolean remove(float var1);

    public String toString() {
        FloatArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }
}

