/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.random;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.random.AbstractSamplerFunction;
import org.apache.mahout.math.random.Multinomial;
import org.apache.mahout.math.random.WeightedThing;

public final class PoissonSampler
extends AbstractSamplerFunction {
    private double limit = 1.0;
    private Multinomial<Integer> partial;
    private final RandomWrapper gen = RandomUtils.getRandom();
    private final PoissonDistribution pd;

    public PoissonSampler(double lambda) {
        this.pd = new PoissonDistribution(this.gen.getRandomGenerator(), lambda, 1.0E-12, 10000000);
    }

    @Override
    public Double sample() {
        return this.sample(this.gen.nextDouble());
    }

    double sample(double u) {
        if (u < this.limit) {
            ArrayList steps = Lists.newArrayList();
            this.limit = 1.0;
            int i = 0;
            while (u / 20.0 < this.limit) {
                double pdf = this.pd.probability(i);
                this.limit -= pdf;
                steps.add(new WeightedThing<Integer>(i, pdf));
                ++i;
            }
            steps.add(new WeightedThing<Integer>(steps.size(), this.limit));
            this.partial = new Multinomial(steps);
        }
        return this.partial.sample(u).intValue();
    }
}

