/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.LengthCachingVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorBinaryAggregate;
import org.apache.mahout.math.VectorBinaryAssign;
import org.apache.mahout.math.VectorView;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;

public abstract class AbstractVector
implements Vector,
LengthCachingVector {
    private int size;
    protected double lengthSquared = -1.0;

    protected AbstractVector(int size) {
        this.size = size;
    }

    @Override
    public Iterable<Vector.Element> all() {
        return new Iterable<Vector.Element>(){

            @Override
            public Iterator<Vector.Element> iterator() {
                return AbstractVector.this.iterator();
            }
        };
    }

    @Override
    public Iterable<Vector.Element> nonZeroes() {
        return new Iterable<Vector.Element>(){

            @Override
            public Iterator<Vector.Element> iterator() {
                return AbstractVector.this.iterateNonZero();
            }
        };
    }

    protected abstract Iterator<Vector.Element> iterator();

    protected abstract Iterator<Vector.Element> iterateNonZero();

    @Override
    public double aggregate(DoubleDoubleFunction aggregator, DoubleFunction map) {
        double result;
        if (this.size == 0) {
            return 0.0;
        }
        if (aggregator.isAssociativeAndCommutative() && aggregator.isLikeLeftMult() && this.size > this.getNumNondefaultElements() && !map.isDensifying()) {
            return 0.0;
        }
        if (this.isSequentialAccess() || aggregator.isAssociativeAndCommutative()) {
            Iterator<Vector.Element> iterator;
            if (!map.isDensifying() && aggregator.isLikeRightPlus()) {
                iterator = this.iterateNonZero();
                if (!iterator.hasNext()) {
                    return 0.0;
                }
            } else {
                iterator = this.iterator();
            }
            Vector.Element element = iterator.next();
            result = map.apply(element.get());
            while (iterator.hasNext()) {
                element = iterator.next();
                result = aggregator.apply(result, map.apply(element.get()));
            }
        } else {
            result = map.apply(this.getQuick(0));
            for (int i = 1; i < this.size; ++i) {
                result = aggregator.apply(result, map.apply(this.getQuick(i)));
            }
        }
        return result;
    }

    @Override
    public double aggregate(Vector other, DoubleDoubleFunction aggregator, DoubleDoubleFunction combiner) {
        Preconditions.checkArgument((this.size == other.size() ? 1 : 0) != 0, (Object)"Vector sizes differ");
        if (this.size == 0) {
            return 0.0;
        }
        return VectorBinaryAggregate.aggregateBest(this, other, aggregator, combiner);
    }

    protected abstract Matrix matrixLike(int var1, int var2);

    @Override
    public Vector viewPart(int offset, int length) {
        if (offset < 0) {
            throw new IndexException(offset, this.size);
        }
        if (offset + length > this.size) {
            throw new IndexException(offset + length, this.size);
        }
        return new VectorView(this, offset, length);
    }

    @Override
    public Vector clone() {
        try {
            AbstractVector r = (AbstractVector)super.clone();
            r.size = this.size;
            r.lengthSquared = this.lengthSquared;
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Can't happen");
        }
    }

    @Override
    public Vector divide(double x) {
        if (x == 1.0) {
            return this.clone();
        }
        Vector result = this.createOptimizedCopy();
        for (Vector.Element element : result.nonZeroes()) {
            element.set(element.get() / x);
        }
        return result;
    }

    @Override
    public double dot(Vector x) {
        if (this.size != x.size()) {
            throw new CardinalityException(this.size, x.size());
        }
        if (this == x) {
            return this.getLengthSquared();
        }
        return this.aggregate(x, Functions.PLUS, Functions.MULT);
    }

    protected double dotSelf() {
        return this.aggregate(Functions.PLUS, Functions.pow(2.0));
    }

    @Override
    public double get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexException(index, this.size);
        }
        return this.getQuick(index);
    }

    @Override
    public Vector.Element getElement(int index) {
        return new LocalElement(index);
    }

    @Override
    public Vector normalize() {
        return this.divide(Math.sqrt(this.getLengthSquared()));
    }

    @Override
    public Vector normalize(double power) {
        return this.divide(this.norm(power));
    }

    @Override
    public Vector logNormalize() {
        return this.logNormalize(2.0, Math.sqrt(this.getLengthSquared()));
    }

    @Override
    public Vector logNormalize(double power) {
        return this.logNormalize(power, this.norm(power));
    }

    public Vector logNormalize(double power, double normLength) {
        if (Double.isInfinite(power) || power <= 1.0) {
            throw new IllegalArgumentException("Power must be > 1 and < infinity");
        }
        double denominator = normLength * Math.log(power);
        Vector result = this.createOptimizedCopy();
        for (Vector.Element element : result.nonZeroes()) {
            element.set(Math.log1p(element.get()) / denominator);
        }
        return result;
    }

    @Override
    public double norm(double power) {
        if (power < 0.0) {
            throw new IllegalArgumentException("Power must be >= 0");
        }
        if (Double.isInfinite(power)) {
            return this.aggregate(Functions.MAX, Functions.ABS);
        }
        if (power == 2.0) {
            return Math.sqrt(this.getLengthSquared());
        }
        if (power == 1.0) {
            double result = 0.0;
            Iterator<Vector.Element> iterator = this.iterateNonZero();
            while (iterator.hasNext()) {
                result += Math.abs(iterator.next().get());
            }
            return result;
        }
        if (power == 0.0) {
            return this.getNumNonZeroElements();
        }
        return Math.pow(this.aggregate(Functions.PLUS, Functions.pow(power)), 1.0 / power);
    }

    @Override
    public double getLengthSquared() {
        if (this.lengthSquared >= 0.0) {
            return this.lengthSquared;
        }
        this.lengthSquared = this.dotSelf();
        return this.lengthSquared;
    }

    @Override
    public void invalidateCachedLength() {
        this.lengthSquared = -1.0;
    }

    @Override
    public double getDistanceSquared(Vector that) {
        double dot;
        double thatLength;
        if (this.size != that.size()) {
            throw new CardinalityException(this.size, that.size());
        }
        double thisLength = this.getLengthSquared();
        double distanceEstimate = thisLength + (thatLength = that.getLengthSquared()) - 2.0 * (dot = this.dot(that));
        if (distanceEstimate > 0.001 * (thisLength + thatLength)) {
            return Math.max(distanceEstimate, 0.0);
        }
        return this.aggregate(that, Functions.PLUS, Functions.MINUS_SQUARED);
    }

    @Override
    public double maxValue() {
        if (this.size == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.aggregate(Functions.MAX, Functions.IDENTITY);
    }

    @Override
    public int maxValueIndex() {
        int result = -1;
        double max = Double.NEGATIVE_INFINITY;
        int nonZeroElements = 0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            ++nonZeroElements;
            Vector.Element element = iter.next();
            double tmp = element.get();
            if (!(tmp > max)) continue;
            max = tmp;
            result = element.index();
        }
        if (nonZeroElements < this.size && max < 0.0) {
            for (Vector.Element element : this.all()) {
                if (element.get() != 0.0) continue;
                return element.index();
            }
        }
        return result;
    }

    @Override
    public double minValue() {
        if (this.size == 0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.aggregate(Functions.MIN, Functions.IDENTITY);
    }

    @Override
    public int minValueIndex() {
        int result = -1;
        double min = Double.POSITIVE_INFINITY;
        int nonZeroElements = 0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            ++nonZeroElements;
            Vector.Element element = iter.next();
            double tmp = element.get();
            if (!(tmp < min)) continue;
            min = tmp;
            result = element.index();
        }
        if (nonZeroElements < this.size && min > 0.0) {
            for (Vector.Element element : this.all()) {
                if (element.get() != 0.0) continue;
                return element.index();
            }
        }
        return result;
    }

    @Override
    public Vector plus(double x) {
        Vector result = this.createOptimizedCopy();
        if (x == 0.0) {
            return result;
        }
        return result.assign(Functions.plus(x));
    }

    @Override
    public Vector plus(Vector that) {
        if (this.size != that.size()) {
            throw new CardinalityException(this.size, that.size());
        }
        return this.createOptimizedCopy().assign(that, Functions.PLUS);
    }

    @Override
    public Vector minus(Vector that) {
        if (this.size != that.size()) {
            throw new CardinalityException(this.size, that.size());
        }
        return this.createOptimizedCopy().assign(that, Functions.MINUS);
    }

    @Override
    public void set(int index, double value) {
        if (index < 0 || index >= this.size) {
            throw new IndexException(index, this.size);
        }
        this.setQuick(index, value);
    }

    @Override
    public void incrementQuick(int index, double increment) {
        this.setQuick(index, this.getQuick(index) + increment);
    }

    @Override
    public Vector times(double x) {
        if (x == 0.0) {
            return this.like();
        }
        return this.createOptimizedCopy().assign(Functions.mult(x));
    }

    protected Vector createOptimizedCopy() {
        return AbstractVector.createOptimizedCopy(this);
    }

    private static Vector createOptimizedCopy(Vector vector) {
        Vector result = vector.isDense() ? vector.like().assign(vector, Functions.SECOND_LEFT_ZERO) : vector.clone();
        return result;
    }

    @Override
    public Vector times(Vector that) {
        if (this.size != that.size()) {
            throw new CardinalityException(this.size, that.size());
        }
        if (this.getNumNondefaultElements() <= that.getNumNondefaultElements()) {
            return AbstractVector.createOptimizedCopy(this).assign(that, Functions.MULT);
        }
        return AbstractVector.createOptimizedCopy(that).assign(this, Functions.MULT);
    }

    @Override
    public double zSum() {
        return this.aggregate(Functions.PLUS, Functions.IDENTITY);
    }

    @Override
    public int getNumNonZeroElements() {
        int count = 0;
        Iterator<Vector.Element> it = this.iterateNonZero();
        while (it.hasNext()) {
            if (it.next().get() == 0.0) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Vector assign(double value) {
        if (value == 0.0) {
            Iterator<Vector.Element> it = this.iterateNonZero();
            while (it.hasNext()) {
                it.next().set(value);
            }
        } else if (this.isSequentialAccess() && !this.isAddConstantTime()) {
            Iterator<Vector.Element> it = this.iterator();
            OrderedIntDoubleMapping updates = new OrderedIntDoubleMapping();
            while (it.hasNext()) {
                Vector.Element element = it.next();
                if (element.get() == 0.0) {
                    updates.set(element.index(), value);
                    continue;
                }
                element.set(value);
            }
            this.mergeUpdates(updates);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, value);
            }
        }
        this.invalidateCachedLength();
        return this;
    }

    @Override
    public Vector assign(double[] values) {
        if (this.size != values.length) {
            throw new CardinalityException(this.size, values.length);
        }
        if (this.isSequentialAccess() && !this.isAddConstantTime()) {
            OrderedIntDoubleMapping updates = new OrderedIntDoubleMapping();
            Iterator<Vector.Element> it = this.iterator();
            while (it.hasNext()) {
                Vector.Element element = it.next();
                int index = element.index();
                if (element.get() == 0.0) {
                    updates.set(index, values[index]);
                    continue;
                }
                element.set(values[index]);
            }
            this.mergeUpdates(updates);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, values[i]);
            }
        }
        this.invalidateCachedLength();
        return this;
    }

    @Override
    public Vector assign(Vector other) {
        return this.assign(other, Functions.SECOND);
    }

    @Override
    public Vector assign(DoubleDoubleFunction f2, double y) {
        Iterator<Vector.Element> iterator;
        Iterator<Vector.Element> iterator2 = iterator = f2.apply(0.0, y) == 0.0 ? this.iterateNonZero() : this.iterator();
        while (iterator.hasNext()) {
            Vector.Element element = iterator.next();
            element.set(f2.apply(element.get(), y));
        }
        this.invalidateCachedLength();
        return this;
    }

    @Override
    public Vector assign(DoubleFunction f2) {
        Iterator<Vector.Element> iterator;
        Iterator<Vector.Element> iterator2 = iterator = !f2.isDensifying() ? this.iterateNonZero() : this.iterator();
        while (iterator.hasNext()) {
            Vector.Element element = iterator.next();
            element.set(f2.apply(element.get()));
        }
        this.invalidateCachedLength();
        return this;
    }

    @Override
    public Vector assign(Vector other, DoubleDoubleFunction function) {
        if (this.size != other.size()) {
            throw new CardinalityException(this.size, other.size());
        }
        VectorBinaryAssign.assignBest(this, other, function);
        this.invalidateCachedLength();
        return this;
    }

    @Override
    public Matrix cross(Vector other) {
        Matrix result = this.matrixLike(this.size, other.size());
        Iterator<Vector.Element> it = this.iterateNonZero();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            int row = e.index();
            result.assignRow(row, other.times(this.getQuick(row)));
        }
        return result;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public String asFormatString() {
        return this.toString();
    }

    public int hashCode() {
        int result = this.size;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element ele = iter.next();
            result += ele.index() * RandomUtils.hashDouble(ele.get());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector that = (Vector)o;
        return this.size == that.size() && this.aggregate(that, Functions.PLUS, Functions.MINUS_ABS) == 0.0;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] dictionary) {
        StringBuilder result = new StringBuilder();
        result.append('{');
        for (int index = 0; index < this.size; ++index) {
            double value = this.getQuick(index);
            if (value == 0.0) continue;
            result.append(dictionary != null && dictionary.length > index ? dictionary[index] : Integer.valueOf(index));
            result.append(':');
            result.append(value);
            result.append(',');
        }
        if (result.length() > 1) {
            result.setCharAt(result.length() - 1, '}');
        } else {
            result.append('}');
        }
        return result.toString();
    }

    public String sparseVectorToString() {
        Iterator<Vector.Element> it = this.iterateNonZero();
        if (!it.hasNext()) {
            return "{}";
        }
        StringBuilder result = new StringBuilder();
        result.append('{');
        while (it.hasNext()) {
            Vector.Element e = it.next();
            result.append(e.index());
            result.append(':');
            result.append(e.get());
            result.append(',');
        }
        result.setCharAt(result.length() - 1, '}');
        return result.toString();
    }

    protected final class LocalElement
    implements Vector.Element {
        int index;

        LocalElement(int index) {
            this.index = index;
        }

        @Override
        public double get() {
            return AbstractVector.this.getQuick(this.index);
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void set(double value) {
            AbstractVector.this.setQuick(this.index, value);
        }
    }
}

