/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.primitives.Longs;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.apache.commons.math3.primes.Primes;
import org.apache.mahout.common.RandomWrapper;

public final class RandomUtils {
    public static final int MAX_INT_SMALLER_TWIN_PRIME = 2147482949;
    private static final Map<RandomWrapper, Boolean> INSTANCES = Collections.synchronizedMap(new WeakHashMap());
    private static boolean testSeed = false;

    private RandomUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useTestSeed() {
        testSeed = true;
        Map<RandomWrapper, Boolean> map = INSTANCES;
        synchronized (map) {
            for (RandomWrapper rng : INSTANCES.keySet()) {
                rng.resetToTestSeed();
            }
        }
    }

    public static RandomWrapper getRandom() {
        RandomWrapper random = new RandomWrapper();
        if (testSeed) {
            random.resetToTestSeed();
        }
        INSTANCES.put(random, Boolean.TRUE);
        return random;
    }

    public static Random getRandom(long seed) {
        RandomWrapper random = new RandomWrapper(seed);
        INSTANCES.put(random, Boolean.TRUE);
        return random;
    }

    public static int hashDouble(double value) {
        return Longs.hashCode((long)Double.doubleToLongBits(value));
    }

    public static int hashFloat(float value) {
        return Float.floatToIntBits(value);
    }

    public static int nextTwinPrime(int n) {
        if (n > 2147482949) {
            throw new IllegalArgumentException();
        }
        if (n <= 3) {
            return 5;
        }
        int next = Primes.nextPrime((int)n);
        while (!Primes.isPrime((int)(next + 2))) {
            next = Primes.nextPrime((int)(next + 4));
        }
        return next + 2;
    }
}

