/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.status.StatusConsoleListener;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.test.ListStatusListener;
import org.apache.logging.log4j.test.junit.ExtensionContextAnchor;
import org.apache.logging.log4j.test.junit.TypeBasedParameterResolver;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;

class StatusListenerExtension
extends TypeBasedParameterResolver<ListStatusListener>
implements BeforeAllCallback,
BeforeEachCallback,
TestExecutionExceptionHandler {
    private static final Object KEY = ListStatusListener.class;

    public StatusListenerExtension() {
        super((Type)((Object)ListStatusListener.class));
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        ListStatusListenerHolder holder = new ListStatusListenerHolder(context, null);
        ExtensionContextAnchor.setAttribute(KEY, holder, context);
        ReflectionSupport.findFields((Class)context.getRequiredTestClass(), f -> ModifierSupport.isStatic((Member)f) && f.getType().equals(ListStatusListener.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).forEach(f -> {
            try {
                f.setAccessible(true);
                f.set(null, holder.getStatusListener());
            }
            catch (ReflectiveOperationException e) {
                throw new ExtensionContextException("Failed to inject field.", (Throwable)e);
            }
        });
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ListStatusListenerHolder parentHolder = ExtensionContextAnchor.getAttribute(KEY, ListStatusListenerHolder.class, context);
        ListStatusListener parent = parentHolder != null ? parentHolder.getStatusListener() : null;
        ListStatusListenerHolder holder = new ListStatusListenerHolder(context, parent);
        ExtensionContextAnchor.setAttribute(KEY, holder, context);
        ReflectionSupport.findFields((Class)context.getRequiredTestClass(), f -> ModifierSupport.isNotStatic((Member)f) && f.getType().equals(ListStatusListener.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).forEach(f -> {
            try {
                f.setAccessible(true);
                f.set(context.getRequiredTestInstance(), holder.getStatusListener());
            }
            catch (ReflectiveOperationException e) {
                throw new ExtensionContextException("Failed to inject field.", (Throwable)e);
            }
        });
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        ListStatusListenerHolder holder = ExtensionContextAnchor.getAttribute(KEY, ListStatusListenerHolder.class, context);
        if (holder != null) {
            holder.handleException(context, throwable);
        }
        throw throwable;
    }

    @Override
    public ListStatusListener resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ListStatusListenerHolder holder = ExtensionContextAnchor.getAttribute(KEY, ListStatusListenerHolder.class, extensionContext);
        return holder.getStatusListener();
    }

    private static class ListStatusListenerHolder
    implements ExtensionContext.Store.CloseableResource {
        private final StatusLogger statusLogger = StatusLogger.getLogger();
        private final ListStatusListener statusListener;

        public ListStatusListenerHolder(ExtensionContext context, ListStatusListener parent) {
            this.statusListener = new JUnitListStatusListener(context, parent);
            this.statusLogger.registerListener((StatusListener)this.statusListener);
        }

        public ListStatusListener getStatusListener() {
            return this.statusListener;
        }

        public void close() {
            this.statusLogger.removeListener((StatusListener)this.statusListener);
        }

        public void handleException(ExtensionContext context, Throwable throwable) {
            StatusConsoleListener listener = new StatusConsoleListener(Level.ALL, System.err);
            listener.log(new StatusData(null, Level.ERROR, (Message)new ParameterizedMessage("Test `{}` has failed, dumping status data...", (Object)context.getDisplayName()), throwable, null));
            this.statusListener.getStatusData().forEach(arg_0 -> ((StatusListener)listener).log(arg_0));
        }
    }

    private static class JUnitListStatusListener
    implements ListStatusListener {
        private final ExtensionContext context;
        private final ListStatusListener parent;
        private final ArrayList<StatusData> statusData = new ArrayList();

        public JUnitListStatusListener(ExtensionContext context, ListStatusListener parent) {
            this.context = context;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void log(StatusData data) {
            if (this.context.equals(ExtensionContextAnchor.getContext())) {
                ArrayList<StatusData> arrayList = this.statusData;
                synchronized (arrayList) {
                    this.statusData.add(data);
                }
            }
        }

        public Level getStatusLevel() {
            return Level.DEBUG;
        }

        public void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Stream<StatusData> getStatusData() {
            ArrayList<StatusData> arrayList = this.statusData;
            synchronized (arrayList) {
                ArrayList<StatusData> clone = new ArrayList<StatusData>(this.statusData);
                return this.parent != null ? Stream.concat(this.parent.getStatusData(), clone.stream()) : clone.stream();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            ArrayList<StatusData> arrayList = this.statusData;
            synchronized (arrayList) {
                this.statusData.clear();
            }
        }
    }
}

