/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.validator;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.model.validator.CustomValidatorDefinition;
import org.apache.camel.model.validator.EndpointValidatorDefinition;
import org.apache.camel.model.validator.PredicateValidatorDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.validator.CustomValidatorReifier;
import org.apache.camel.reifier.validator.EndpointValidatorReifier;
import org.apache.camel.reifier.validator.PredicateValidatorReifier;
import org.apache.camel.spi.ReifierStrategy;
import org.apache.camel.spi.Validator;

public abstract class ValidatorReifier<T>
extends AbstractReifier {
    private static final Map<Class<?>, BiFunction<CamelContext, ValidatorDefinition, ValidatorReifier<? extends ValidatorDefinition>>> VALIDATORS;
    protected final T definition;

    public ValidatorReifier(CamelContext camelContext, T definition) {
        super(camelContext);
        this.definition = definition;
    }

    public static void registerReifier(Class<?> processorClass, BiFunction<CamelContext, ValidatorDefinition, ValidatorReifier<? extends ValidatorDefinition>> creator) {
        VALIDATORS.put(processorClass, creator);
    }

    public static ValidatorReifier<? extends ValidatorDefinition> reifier(CamelContext camelContext, ValidatorDefinition definition) {
        BiFunction<CamelContext, ValidatorDefinition, ValidatorReifier<? extends ValidatorDefinition>> reifier = VALIDATORS.get(definition.getClass());
        if (reifier != null) {
            return reifier.apply(camelContext, definition);
        }
        throw new IllegalStateException("Unsupported definition: " + definition);
    }

    public static void clearReifiers() {
        VALIDATORS.clear();
    }

    public Validator createValidator() {
        return this.doCreateValidator();
    }

    protected abstract Validator doCreateValidator();

    static {
        HashMap map = new HashMap();
        map.put(CustomValidatorDefinition.class, CustomValidatorReifier::new);
        map.put(EndpointValidatorDefinition.class, EndpointValidatorReifier::new);
        map.put(PredicateValidatorDefinition.class, PredicateValidatorReifier::new);
        VALIDATORS = map;
        ReifierStrategy.addReifierClearer(ValidatorReifier::clearReifiers);
    }
}

