/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.join.ImmutableUniqueList;

public final class JoinKey
extends ImmutableUniqueList<Var> {
    private static final JoinKey EMPTY = new JoinKey(new Var[0]);

    public static JoinKey empty() {
        return EMPTY;
    }

    public static JoinKey create(Collection<Var> vars1, Collection<Var> vars2) {
        ArrayList<Var> intersection = new ArrayList<Var>();
        for (Var v : vars1) {
            if (!vars2.contains((Object)v)) continue;
            intersection.add(v);
        }
        return JoinKey.create(intersection);
    }

    public static JoinKey create(Var var) {
        return JoinKey.createUnsafe(new Var[]{var});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static JoinKey create(Collection<Var> vars) {
        JoinKey joinKey;
        if (vars instanceof Set) {
            Set s = (Set)vars;
            joinKey = JoinKey.create(s);
        } else {
            joinKey = JoinKey.newBuilder().addAll(vars).build();
        }
        return joinKey;
    }

    public static JoinKey create(String ... varNames) {
        return JoinKey.create(Var.varList(Arrays.asList(varNames)));
    }

    public static JoinKey create(Var[] vars) {
        return JoinKey.newBuilder().addAll(vars).build();
    }

    public static JoinKey create(Set<Var> vars) {
        Var[] arr = new Var[vars.size()];
        arr = vars.toArray(arr);
        return JoinKey.createUnsafe(arr);
    }

    private static JoinKey createUnsafe(Var[] keys) {
        return keys.length == 0 ? JoinKey.empty() : new JoinKey(keys);
    }

    private JoinKey(Var[] keys) {
        super(keys);
    }

    public Var getVarKey() {
        if (((Var[])this.elementData).length == 0) {
            return null;
        }
        return ((Var[])this.elementData)[0];
    }

    public static final class Builder {
        private ImmutableUniqueList.Builder<Var> delegate = ImmutableUniqueList.newUniqueListBuilder(Var.class);

        Builder() {
        }

        public Builder add(Var var) {
            this.delegate = this.delegate.add(var);
            return this;
        }

        public Builder addAll(Collection<Var> vars) {
            this.delegate = this.delegate.addAll(vars);
            return this;
        }

        public Builder addAll(Var[] vars) {
            this.delegate = this.delegate.addAll((Var[])vars);
            return this;
        }

        public Builder remove(Var var) {
            this.delegate = this.delegate.remove((Object)var);
            return this;
        }

        public Builder clear() {
            this.delegate = this.delegate.clear();
            return this;
        }

        public JoinKey build() {
            if (!this.delegate.isEmpty()) {
                ImmutableUniqueList<Var> list = this.delegate.build();
                return new JoinKey((Var[])list.elementData);
            }
            JoinKey result = JoinKey.empty();
            return result;
        }
    }
}

