/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.binding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.VariableNotBoundException;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionEnvBase;
import org.apache.jena.sparql.util.NodeCmp;

public class BindingComparator
implements Comparator<Binding> {
    private static Comparator<Var> varComparator = new Comparator<Var>(){

        @Override
        public int compare(Var o1, Var o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private List<SortCondition> conditions;
    private FunctionEnv env;

    public BindingComparator(List<SortCondition> conditions, ExecutionContext execCxt) {
        this.conditions = conditions;
        this.env = execCxt;
    }

    public BindingComparator(List<SortCondition> _conditions) {
        this.conditions = _conditions;
        this.env = new FunctionEnvBase();
    }

    public List<SortCondition> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    @Override
    public int compare(Binding bind1, Binding bind2) {
        for (SortCondition sc : this.conditions) {
            if (sc.expression == null) {
                throw new QueryExecException("Broken sort condition");
            }
            NodeValue nv1 = null;
            NodeValue nv2 = null;
            try {
                nv1 = sc.expression.eval(bind1, this.env);
            }
            catch (VariableNotBoundException variableNotBoundException) {
            }
            catch (ExprEvalException ex) {
                Log.warn((Object)this, (String)ex.getMessage());
            }
            try {
                nv2 = sc.expression.eval(bind2, this.env);
            }
            catch (VariableNotBoundException ex) {
            }
            catch (ExprEvalException ex) {
                Log.warn((Object)this, (String)ex.getMessage());
            }
            Node n1 = NodeValue.toNode(nv1);
            Node n2 = NodeValue.toNode(nv2);
            int x = BindingComparator.compareNodes(nv1, nv2, sc.direction);
            if (x == 0) continue;
            return x;
        }
        return BindingComparator.compareBindingsSyntactic(bind1, bind2);
    }

    private static int compareNodes(NodeValue nv1, NodeValue nv2, int direction) {
        int x = BindingComparator.compareNodesRaw(nv1, nv2);
        if (direction == -1) {
            x = -x;
        }
        return x;
    }

    public static int compareNodesRaw(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null) {
            return nv2 == null ? 0 : -1;
        }
        if (nv2 == null) {
            return 1;
        }
        return NodeValue.compareAlways(nv1, nv2);
    }

    public static int compareBindingsSyntactic(Binding bind1, Binding bind2) {
        int x = 0;
        ArrayList<Var> varList = new ArrayList<Var>();
        Iterator<Var> iter = bind1.vars();
        while (iter.hasNext()) {
            varList.add(iter.next());
        }
        iter = bind2.vars();
        while (iter.hasNext()) {
            varList.add(iter.next());
        }
        Var[] vars = new Var[varList.size()];
        vars = varList.toArray(vars);
        Arrays.sort(vars, varComparator);
        for (Var v : vars) {
            Node n2;
            Node n1 = bind1.get(v);
            x = NodeCmp.compareRDFTerms(n1, n2 = bind2.get(v));
            if (x == 0) continue;
            return x;
        }
        return x;
    }
}

