/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotNull;
import com.unboundid.util.QuotingRequirements;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExampleCommandLineArgument
implements Serializable {
    private static final long serialVersionUID = 2468880329239320437L;
    @NotNull
    private final String rawForm;
    @NotNull
    private final String unixForm;
    @NotNull
    private final String windowsForm;

    private ExampleCommandLineArgument(@NotNull String rawForm, @NotNull String unixForm, @NotNull String windowsForm) {
        this.rawForm = rawForm;
        this.unixForm = unixForm;
        this.windowsForm = windowsForm;
    }

    @NotNull
    public String getRawForm() {
        return this.rawForm;
    }

    @NotNull
    public String getUnixForm() {
        return this.unixForm;
    }

    @NotNull
    public String getWindowsForm() {
        return this.windowsForm;
    }

    @NotNull
    public String getLocalForm() {
        if (StaticUtils.isWindows()) {
            return this.getWindowsForm();
        }
        return this.getUnixForm();
    }

    @NotNull
    public static ExampleCommandLineArgument getCleanArgument(@NotNull String argument) {
        return new ExampleCommandLineArgument(argument, ExampleCommandLineArgument.getUnixForm(argument), ExampleCommandLineArgument.getWindowsForm(argument));
    }

    @NotNull
    public static String getUnixForm(@NotNull String argument) {
        Validator.ensureNotNull(argument);
        QuotingRequirements requirements = ExampleCommandLineArgument.getRequiredUnixQuoting(argument);
        String quotedArgument = argument;
        if (requirements.requiresSingleQuotesOnUnix()) {
            if (requirements.includesSingleQuote()) {
                quotedArgument = quotedArgument.replace("'", "'\"'\"'");
            }
            quotedArgument = '\'' + quotedArgument + '\'';
        } else if (requirements.requiresDoubleQuotesOnUnix()) {
            quotedArgument = '\"' + quotedArgument + '\"';
        }
        return quotedArgument;
    }

    @NotNull
    public static String getWindowsForm(@NotNull String argument) {
        Validator.ensureNotNull(argument);
        QuotingRequirements requirements = ExampleCommandLineArgument.getRequiredUnixQuoting(argument);
        String quotedArgument = argument;
        if (requirements.requiresSingleQuotesOnUnix() || requirements.requiresDoubleQuotesOnUnix()) {
            if (requirements.includesDoubleQuote()) {
                quotedArgument = quotedArgument.replace("\"", "\"\"");
            }
            quotedArgument = '\"' + quotedArgument + '\"';
        }
        return quotedArgument;
    }

    @NotNull
    public static List<String> parseExampleCommandLine(@NotNull String exampleCommandLine) {
        Validator.ensureNotNull(exampleCommandLine);
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        ArrayList<String> args = new ArrayList<String>(20);
        StringBuilder currentArg = new StringBuilder();
        boolean inArg = false;
        for (int i = 0; i < exampleCommandLine.length(); ++i) {
            Character c = Character.valueOf(exampleCommandLine.charAt(i));
            Character nextChar = null;
            if (i < exampleCommandLine.length() - 1) {
                nextChar = Character.valueOf(exampleCommandLine.charAt(i + 1));
            }
            if (inDoubleQuote) {
                if (c.charValue() == '\"') {
                    if (nextChar != null && nextChar.charValue() == '\"') {
                        currentArg.append('\"');
                        ++i;
                        continue;
                    }
                    inDoubleQuote = false;
                    continue;
                }
                currentArg.append(c);
                continue;
            }
            if (inSingleQuote) {
                if (c.charValue() == '\'') {
                    inSingleQuote = false;
                    continue;
                }
                currentArg.append(c);
                continue;
            }
            if (c.charValue() == '\"') {
                inDoubleQuote = true;
                inArg = true;
                continue;
            }
            if (c.charValue() == '\'') {
                inSingleQuote = true;
                inArg = true;
                continue;
            }
            if (c.charValue() == ' ' || c.charValue() == '\t') {
                if (!inArg) continue;
                args.add(currentArg.toString());
                currentArg = new StringBuilder();
                inArg = false;
                continue;
            }
            currentArg.append(c);
            inArg = true;
        }
        if (inArg) {
            args.add(currentArg.toString());
        }
        return args;
    }

    @NotNull
    private static QuotingRequirements getRequiredUnixQuoting(@NotNull String argument) {
        boolean requiresDoubleQuotes = false;
        boolean requiresSingleQuotes = false;
        boolean includesDoubleQuote = false;
        boolean includesSingleQuote = false;
        if (argument.isEmpty()) {
            requiresDoubleQuotes = true;
        }
        block7: for (int i = 0; i < argument.length(); ++i) {
            char c = argument.charAt(i);
            switch (c) {
                case '\"': {
                    includesDoubleQuote = true;
                    requiresSingleQuotes = true;
                    continue block7;
                }
                case '!': 
                case '$': 
                case '*': 
                case '@': 
                case '\\': 
                case '`': {
                    requiresSingleQuotes = true;
                    continue block7;
                }
                case '\'': {
                    includesSingleQuote = true;
                    requiresDoubleQuotes = true;
                    continue block7;
                }
                case ' ': 
                case '&': 
                case '(': 
                case ')': 
                case ';': 
                case '<': 
                case '>': 
                case '|': {
                    requiresDoubleQuotes = true;
                    continue block7;
                }
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '=': 
                case '_': {
                    continue block7;
                }
                default: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue block7;
                    requiresDoubleQuotes = true;
                }
            }
        }
        if (requiresSingleQuotes) {
            requiresDoubleQuotes = false;
        }
        return new QuotingRequirements(requiresSingleQuotes, requiresDoubleQuotes, includesSingleQuote, includesDoubleQuote);
    }
}

