/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.CreateSequenceAsStep;
import org.jooq.CreateSequenceFinalStep;
import org.jooq.CreateSequenceFlagsStep;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Function12;
import org.jooq.SQLDialect;
import org.jooq.Sequence;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.Tools;

final class CreateSequenceImpl<T extends Number>
extends AbstractDDLQuery
implements QOM.CreateSequence<T>,
CreateSequenceAsStep<T>,
CreateSequenceFlagsStep<T>,
CreateSequenceFinalStep {
    final Sequence<?> sequence;
    final boolean ifNotExists;
    DataType<T> dataType;
    Field<T> startWith;
    Field<T> incrementBy;
    Field<T> minvalue;
    boolean noMinvalue;
    Field<T> maxvalue;
    boolean noMaxvalue;
    QOM.CycleOption cycle;
    Field<T> cache;
    boolean noCache;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_SEQUENCE};
    static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedUntil(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    static final Set<SQLDialect> REQUIRES_START_WITH = SQLDialect.supportedBy(SQLDialect.DERBY);
    static final Set<SQLDialect> NO_SUPPORT_CACHE = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB);
    static final Set<SQLDialect> NO_SUPPORT_AS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE, SQLDialect.TRINO);
    static final Set<SQLDialect> NO_SEPARATOR = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.MARIADB);
    static final Set<SQLDialect> OMIT_NO_CACHE = SQLDialect.supportedBy(SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> OMIT_NO_CYCLE = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    static final Set<SQLDialect> OMIT_NO_MINVALUE = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    static final Set<SQLDialect> OMIT_NO_MAXVALUE = SQLDialect.supportedBy(SQLDialect.FIREBIRD);

    CreateSequenceImpl(Configuration configuration, Sequence<?> sequence, boolean ifNotExists) {
        this(configuration, sequence, ifNotExists, null, null, null, null, false, null, false, null, null, false);
    }

    CreateSequenceImpl(Configuration configuration, Sequence<?> sequence, boolean ifNotExists, DataType<T> dataType, Field<T> startWith, Field<T> incrementBy, Field<T> minvalue, boolean noMinvalue, Field<T> maxvalue, boolean noMaxvalue, QOM.CycleOption cycle, Field<T> cache, boolean noCache) {
        super(configuration);
        this.sequence = sequence;
        this.ifNotExists = ifNotExists;
        this.dataType = dataType;
        this.startWith = startWith;
        this.incrementBy = incrementBy;
        this.minvalue = minvalue;
        this.noMinvalue = noMinvalue;
        this.maxvalue = maxvalue;
        this.noMaxvalue = noMaxvalue;
        this.cycle = cycle;
        this.cache = cache;
        this.noCache = noCache;
    }

    @Override
    public final <T extends Number> CreateSequenceImpl<T> as(Class<T> dataType) {
        return this.as((DataType)DefaultDataType.getDataType(null, dataType));
    }

    @Override
    public final <T extends Number> CreateSequenceImpl<T> as(DataType<T> dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public final CreateSequenceImpl<T> startWith(T startWith) {
        return this.startWith(Tools.field(startWith, this.sequence.getDataType()));
    }

    @Override
    public final CreateSequenceImpl<T> startWith(Field<T> startWith) {
        this.startWith = startWith;
        return this;
    }

    @Override
    public final CreateSequenceImpl<T> incrementBy(T incrementBy) {
        return this.incrementBy(Tools.field(incrementBy, this.sequence.getDataType()));
    }

    @Override
    public final CreateSequenceImpl<T> incrementBy(Field<T> incrementBy) {
        this.incrementBy = incrementBy;
        return this;
    }

    @Override
    public final CreateSequenceImpl<T> minvalue(T minvalue) {
        return this.minvalue(Tools.field(minvalue, this.sequence.getDataType()));
    }

    @Override
    public final CreateSequenceImpl<T> minvalue(Field<T> minvalue) {
        this.minvalue = minvalue;
        return this;
    }

    @Override
    public final CreateSequenceImpl<T> noMinvalue() {
        this.noMinvalue = true;
        return this;
    }

    @Override
    public final CreateSequenceImpl<T> maxvalue(T maxvalue) {
        return this.maxvalue(Tools.field(maxvalue, this.sequence.getDataType()));
    }

    @Override
    public final CreateSequenceImpl<T> maxvalue(Field<T> maxvalue) {
        this.maxvalue = maxvalue;
        return this;
    }

    @Override
    public final CreateSequenceImpl<T> noMaxvalue() {
        this.noMaxvalue = true;
        return this;
    }

    @Override
    public final CreateSequenceImpl<T> cycle() {
        this.cycle = QOM.CycleOption.CYCLE;
        return this;
    }

    @Override
    public final CreateSequenceImpl<T> noCycle() {
        this.cycle = QOM.CycleOption.NO_CYCLE;
        return this;
    }

    @Override
    public final CreateSequenceImpl<T> cache(T cache) {
        return this.cache(Tools.field(cache, this.sequence.getDataType()));
    }

    @Override
    public final CreateSequenceImpl<T> cache(Field<T> cache) {
        this.cache = cache;
        return this;
    }

    @Override
    public final CreateSequenceImpl<T> noCache() {
        this.noCache = true;
        return this;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.CREATE_SEQUENCE, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        String noSeparator;
        ctx.start(Clause.CREATE_SEQUENCE_SEQUENCE).visit(Keywords.K_CREATE).sql(' ').visit(ctx.family() == SQLDialect.CUBRID ? Keywords.K_SERIAL : Keywords.K_SEQUENCE).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.sequence);
        String string = noSeparator = NO_SEPARATOR.contains((Object)ctx.dialect()) ? "" : " ";
        if (this.dataType != null && !NO_SUPPORT_AS.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_AS).sql(' ');
            Tools.toSQLDDLTypeDeclaration(ctx, this.dataType);
        }
        if (this.startWith == null && REQUIRES_START_WITH.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_START_WITH).sql(" 1");
        } else if (this.startWith != null) {
            ctx.sql(' ').visit(Keywords.K_START_WITH).sql(' ').visit(this.startWith);
        }
        if (this.incrementBy != null) {
            ctx.sql(' ').visit(Keywords.K_INCREMENT_BY).sql(' ').visit(this.incrementBy);
        }
        if (this.minvalue != null) {
            ctx.sql(' ').visit(Keywords.K_MINVALUE).sql(' ').visit(this.minvalue);
        } else if (this.noMinvalue && !OMIT_NO_MINVALUE.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_NO).sql(noSeparator).visit(Keywords.K_MINVALUE);
        }
        if (this.maxvalue != null) {
            ctx.sql(' ').visit(Keywords.K_MAXVALUE).sql(' ').visit(this.maxvalue);
        } else if (this.noMaxvalue && !OMIT_NO_MAXVALUE.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_NO).sql(noSeparator).visit(Keywords.K_MAXVALUE);
        }
        if (this.cycle == QOM.CycleOption.CYCLE) {
            ctx.sql(' ').visit(Keywords.K_CYCLE);
        } else if (this.cycle == QOM.CycleOption.NO_CYCLE && !OMIT_NO_CYCLE.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_NO).sql(noSeparator).visit(Keywords.K_CYCLE);
        }
        if (!NO_SUPPORT_CACHE.contains((Object)ctx.dialect())) {
            if (this.cache != null) {
                ctx.sql(' ').visit(Keywords.K_CACHE).sql(' ').visit(this.cache);
            } else if (this.noCache && !OMIT_NO_CACHE.contains((Object)ctx.dialect())) {
                ctx.sql(' ').visit(Keywords.K_NO).sql(noSeparator).visit(Keywords.K_CACHE);
            }
        }
        ctx.end(Clause.CREATE_SEQUENCE_SEQUENCE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Sequence<?> $sequence() {
        return this.sequence;
    }

    @Override
    public final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public final DataType<T> $dataType() {
        return this.dataType;
    }

    @Override
    public final Field<T> $startWith() {
        return this.startWith;
    }

    @Override
    public final Field<T> $incrementBy() {
        return this.incrementBy;
    }

    @Override
    public final Field<T> $minvalue() {
        return this.minvalue;
    }

    @Override
    public final boolean $noMinvalue() {
        return this.noMinvalue;
    }

    @Override
    public final Field<T> $maxvalue() {
        return this.maxvalue;
    }

    @Override
    public final boolean $noMaxvalue() {
        return this.noMaxvalue;
    }

    @Override
    public final QOM.CycleOption $cycle() {
        return this.cycle;
    }

    @Override
    public final Field<T> $cache() {
        return this.cache;
    }

    @Override
    public final boolean $noCache() {
        return this.noCache;
    }

    @Override
    public final QOM.CreateSequence<T> $sequence(Sequence<?> newValue) {
        return this.$constructor().apply(newValue, this.$ifNotExists(), this.$dataType(), this.$startWith(), this.$incrementBy(), this.$minvalue(), this.$noMinvalue(), this.$maxvalue(), this.$noMaxvalue(), this.$cycle(), this.$cache(), this.$noCache());
    }

    @Override
    public final QOM.CreateSequence<T> $ifNotExists(boolean newValue) {
        return this.$constructor().apply(this.$sequence(), newValue, this.$dataType(), this.$startWith(), this.$incrementBy(), this.$minvalue(), this.$noMinvalue(), this.$maxvalue(), this.$noMaxvalue(), this.$cycle(), this.$cache(), this.$noCache());
    }

    @Override
    public final QOM.CreateSequence<T> $dataType(DataType<T> newValue) {
        return this.$constructor().apply(this.$sequence(), this.$ifNotExists(), newValue, this.$startWith(), this.$incrementBy(), this.$minvalue(), this.$noMinvalue(), this.$maxvalue(), this.$noMaxvalue(), this.$cycle(), this.$cache(), this.$noCache());
    }

    @Override
    public final QOM.CreateSequence<T> $startWith(Field<T> newValue) {
        return this.$constructor().apply(this.$sequence(), this.$ifNotExists(), this.$dataType(), newValue, this.$incrementBy(), this.$minvalue(), this.$noMinvalue(), this.$maxvalue(), this.$noMaxvalue(), this.$cycle(), this.$cache(), this.$noCache());
    }

    @Override
    public final QOM.CreateSequence<T> $incrementBy(Field<T> newValue) {
        return this.$constructor().apply(this.$sequence(), this.$ifNotExists(), this.$dataType(), this.$startWith(), newValue, this.$minvalue(), this.$noMinvalue(), this.$maxvalue(), this.$noMaxvalue(), this.$cycle(), this.$cache(), this.$noCache());
    }

    @Override
    public final QOM.CreateSequence<T> $minvalue(Field<T> newValue) {
        return this.$constructor().apply(this.$sequence(), this.$ifNotExists(), this.$dataType(), this.$startWith(), this.$incrementBy(), newValue, this.$noMinvalue(), this.$maxvalue(), this.$noMaxvalue(), this.$cycle(), this.$cache(), this.$noCache());
    }

    @Override
    public final QOM.CreateSequence<T> $noMinvalue(boolean newValue) {
        return this.$constructor().apply(this.$sequence(), this.$ifNotExists(), this.$dataType(), this.$startWith(), this.$incrementBy(), this.$minvalue(), newValue, this.$maxvalue(), this.$noMaxvalue(), this.$cycle(), this.$cache(), this.$noCache());
    }

    @Override
    public final QOM.CreateSequence<T> $maxvalue(Field<T> newValue) {
        return this.$constructor().apply(this.$sequence(), this.$ifNotExists(), this.$dataType(), this.$startWith(), this.$incrementBy(), this.$minvalue(), this.$noMinvalue(), newValue, this.$noMaxvalue(), this.$cycle(), this.$cache(), this.$noCache());
    }

    @Override
    public final QOM.CreateSequence<T> $noMaxvalue(boolean newValue) {
        return this.$constructor().apply(this.$sequence(), this.$ifNotExists(), this.$dataType(), this.$startWith(), this.$incrementBy(), this.$minvalue(), this.$noMinvalue(), this.$maxvalue(), newValue, this.$cycle(), this.$cache(), this.$noCache());
    }

    @Override
    public final QOM.CreateSequence<T> $cycle(QOM.CycleOption newValue) {
        return this.$constructor().apply(this.$sequence(), this.$ifNotExists(), this.$dataType(), this.$startWith(), this.$incrementBy(), this.$minvalue(), this.$noMinvalue(), this.$maxvalue(), this.$noMaxvalue(), newValue, this.$cache(), this.$noCache());
    }

    @Override
    public final QOM.CreateSequence<T> $cache(Field<T> newValue) {
        return this.$constructor().apply(this.$sequence(), this.$ifNotExists(), this.$dataType(), this.$startWith(), this.$incrementBy(), this.$minvalue(), this.$noMinvalue(), this.$maxvalue(), this.$noMaxvalue(), this.$cycle(), newValue, this.$noCache());
    }

    @Override
    public final QOM.CreateSequence<T> $noCache(boolean newValue) {
        return this.$constructor().apply(this.$sequence(), this.$ifNotExists(), this.$dataType(), this.$startWith(), this.$incrementBy(), this.$minvalue(), this.$noMinvalue(), this.$maxvalue(), this.$noMaxvalue(), this.$cycle(), this.$cache(), newValue);
    }

    public final Function12<? super Sequence<?>, ? super Boolean, ? super DataType<T>, ? super Field<T>, ? super Field<T>, ? super Field<T>, ? super Boolean, ? super Field<T>, ? super Boolean, ? super QOM.CycleOption, ? super Field<T>, ? super Boolean, ? extends QOM.CreateSequence<T>> $constructor() {
        return (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12) -> new CreateSequenceImpl<T>(this.configuration(), (Sequence<?>)a1, (boolean)a2, a3, a4, a5, a6, (boolean)a7, a8, (boolean)a9, (QOM.CycleOption)((Object)a10), a11, (boolean)a12);
    }
}

