/*
 * Decompiled with CFR 0.152.
 */
package spark.embeddedserver.jetty;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import spark.ssl.SslStores;
import spark.utils.Assert;

public class SocketConnectorFactory {
    public static boolean ENABLE_JETTY_11_COMPATIBILITY = false;

    public static ServerConnector createSocketConnector(Server server, String host, int port, boolean usHTTP2, boolean trustForwardHeaders) {
        Assert.notNull(server, "'server' must not be null");
        Assert.notNull(host, "'host' must not be null");
        HTTP2ServerConnectionFactory connectionFactory = usHTTP2 ? SocketConnectorFactory.createHttp2ConnectionFactory(trustForwardHeaders) : SocketConnectorFactory.createHttpConnectionFactory(trustForwardHeaders);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{connectionFactory});
        SocketConnectorFactory.initializeConnector(connector, host, port);
        return connector;
    }

    static void forceInsertNonExistingResource(SslContextFactory.Server sslContextFactory, String someFieldName, String somePath) {
        try {
            Resource res = ResourceFactory.of((Container)sslContextFactory).newResource(somePath);
            Field myField = SslContextFactory.class.getDeclaredField(someFieldName);
            myField.setAccessible(true);
            myField.set(sslContextFactory, res);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void runOrDefault(Runnable call, Runnable def) {
        block2: {
            try {
                call.run();
            }
            catch (RuntimeException rex) {
                if (!ENABLE_JETTY_11_COMPATIBILITY) break block2;
                def.run();
            }
        }
    }

    public static ServerConnector createSecureSocketConnector(Server server, String host, int port, SslStores sslStores, boolean useHTTP2, boolean trustForwardHeaders) {
        Assert.notNull(server, "'server' must not be null");
        Assert.notNull(host, "'host' must not be null");
        Assert.notNull(sslStores, "'sslStores' must not be null");
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        SocketConnectorFactory.runOrDefault(() -> sslContextFactory.setKeyStorePath(sslStores.keystoreFile()), () -> SocketConnectorFactory.forceInsertNonExistingResource(sslContextFactory, "_keyStoreResource", sslStores.keystoreFile()));
        if (sslStores.keystorePassword() != null) {
            sslContextFactory.setKeyStorePassword(sslStores.keystorePassword());
        }
        if (sslStores.certAlias() != null) {
            sslContextFactory.setCertAlias(sslStores.certAlias());
        }
        if (sslStores.trustStoreFile() != null) {
            SocketConnectorFactory.runOrDefault(() -> sslContextFactory.setTrustStorePath(sslStores.trustStoreFile()), () -> SocketConnectorFactory.forceInsertNonExistingResource(sslContextFactory, "_trustStoreResource", sslStores.trustStoreFile()));
        }
        if (sslStores.trustStorePassword() != null) {
            sslContextFactory.setTrustStorePassword(sslStores.trustStorePassword());
        }
        if (sslStores.needsClientCert()) {
            sslContextFactory.setNeedClientAuth(true);
            sslContextFactory.setWantClientAuth(true);
        }
        HttpConnectionFactory httpConnectionFactory = SocketConnectorFactory.createHttpConnectionFactory(trustForwardHeaders);
        ServerConnector connector = new ServerConnector(server, sslContextFactory, new ConnectionFactory[]{httpConnectionFactory});
        SocketConnectorFactory.initializeConnector(connector, host, port);
        return connector;
    }

    private static void initializeConnector(ServerConnector connector, String host, int port) {
        connector.setIdleTimeout(TimeUnit.HOURS.toMillis(1L));
        connector.setHost(host);
        connector.setPort(port);
    }

    private static HttpConnectionFactory createHttpConnectionFactory(boolean trustForwardHeaders) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        if (trustForwardHeaders) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        return new HttpConnectionFactory(httpConfig);
    }

    private static HTTP2ServerConnectionFactory createHttp2ConnectionFactory(boolean trustForwardHeaders) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        if (trustForwardHeaders) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        return new HTTP2ServerConnectionFactory(httpConfig);
    }
}

