/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.google.common.base.Preconditions;
import org.apache.james.backends.cassandra.versions.SchemaVersion;

public class CassandraVersionRequest {
    private final int value;

    public static CassandraVersionRequest parse(String version) {
        Preconditions.checkNotNull((Object)version, (Object)"Version is mandatory");
        try {
            return new CassandraVersionRequest(Integer.parseInt(version));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expecting version to be specified as an integer", e);
        }
    }

    private CassandraVersionRequest(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0);
        this.value = value;
    }

    public SchemaVersion getValue() {
        return new SchemaVersion(this.value);
    }
}

