/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.service.ExportService;

public class MailboxesExportTask
implements Task {
    static final TaskType TASK_TYPE = TaskType.of((String)"MailboxesExportTask");
    private final Username username;
    private final ExportService service;
    private final ExportService.Progress progress;

    public static TaskDTOModule<MailboxesExportTask, MailboxesExportTaskDTO> module(ExportService service) {
        return (TaskDTOModule)DTOModule.forDomainObject(MailboxesExportTask.class).convertToDTO(MailboxesExportTaskDTO.class).toDomainObjectConverter(dto -> new MailboxesExportTask(service, Username.of((String)dto.username))).toDTOConverter((task, type) -> new MailboxesExportTaskDTO(type, task.username.asString())).typeName(TASK_TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    MailboxesExportTask(ExportService service, Username username) {
        this.username = username;
        this.service = service;
        this.progress = new ExportService.Progress();
    }

    public Task.Result run() {
        return (Task.Result)this.service.export(this.progress, this.username).block();
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(AdditionalInformation.from(this.progress, this.username));
    }

    public static class MailboxesExportTaskDTO
    implements TaskDTO {
        private final String type;
        private final String username;

        public MailboxesExportTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="username") String username) {
            this.type = type;
            this.username = username;
        }

        public String getType() {
            return this.type;
        }

        public String getUsername() {
            return this.username;
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Username username;
        private final ExportService.Stage stage;
        private final Instant timestamp;

        private static AdditionalInformation from(ExportService.Progress progress, Username username) {
            return new AdditionalInformation(username, progress.getStage(), Clock.systemUTC().instant());
        }

        public AdditionalInformation(Username username, ExportService.Stage stage, Instant timestamp) {
            this.username = username;
            this.stage = stage;
            this.timestamp = timestamp;
        }

        public String getUsername() {
            return this.username.asString();
        }

        public ExportService.Stage getStage() {
            return this.stage;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

