/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.time.Duration;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;
import reactor.rabbitmq.ChannelPool;
import reactor.rabbitmq.Utils;
import reactor.util.annotation.Nullable;

public class SenderOptions {
    private ConnectionFactory connectionFactory = ((Supplier<ConnectionFactory>)() -> {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.useNio();
        return connectionFactory;
    }).get();
    private Mono<? extends Connection> connectionMono;
    private Mono<? extends Channel> channelMono;
    private BiConsumer<SignalType, Channel> channelCloseHandler;
    private Scheduler resourceManagementScheduler;
    private Scheduler connectionSubscriptionScheduler;
    private Mono<? extends Channel> resourceManagementChannelMono;
    private Utils.ExceptionFunction<ConnectionFactory, ? extends Connection> connectionSupplier;
    private Function<Mono<? extends Connection>, Mono<? extends Connection>> connectionMonoConfigurator = cm -> cm;
    private Duration connectionClosingTimeout = Duration.ofSeconds(30L);

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public SenderOptions connectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    @Nullable
    public Scheduler getResourceManagementScheduler() {
        return this.resourceManagementScheduler;
    }

    public SenderOptions resourceManagementScheduler(@Nullable Scheduler resourceManagementScheduler) {
        this.resourceManagementScheduler = resourceManagementScheduler;
        return this;
    }

    @Nullable
    public Scheduler getConnectionSubscriptionScheduler() {
        return this.connectionSubscriptionScheduler;
    }

    public SenderOptions connectionSubscriptionScheduler(@Nullable Scheduler connectionSubscriptionScheduler) {
        this.connectionSubscriptionScheduler = connectionSubscriptionScheduler;
        return this;
    }

    public SenderOptions connectionSupplier(Utils.ExceptionFunction<ConnectionFactory, ? extends Connection> function) {
        return this.connectionSupplier(this.connectionFactory, function);
    }

    public SenderOptions connectionSupplier(ConnectionFactory connectionFactory, Utils.ExceptionFunction<ConnectionFactory, ? extends Connection> function) {
        this.connectionSupplier = ignored -> (Connection)function.apply(connectionFactory);
        return this;
    }

    public SenderOptions connectionMono(@Nullable Mono<? extends Connection> connectionMono) {
        this.connectionMono = connectionMono;
        return this;
    }

    @Nullable
    public Mono<? extends Connection> getConnectionMono() {
        return this.connectionMono;
    }

    public SenderOptions channelMono(@Nullable Mono<? extends Channel> channelMono) {
        this.channelMono = channelMono;
        return this;
    }

    @Nullable
    public Mono<? extends Channel> getChannelMono() {
        return this.channelMono;
    }

    @Nullable
    public BiConsumer<SignalType, Channel> getChannelCloseHandler() {
        return this.channelCloseHandler;
    }

    public SenderOptions channelCloseHandler(@Nullable BiConsumer<SignalType, Channel> channelCloseHandler) {
        this.channelCloseHandler = channelCloseHandler;
        return this;
    }

    public SenderOptions channelPool(ChannelPool channelPool) {
        this.channelMono = channelPool.getChannelMono();
        this.channelCloseHandler = channelPool.getChannelCloseHandler();
        return this;
    }

    public SenderOptions connectionMonoConfigurator(Function<Mono<? extends Connection>, Mono<? extends Connection>> connectionMonoConfigurator) {
        this.connectionMonoConfigurator = connectionMonoConfigurator;
        return this;
    }

    public SenderOptions resourceManagementChannelMono(@Nullable Mono<? extends Channel> resourceManagementChannelMono) {
        this.resourceManagementChannelMono = resourceManagementChannelMono;
        return this;
    }

    @Nullable
    public Mono<? extends Channel> getResourceManagementChannelMono() {
        return this.resourceManagementChannelMono;
    }

    @Nullable
    public Utils.ExceptionFunction<ConnectionFactory, ? extends Connection> getConnectionSupplier() {
        return this.connectionSupplier;
    }

    public Function<Mono<? extends Connection>, Mono<? extends Connection>> getConnectionMonoConfigurator() {
        return this.connectionMonoConfigurator;
    }

    public SenderOptions connectionClosingTimeout(@Nullable Duration connectionClosingTimeout) {
        this.connectionClosingTimeout = connectionClosingTimeout;
        return this;
    }

    @Nullable
    public Duration getConnectionClosingTimeout() {
        return this.connectionClosingTimeout;
    }
}

