/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesSourceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;

public abstract class SeriesAggregationSourceNode
extends SeriesSourceNode {
    protected List<AggregationDescriptor> aggregationDescriptorList;
    protected Ordering scanOrder = Ordering.ASC;
    @Nullable
    protected Expression pushDownPredicate;
    @Nullable
    protected GroupByTimeParameter groupByTimeParameter;
    private boolean outputEndTime = false;

    protected SeriesAggregationSourceNode(PlanNodeId id, List<AggregationDescriptor> aggregationDescriptorList) {
        super(id);
        this.aggregationDescriptorList = aggregationDescriptorList;
    }

    public List<AggregationDescriptor> getAggregationDescriptorList() {
        return this.aggregationDescriptorList;
    }

    public void setAggregationDescriptorList(List<AggregationDescriptor> aggregationDescriptorList) {
        this.aggregationDescriptorList = aggregationDescriptorList;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    @Override
    @Nullable
    public Expression getPushDownPredicate() {
        return this.pushDownPredicate;
    }

    public void setPushDownPredicate(@Nullable Expression pushDownPredicate) {
        this.pushDownPredicate = pushDownPredicate;
    }

    public boolean isOutputEndTime() {
        return this.outputEndTime;
    }

    public void setOutputEndTime(boolean outputEndTime) {
        this.outputEndTime = outputEndTime;
    }

    @Nullable
    public GroupByTimeParameter getGroupByTimeParameter() {
        return this.groupByTimeParameter;
    }

    @Override
    public List<String> getOutputColumnNames() {
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        if (this.isOutputEndTime()) {
            outputColumnNames.add("__endTime");
        }
        outputColumnNames.addAll(AggregationNode.getDeduplicatedDescriptors(this.aggregationDescriptorList).stream().map(AggregationDescriptor::getOutputColumnNames).flatMap(Collection::stream).collect(Collectors.toList()));
        return outputColumnNames;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSeriesAggregationSourceNode(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SeriesAggregationSourceNode that = (SeriesAggregationSourceNode)o;
        return this.aggregationDescriptorList.equals(that.aggregationDescriptorList) && this.scanOrder == that.scanOrder && Objects.equals(this.pushDownPredicate, that.pushDownPredicate) && Objects.equals(this.groupByTimeParameter, that.groupByTimeParameter) && this.outputEndTime == that.outputEndTime;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.aggregationDescriptorList, this.scanOrder, this.outputEndTime, this.pushDownPredicate, this.groupByTimeParameter});
    }
}

