/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;

@ThreadSafe
public class DeviceLastCache {
    static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(DeviceLastCache.class) + (int)RamUsageEstimator.shallowSizeOfInstance(ConcurrentHashMap.class);
    public static final TsPrimitiveType EMPTY_PRIMITIVE_TYPE = new TsPrimitiveType(){

        public void setObject(Object o) {
        }

        public void reset() {
        }

        public int getSize() {
            return 0;
        }

        public Object getValue() {
            return null;
        }

        public String getStringValue() {
            return null;
        }

        public TSDataType getDataType() {
            return null;
        }
    };
    public static final TimeValuePair EMPTY_TIME_VALUE_PAIR = new TimeValuePair(Long.MIN_VALUE, EMPTY_PRIMITIVE_TYPE);
    private static final TimeValuePair PLACEHOLDER_TIME_VALUE_PAIR = new TimeValuePair(Long.MIN_VALUE, EMPTY_PRIMITIVE_TYPE);
    private final Map<String, TimeValuePair> measurement2CachedLastMap = new ConcurrentHashMap<String, TimeValuePair>();

    int initOrInvalidate(String[] measurements, boolean isInvalidate) {
        AtomicInteger diff = new AtomicInteger(0);
        for (String measurement : measurements) {
            if (Objects.isNull(measurement)) continue;
            TimeValuePair newPair = isInvalidate ? null : PLACEHOLDER_TIME_VALUE_PAIR;
            this.measurement2CachedLastMap.compute(measurement, (measurementKey, tvPair) -> {
                if (Objects.isNull(newPair)) {
                    diff.addAndGet(-((int)RamUsageEstimator.sizeOf((String)measurement) + DeviceLastCache.getTvPairEntrySize(tvPair)));
                    return null;
                }
                if (Objects.isNull(tvPair)) {
                    diff.addAndGet((int)RamUsageEstimator.sizeOf((String)measurement) + DeviceLastCache.getTvPairEntrySize(newPair));
                    return newPair;
                }
                return tvPair;
            });
        }
        return diff.get();
    }

    int tryUpdate(@Nonnull String[] measurements, @Nonnull TimeValuePair[] timeValuePairs) {
        return this.tryUpdate(measurements, timeValuePairs, false);
    }

    int tryUpdate(@Nonnull String[] measurements, @Nonnull TimeValuePair[] timeValuePairs, boolean invalidateNull) {
        AtomicInteger diff = new AtomicInteger(0);
        long lastTime = Long.MIN_VALUE;
        for (int i = 0; i < measurements.length; ++i) {
            if (Objects.isNull(timeValuePairs[i])) {
                if (!invalidateNull) continue;
                diff.addAndGet(-((int)RamUsageEstimator.sizeOf((String)measurements[i]) + DeviceLastCache.getTvPairEntrySize(this.measurement2CachedLastMap.remove(measurements[i]))));
                continue;
            }
            int finalI = i;
            if (lastTime < timeValuePairs[i].getTimestamp()) {
                lastTime = timeValuePairs[i].getTimestamp();
            }
            this.measurement2CachedLastMap.computeIfPresent(measurements[i], (measurement, tvPair) -> {
                if (tvPair.getTimestamp() <= timeValuePairs[finalI].getTimestamp()) {
                    diff.addAndGet(DeviceLastCache.getDiffSize(tvPair, timeValuePairs[finalI]));
                    return timeValuePairs[finalI];
                }
                return tvPair;
            });
        }
        long finalLastTime = lastTime;
        this.measurement2CachedLastMap.computeIfPresent("", (time, tvPair) -> tvPair.getTimestamp() < finalLastTime ? new TimeValuePair(finalLastTime, EMPTY_PRIMITIVE_TYPE) : tvPair);
        return diff.get();
    }

    @GuardedBy(value="DataRegionInsertLock#writeLock")
    int invalidate(String measurement) {
        AtomicInteger diff = new AtomicInteger();
        AtomicLong time = new AtomicLong();
        this.measurement2CachedLastMap.computeIfPresent(measurement, (s, timeValuePair) -> {
            diff.set((int)RamUsageEstimator.sizeOf((String)s) + DeviceLastCache.getTvPairEntrySize(timeValuePair));
            time.set(timeValuePair.getTimestamp());
            return null;
        });
        if (diff.get() == 0) {
            return 0;
        }
        this.measurement2CachedLastMap.computeIfPresent("", (s, timeValuePair) -> {
            if (timeValuePair.getTimestamp() <= time.get()) {
                diff.addAndGet((int)RamUsageEstimator.sizeOf((String)s) + DeviceLastCache.getTvPairEntrySize(timeValuePair));
                return null;
            }
            return timeValuePair;
        });
        return diff.get();
    }

    private static int getTvPairEntrySize(TimeValuePair tvPair) {
        return (int)RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + DeviceLastCache.getTvPairSize(tvPair);
    }

    private static int getTvPairSize(TimeValuePair tvPair) {
        return DeviceLastCache.isEmptyTvPair(tvPair) ? 0 : tvPair.getSize();
    }

    private static boolean isEmptyTvPair(TimeValuePair tvPair) {
        return Objects.isNull(tvPair) || tvPair == PLACEHOLDER_TIME_VALUE_PAIR || tvPair == EMPTY_TIME_VALUE_PAIR;
    }

    @Nullable
    TimeValuePair getTimeValuePair(@Nonnull String measurement) {
        TimeValuePair result = this.measurement2CachedLastMap.get(measurement);
        return result != PLACEHOLDER_TIME_VALUE_PAIR ? result : null;
    }

    int estimateSize() {
        return INSTANCE_SIZE + (int)RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY * this.measurement2CachedLastMap.size() + this.measurement2CachedLastMap.entrySet().stream().mapToInt(entry -> (int)RamUsageEstimator.sizeOf((String)((String)entry.getKey())) + DeviceLastCache.getTvPairSize((TimeValuePair)entry.getValue())).reduce(0, Integer::sum);
    }

    private static int getDiffSize(TimeValuePair oldTimeValuePair, TimeValuePair newTimeValuePair) {
        if (DeviceLastCache.isEmptyTvPair(oldTimeValuePair)) {
            return DeviceLastCache.getTvPairSize(newTimeValuePair);
        }
        if (DeviceLastCache.isEmptyTvPair(newTimeValuePair)) {
            return -DeviceLastCache.getTvPairSize(oldTimeValuePair);
        }
        TsPrimitiveType oldValue = oldTimeValuePair.getValue();
        TsPrimitiveType newValue = newTimeValuePair.getValue();
        if (oldValue == null) {
            return newValue == null ? 0 : newValue.getSize();
        }
        if (oldValue instanceof TsPrimitiveType.TsBinary) {
            return (newValue == null ? 0 : newValue.getSize()) - oldValue.getSize();
        }
        return newValue == null ? -oldValue.getSize() : 0;
    }
}

