/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.message;

import avro.shaded.com.google.common.collect.MapMaker;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;

public interface SchemaStore {
    public Schema findByFingerprint(long var1);

    public static class Cache
    implements SchemaStore {
        private final Map<Long, Schema> schemas = new MapMaker().makeMap();

        public void addSchema(Schema schema) {
            long fp = SchemaNormalization.parsingFingerprint64(schema);
            this.schemas.put(fp, schema);
        }

        @Override
        public Schema findByFingerprint(long fingerprint) {
            return this.schemas.get(fingerprint);
        }
    }
}

