/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.expression.ArithmeticBytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import java.util.List;
import java.util.Objects;

class NegateBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression value;
    private final OpCode negateOpCode;

    NegateBytecodeExpression(BytecodeExpression value) {
        super(Objects.requireNonNull(value, "value is null").getType());
        this.value = value;
        Class<?> type = value.getType().getPrimitiveType();
        BytecodeUtils.checkArgument(type != null, "value is not a primitive", new Object[0]);
        BytecodeUtils.checkArgument(type != Void.TYPE, "value is void", new Object[0]);
        BytecodeUtils.checkArgument(type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE, "value argument must be int, long, float, or double, but is %s", type);
        this.negateOpCode = ArithmeticBytecodeExpression.getNumericOpCode("Negate", OpCode.INEG, type);
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.value).append(this.negateOpCode);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of(this.value);
    }

    @Override
    protected String formatOneLine() {
        return "-(" + String.valueOf(this.value) + ")";
    }
}

