/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.deployment.uri.scanners;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiThread;
import org.apache.ignite.spi.deployment.uri.scanners.GridUriDeploymentScannerListener;
import org.apache.ignite.spi.deployment.uri.scanners.UriDeploymentScanner;
import org.apache.ignite.spi.deployment.uri.scanners.UriDeploymentScannerContext;

public class UriDeploymentScannerManager
implements UriDeploymentScannerContext {
    private final String igniteInstanceName;
    @GridToStringExclude
    private final URI uri;
    private final File deployDir;
    private final long freq;
    private final FilenameFilter filter;
    private final GridUriDeploymentScannerListener lsnr;
    private final IgniteLogger log;
    private final UriDeploymentScanner scanner;
    private IgniteSpiThread scannerThread;
    private boolean firstScan = true;

    public UriDeploymentScannerManager(String igniteInstanceName, URI uri, File deployDir, long freq, FilenameFilter filter, GridUriDeploymentScannerListener lsnr, IgniteLogger log, UriDeploymentScanner scanner) {
        assert (uri != null);
        assert (freq > 0L);
        assert (deployDir != null);
        assert (filter != null);
        assert (log != null);
        assert (lsnr != null);
        assert (scanner != null);
        this.igniteInstanceName = igniteInstanceName;
        this.uri = uri;
        this.deployDir = deployDir;
        this.freq = freq;
        this.filter = filter;
        this.log = log.getLogger(this.getClass());
        this.lsnr = lsnr;
        this.scanner = scanner;
    }

    public void start() {
        this.scannerThread = new IgniteSpiThread(this.igniteInstanceName, "grid-uri-scanner", this.log){

            protected void body() throws InterruptedException {
                try {
                    while (!this.isInterrupted()) {
                        try {
                            UriDeploymentScannerManager.this.scanner.scan(UriDeploymentScannerManager.this);
                        }
                        catch (Exception e) {
                            UriDeploymentScannerManager.this.log.error("Uncaught error in URI deployment scanner", (Throwable)e);
                        }
                        finally {
                            if (UriDeploymentScannerManager.this.firstScan) {
                                UriDeploymentScannerManager.this.firstScan = false;
                                UriDeploymentScannerManager.this.lsnr.onFirstScanFinished();
                            }
                        }
                        Thread.sleep(UriDeploymentScannerManager.this.freq);
                    }
                }
                finally {
                    if (UriDeploymentScannerManager.this.firstScan) {
                        UriDeploymentScannerManager.this.firstScan = false;
                        UriDeploymentScannerManager.this.lsnr.onFirstScanFinished();
                    }
                }
            }
        };
        this.scannerThread.start();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Grid URI deployment scanner started: " + this);
        }
    }

    public void cancel() {
        U.interrupt((Thread)this.scannerThread);
    }

    public void join() {
        U.join((Thread)this.scannerThread, (IgniteLogger)this.log);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Grid URI deployment scanner stopped: " + this);
        }
    }

    @Override
    public boolean isCancelled() {
        assert (this.scannerThread != null);
        return this.scannerThread.isInterrupted();
    }

    @Override
    public File createTempFile(String fileName, File tmpDir) throws IOException {
        assert (fileName != null);
        int idx = fileName.lastIndexOf(46);
        if (idx == -1) {
            idx = fileName.length();
        }
        Object prefix = fileName.substring(0, idx);
        if (idx < 3) {
            prefix = (String)prefix + "___";
        }
        String suffix = fileName.substring(idx);
        return File.createTempFile((String)prefix, suffix, tmpDir);
    }

    @Override
    public boolean isFirstScan() {
        return this.firstScan;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public File getDeployDirectory() {
        return this.deployDir;
    }

    @Override
    public FilenameFilter getFilter() {
        return this.filter;
    }

    @Override
    public GridUriDeploymentScannerListener getListener() {
        return this.lsnr;
    }

    @Override
    public IgniteLogger getLogger() {
        return this.log;
    }

    public String toString() {
        return S.toString(UriDeploymentScannerManager.class, (Object)this, (String)"uri", (Object)U.hidePassword((String)this.uri.toString()));
    }
}

