/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.springframework.boot.logging.StackTracePrinter;
import org.springframework.util.Assert;

class Extractor {
    private final StackTracePrinter stackTracePrinter;

    Extractor(StackTracePrinter stackTracePrinter) {
        this.stackTracePrinter = stackTracePrinter;
    }

    String messageAndStackTrace(LogEvent event) {
        return event.getMessage().getFormattedMessage() + "\n\n" + this.stackTrace(event);
    }

    String stackTrace(LogEvent event) {
        return this.stackTrace(event.getThrownProxy());
    }

    String stackTrace(ThrowableProxy throwableProxy) {
        if (throwableProxy == null) {
            return null;
        }
        if (this.stackTracePrinter != null) {
            Throwable throwable = throwableProxy.getThrowable();
            Assert.state(throwable != null, "Proxy must return Throwable in order to print exception");
            return this.stackTracePrinter.printStackTraceToString(throwable);
        }
        return throwableProxy.getExtendedStackTraceAsString();
    }
}

