/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.grails.datastore.gorm.jdbc.OriginCapablePropertyValue;
import org.grails.datastore.gorm.jdbc.PropertyOrigin;
import org.grails.datastore.gorm.jdbc.RelaxedConversionService;
import org.grails.datastore.gorm.jdbc.RelaxedNames;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

class RelaxedDataBinder
extends DataBinder {
    private static final Object BLANK = new Object();
    private String namePrefix;
    private boolean ignoreNestedProperties;
    private MultiValueMap<String, String> nameAliases = new LinkedMultiValueMap<String, String>();

    RelaxedDataBinder(Object target) {
        super(RelaxedDataBinder.wrapTarget(target));
    }

    public RelaxedDataBinder withAlias(String name, String ... alias) {
        for (String value : alias) {
            this.nameAliases.add(name, value);
        }
        return this;
    }

    @Override
    protected void doBind(MutablePropertyValues propertyValues) {
        super.doBind(this.modifyProperties(propertyValues, this.getTarget()));
    }

    private MutablePropertyValues modifyProperties(MutablePropertyValues propertyValues, Object target) {
        propertyValues = this.getPropertyValuesForNamePrefix(propertyValues);
        if (target instanceof MapHolder) {
            propertyValues = this.addMapPrefix(propertyValues);
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(target);
        wrapper.setConversionService(new RelaxedConversionService(this.getConversionService()));
        wrapper.setAutoGrowNestedPaths(true);
        ArrayList<PropertyValue> sortedValues = new ArrayList<PropertyValue>();
        HashSet<String> modifiedNames = new HashSet<String>();
        List<String> sortedNames = this.getSortedPropertyNames(propertyValues);
        for (String name : sortedNames) {
            PropertyValue propertyValue = propertyValues.getPropertyValue(name);
            PropertyValue modifiedProperty = this.modifyProperty(wrapper, propertyValue);
            if (!modifiedNames.add(modifiedProperty.getName())) continue;
            sortedValues.add(modifiedProperty);
        }
        return new MutablePropertyValues(sortedValues);
    }

    private List<String> getSortedPropertyNames(MutablePropertyValues propertyValues) {
        LinkedList<String> names = new LinkedList<String>();
        for (PropertyValue propertyValue : propertyValues.getPropertyValueList()) {
            names.add(propertyValue.getName());
        }
        this.sortPropertyNames(names);
        return names;
    }

    private void sortPropertyNames(List<String> names) {
        for (String name : new ArrayList<String>(names)) {
            int propertyIndex = names.indexOf(name);
            BeanPath path = new BeanPath(name);
            for (String prefix : path.prefixes()) {
                int prefixIndex = names.indexOf(prefix);
                if (prefixIndex < propertyIndex) continue;
                names.remove(name);
                names.add(prefixIndex, name);
            }
        }
    }

    private MutablePropertyValues addMapPrefix(MutablePropertyValues propertyValues) {
        MutablePropertyValues rtn = new MutablePropertyValues();
        for (PropertyValue pv : propertyValues.getPropertyValues()) {
            rtn.add("map." + pv.getName(), pv.getValue());
        }
        return rtn;
    }

    private MutablePropertyValues getPropertyValuesForNamePrefix(MutablePropertyValues propertyValues) {
        if (!StringUtils.hasText(this.namePrefix) && !this.ignoreNestedProperties) {
            return propertyValues;
        }
        MutablePropertyValues rtn = new MutablePropertyValues();
        for (PropertyValue value : propertyValues.getPropertyValues()) {
            String name = value.getName();
            for (String prefix : new RelaxedNames(this.stripLastDot(this.namePrefix))) {
                for (String separator : new String[]{".", "_"}) {
                    String candidate;
                    String string = candidate = StringUtils.hasLength(prefix) ? prefix + separator : prefix;
                    if (!name.startsWith(candidate)) continue;
                    name = name.substring(candidate.length());
                    if (this.ignoreNestedProperties && name.contains(".")) continue;
                    PropertyOrigin propertyOrigin = OriginCapablePropertyValue.getOrigin(value);
                    rtn.addPropertyValue(new OriginCapablePropertyValue(name, value.getValue(), propertyOrigin));
                }
            }
        }
        return rtn;
    }

    private String stripLastDot(String string) {
        if (StringUtils.hasLength(string) && string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private PropertyValue modifyProperty(BeanWrapper target, PropertyValue propertyValue) {
        String name = propertyValue.getName();
        String normalizedName = this.normalizePath(target, name);
        if (!normalizedName.equals(name)) {
            return new PropertyValue(normalizedName, propertyValue.getValue());
        }
        return propertyValue;
    }

    private String normalizePath(BeanWrapper wrapper, String path) {
        return this.initializePath(wrapper, new BeanPath(path), 0);
    }

    private String initializePath(BeanWrapper wrapper, BeanPath path, int index2) {
        String prefix = path.prefix(index2);
        String key = path.name(index2);
        if (path.isProperty(index2)) {
            key = this.getActualPropertyName(wrapper, prefix, key);
            path.rename(index2, key);
        }
        if (path.name(++index2) == null) {
            return path.toString();
        }
        String name = path.prefix(index2);
        TypeDescriptor descriptor = wrapper.getPropertyTypeDescriptor(name);
        if (descriptor == null || descriptor.isMap()) {
            if (this.isMapValueStringType(descriptor) || this.isBlanked(wrapper, name, path.name(index2))) {
                path.collapseKeys(index2);
            }
            path.mapIndex(index2);
            this.extendMapIfNecessary(wrapper, path, index2);
        } else if (descriptor.isCollection()) {
            this.extendCollectionIfNecessary(wrapper, path, index2);
        } else if (descriptor.getType().equals(Object.class)) {
            if (this.isBlanked(wrapper, name, path.name(index2))) {
                path.collapseKeys(index2);
            }
            path.mapIndex(index2);
            if (path.isLastNode(index2)) {
                wrapper.setPropertyValue(path.toString(), BLANK);
            } else {
                String next = path.prefix(index2 + 1);
                if (wrapper.getPropertyValue(next) == null) {
                    wrapper.setPropertyValue(next, new LinkedHashMap());
                }
            }
        }
        return this.initializePath(wrapper, path, index2);
    }

    private boolean isMapValueStringType(TypeDescriptor descriptor) {
        if (descriptor == null || descriptor.getMapValueTypeDescriptor() == null) {
            return false;
        }
        if (Properties.class.isAssignableFrom(descriptor.getObjectType())) {
            return true;
        }
        Class<?> valueType = descriptor.getMapValueTypeDescriptor().getObjectType();
        return valueType != null && CharSequence.class.isAssignableFrom(valueType);
    }

    private boolean isBlanked(BeanWrapper wrapper, String propertyName, String key) {
        Object value;
        Object object = value = wrapper.isReadableProperty(propertyName) ? wrapper.getPropertyValue(propertyName) : null;
        return value instanceof Map && ((Map)value).get(key) == BLANK;
    }

    private void extendCollectionIfNecessary(BeanWrapper wrapper, BeanPath path, int index2) {
        String name = path.prefix(index2);
        TypeDescriptor elementDescriptor = wrapper.getPropertyTypeDescriptor(name).getElementTypeDescriptor();
        if (!(elementDescriptor.isMap() || elementDescriptor.isCollection() || elementDescriptor.getType().equals(Object.class))) {
            return;
        }
        Cloneable extend = new LinkedHashMap();
        if (!elementDescriptor.isMap() && path.isArrayIndex(index2)) {
            extend = new ArrayList();
        }
        wrapper.setPropertyValue(path.prefix(index2 + 1), extend);
    }

    private void extendMapIfNecessary(BeanWrapper wrapper, BeanPath path, int index2) {
        String name = path.prefix(index2);
        TypeDescriptor parent = wrapper.getPropertyTypeDescriptor(name);
        if (parent == null) {
            return;
        }
        TypeDescriptor descriptor = parent.getMapValueTypeDescriptor();
        if (descriptor == null) {
            descriptor = TypeDescriptor.valueOf(Object.class);
        }
        if (!(descriptor.isMap() || descriptor.isCollection() || descriptor.getType().equals(Object.class))) {
            return;
        }
        String extensionName = path.prefix(index2 + 1);
        if (wrapper.isReadableProperty(extensionName)) {
            Object currentValue = wrapper.getPropertyValue(extensionName);
            if (descriptor.isCollection() && currentValue instanceof Collection || !descriptor.isCollection() && currentValue instanceof Map) {
                return;
            }
        }
        Object extend = new LinkedHashMap();
        if (descriptor.isCollection()) {
            extend = new ArrayList();
        }
        if (descriptor.getType().equals(Object.class) && path.isLastNode(index2)) {
            extend = BLANK;
        }
        wrapper.setPropertyValue(extensionName, extend);
    }

    private String getActualPropertyName(BeanWrapper target, String prefix, String name) {
        String propertyName = this.resolvePropertyName(target, prefix, name);
        if (propertyName == null) {
            propertyName = this.resolveNestedPropertyName(target, prefix, name);
        }
        return propertyName == null ? name : propertyName;
    }

    private String resolveNestedPropertyName(BeanWrapper target, String prefix, String name) {
        StringBuilder candidate = new StringBuilder();
        for (String field : name.split("[_\\-\\.]")) {
            candidate.append(candidate.length() > 0 ? "." : "");
            candidate.append(field);
            String nested = this.resolvePropertyName(target, prefix, candidate.toString());
            if (nested == null) continue;
            Class<?> type = target.getPropertyType(nested);
            if (type != null && Map.class.isAssignableFrom(type)) {
                return nested + "[" + name.substring(candidate.length() + 1) + "]";
            }
            String propertyName = this.resolvePropertyName(target, this.joinString(prefix, nested), name.substring(candidate.length() + 1));
            if (propertyName == null) continue;
            return this.joinString(nested, propertyName);
        }
        return null;
    }

    private String resolvePropertyName(BeanWrapper target, String prefix, String name) {
        Iterable<String> names = this.getNameAndAliases(name);
        for (String nameOrAlias : names) {
            for (String candidate : new RelaxedNames(nameOrAlias)) {
                try {
                    if (target.getPropertyType(this.joinString(prefix, candidate)) == null) continue;
                    return candidate;
                }
                catch (InvalidPropertyException invalidPropertyException) {
                }
            }
        }
        return null;
    }

    private String joinString(String prefix, String name) {
        return StringUtils.hasLength(prefix) ? prefix + "." + name : name;
    }

    private Iterable<String> getNameAndAliases(String name) {
        List aliases = (List)this.nameAliases.get(name);
        if (aliases == null) {
            return Collections.singleton(name);
        }
        ArrayList<String> nameAndAliases = new ArrayList<String>(aliases.size() + 1);
        nameAndAliases.add(name);
        nameAndAliases.addAll(aliases);
        return nameAndAliases;
    }

    private static Object wrapTarget(Object target) {
        if (target instanceof Map) {
            Map map = (Map)target;
            target = new MapHolder(map);
        }
        return target;
    }

    static class MapHolder {
        private Map<String, Object> map;

        MapHolder(Map<String, Object> map) {
            this.map = map;
        }

        public void setMap(Map<String, Object> map) {
            this.map = map;
        }

        public Map<String, Object> getMap() {
            return this.map;
        }
    }

    private static class BeanPath {
        private List<PathNode> nodes;

        BeanPath(String path) {
            this.nodes = this.splitPath(path);
        }

        List<String> prefixes() {
            ArrayList<String> prefixes = new ArrayList<String>();
            for (int index2 = 1; index2 < this.nodes.size(); ++index2) {
                prefixes.add(this.prefix(index2));
            }
            return prefixes;
        }

        boolean isLastNode(int index2) {
            return index2 >= this.nodes.size() - 1;
        }

        private List<PathNode> splitPath(String path) {
            ArrayList<PathNode> nodes = new ArrayList<PathNode>();
            String current = this.extractIndexedPaths(path, nodes);
            for (String name : StringUtils.delimitedListToStringArray(current, ".")) {
                if (!StringUtils.hasText(name)) continue;
                nodes.add(new PropertyNode(name));
            }
            return nodes;
        }

        private String extractIndexedPaths(String path, List<PathNode> nodes) {
            int startRef = path.indexOf("[");
            String current = path;
            while (startRef >= 0) {
                int endRef;
                if (startRef > 0) {
                    nodes.addAll(this.splitPath(current.substring(0, startRef)));
                }
                if ((endRef = current.indexOf("]", startRef)) > 0) {
                    String sub = current.substring(startRef + 1, endRef);
                    if (sub.matches("[0-9]+")) {
                        nodes.add(new ArrayIndexNode(sub));
                    } else {
                        nodes.add(new MapIndexNode(sub));
                    }
                }
                current = current.substring(endRef + 1);
                startRef = current.indexOf("[");
            }
            return current;
        }

        void collapseKeys(int index2) {
            ArrayList<PathNode> revised = new ArrayList<PathNode>();
            for (int i2 = 0; i2 < index2; ++i2) {
                revised.add(this.nodes.get(i2));
            }
            StringBuilder builder = new StringBuilder();
            for (int i3 = index2; i3 < this.nodes.size(); ++i3) {
                if (i3 > index2) {
                    builder.append(".");
                }
                builder.append(this.nodes.get((int)i3).name);
            }
            revised.add(new PropertyNode(builder.toString()));
            this.nodes = revised;
        }

        void mapIndex(int index2) {
            PathNode node = this.nodes.get(index2);
            if (node instanceof PropertyNode) {
                node = ((PropertyNode)node).mapIndex();
            }
            this.nodes.set(index2, node);
        }

        String prefix(int index2) {
            return this.range(0, index2);
        }

        void rename(int index2, String name) {
            this.nodes.get((int)index2).name = name;
        }

        public String name(int index2) {
            if (index2 < this.nodes.size()) {
                return this.nodes.get((int)index2).name;
            }
            return null;
        }

        private String range(int start, int end) {
            StringBuilder builder = new StringBuilder();
            for (int i2 = start; i2 < end; ++i2) {
                PathNode node = this.nodes.get(i2);
                builder.append(node);
            }
            if (builder.toString().startsWith(".")) {
                builder.replace(0, 1, "");
            }
            return builder.toString();
        }

        boolean isArrayIndex(int index2) {
            return this.nodes.get(index2) instanceof ArrayIndexNode;
        }

        boolean isProperty(int index2) {
            return this.nodes.get(index2) instanceof PropertyNode;
        }

        public String toString() {
            return this.prefix(this.nodes.size());
        }

        private static class PropertyNode
        extends PathNode {
            PropertyNode(String name) {
                super(name);
            }

            MapIndexNode mapIndex() {
                return new MapIndexNode(this.name);
            }

            public String toString() {
                return "." + this.name;
            }
        }

        private static class ArrayIndexNode
        extends PathNode {
            ArrayIndexNode(String name) {
                super(name);
            }

            public String toString() {
                return "[" + this.name + "]";
            }
        }

        private static class MapIndexNode
        extends PathNode {
            MapIndexNode(String name) {
                super(name);
            }

            public String toString() {
                return "[" + this.name + "]";
            }
        }

        private static class PathNode {
            protected String name;

            PathNode(String name) {
                this.name = name;
            }
        }
    }
}

