/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.LongStream;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.ClockBlockCacheTable;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheConfig;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheTable;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;

public final class DfsBlockCache {
    private static volatile DfsBlockCache cache;
    private final DfsBlockCacheTable dfsBlockCacheTable;
    private final long maxBytes;
    private final long maxStreamThroughCache;
    private final int blockSize;
    private final int[] cacheHotLimits = new int[PackExt.values().length];

    static {
        DfsBlockCache.reconfigure(new DfsBlockCacheConfig());
    }

    public static void reconfigure(DfsBlockCacheConfig cfg) {
        cache = new DfsBlockCache(cfg);
    }

    public static DfsBlockCache getInstance() {
        return cache;
    }

    private DfsBlockCache(DfsBlockCacheConfig cfg) {
        this.maxBytes = cfg.getBlockLimit();
        this.blockSize = cfg.getBlockSize();
        double streamRatio = cfg.getStreamRatio();
        this.maxStreamThroughCache = (long)((double)this.maxBytes * streamRatio);
        this.dfsBlockCacheTable = new ClockBlockCacheTable(cfg);
        int i2 = 0;
        while (i2 < PackExt.values().length) {
            Integer limit = cfg.getCacheHotMap().get((Object)PackExt.values()[i2]);
            this.cacheHotLimits[i2] = limit != null && limit > 0 ? limit : 1;
            ++i2;
        }
    }

    boolean shouldCopyThroughCache(long length) {
        return length <= this.maxStreamThroughCache;
    }

    public long[] getCurrentSize() {
        return this.dfsBlockCacheTable.getDfsBlockCacheStats().getCurrentSize();
    }

    public long getFillPercentage() {
        return LongStream.of(this.getCurrentSize()).sum() * 100L / this.maxBytes;
    }

    public long[] getHitCount() {
        return this.dfsBlockCacheTable.getDfsBlockCacheStats().getHitCount();
    }

    public long[] getMissCount() {
        return this.dfsBlockCacheTable.getDfsBlockCacheStats().getMissCount();
    }

    public long[] getTotalRequestCount() {
        return this.dfsBlockCacheTable.getDfsBlockCacheStats().getTotalRequestCount();
    }

    public long[] getHitRatio() {
        return this.dfsBlockCacheTable.getDfsBlockCacheStats().getHitRatio();
    }

    public long[] getEvictions() {
        return this.dfsBlockCacheTable.getDfsBlockCacheStats().getEvictions();
    }

    public boolean hasBlock0(DfsStreamKey key) {
        return this.dfsBlockCacheTable.hasBlock0(key);
    }

    int getBlockSize() {
        return this.blockSize;
    }

    DfsBlock getOrLoad(BlockBasedFile file, long position, DfsReader ctx, ReadableChannelSupplier fileChannel) throws IOException {
        return this.dfsBlockCacheTable.getOrLoad(file, position, ctx, fileChannel);
    }

    void put(DfsBlock v) {
        this.dfsBlockCacheTable.put(v);
    }

    <T> Ref<T> getOrLoadRef(DfsStreamKey key, long position, RefLoader<T> loader) throws IOException {
        return this.dfsBlockCacheTable.getOrLoadRef(key, position, loader);
    }

    <T> Ref<T> putRef(DfsStreamKey key, long size, T v) {
        return this.dfsBlockCacheTable.putRef(key, size, v);
    }

    <T> Ref<T> put(DfsStreamKey key, long pos, long size, T v) {
        return this.dfsBlockCacheTable.put(key, pos, size, v);
    }

    boolean contains(DfsStreamKey key, long position) {
        return this.dfsBlockCacheTable.contains(key, position);
    }

    <T> T get(DfsStreamKey key, long position) {
        return this.dfsBlockCacheTable.get(key, position);
    }

    @FunctionalInterface
    static interface ReadableChannelSupplier {
        public ReadableChannel get() throws IOException;
    }

    static final class Ref<T> {
        final DfsStreamKey key;
        final long position;
        final long size;
        volatile T value;
        Ref next;
        private volatile int hotCount;
        private final AtomicInteger totalHitCount = new AtomicInteger();

        Ref(DfsStreamKey key, long position, long size, T v) {
            this.key = key;
            this.position = position;
            this.size = size;
            this.value = v;
        }

        T get() {
            T v = this.value;
            if (v != null) {
                this.markHotter();
            }
            return v;
        }

        boolean has() {
            return this.value != null;
        }

        void markHotter() {
            int cap = DfsBlockCache.getInstance().cacheHotLimits[this.key.packExtPos];
            this.hotCount = Math.min(cap, this.hotCount + 1);
            this.totalHitCount.incrementAndGet();
        }

        void markColder() {
            this.hotCount = Math.max(0, this.hotCount - 1);
        }

        boolean isHot() {
            return this.hotCount > 0;
        }

        int getTotalHitCount() {
            return this.totalHitCount.get();
        }
    }

    @FunctionalInterface
    static interface RefLoader<T> {
        public Ref<T> load() throws IOException;
    }
}

