/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.time.Clock;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.download.FileDownloadResult;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadFailureResult;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadFinishEvent;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadOperationDescriptor;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadStartEvent;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadSuccessResult;
import org.gradle.tooling.events.internal.DefaultStatusEvent;
import org.gradle.tooling.internal.consumer.DefaultFailure;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.DownloadProgressListener;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.Logger;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;

public class DistributionInstaller {
    private static final String APP_NAME = "Gradle Tooling API";
    private static final InternalBuildProgressListener NO_OP = new NoOpListener();
    private final ProgressLoggerFactory progressLoggerFactory;
    private final InternalBuildProgressListener buildProgressListener;
    private final Clock clock;
    private final AtomicReference<InternalBuildProgressListener> currentListener = new AtomicReference<InternalBuildProgressListener>(NO_OP);
    private final Object lock = new Object();
    private boolean completed;
    private boolean cancelled;
    private Throwable failure;
    private final int timeout;

    public DistributionInstaller(ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener buildProgressListener, Clock clock, int timeout) {
        this.progressLoggerFactory = progressLoggerFactory;
        this.buildProgressListener = this.getListener(buildProgressListener);
        this.clock = clock;
        this.timeout = timeout;
    }

    private InternalBuildProgressListener getListener(InternalBuildProgressListener buildProgressListener) {
        if (buildProgressListener.getSubscribedOperations().contains("FILE_DOWNLOAD")) {
            return buildProgressListener;
        }
        return NO_OP;
    }

    public File install(File userHomeDir, File projectDir, WrapperConfiguration wrapperConfiguration, Map<String, String> systemProperties) throws Exception {
        Install install = new Install(new Logger(false), new AsyncDownload(systemProperties), new PathAssembler(userHomeDir, projectDir));
        return install.createDist(wrapperConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelled = true;
            this.lock.notifyAll();
        }
    }

    private class AsyncDownload
    implements IDownload {
        private final Map<String, String> systemProperties;

        public AsyncDownload(Map<String, String> systemProperties) {
            this.systemProperties = systemProperties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void download(URI address, File destination) throws Exception {
            Object object = DistributionInstaller.this.lock;
            synchronized (object) {
                this.doDownload(address, destination);
            }
        }

        private void doDownload(URI address, File destination) throws Exception {
            String displayName = "Download " + address;
            DefaultFileDownloadOperationDescriptor descriptor = new DefaultFileDownloadOperationDescriptor(displayName, address, null);
            long startTime = DistributionInstaller.this.clock.getCurrentTime();
            DistributionInstaller.this.buildProgressListener.onEvent(new DefaultFileDownloadStartEvent(startTime, displayName + " started", descriptor));
            Throwable failure = null;
            long bytesDownloaded = 0L;
            try {
                bytesDownloaded = this.withProgressLogging(address, destination, descriptor);
            }
            catch (Throwable t) {
                failure = t;
            }
            long endTime = DistributionInstaller.this.clock.getCurrentTime();
            FileDownloadResult result = failure == null ? new DefaultFileDownloadSuccessResult(startTime, endTime, bytesDownloaded) : new DefaultFileDownloadFailureResult(startTime, endTime, Collections.singletonList(DefaultFailure.fromThrowable(failure)), bytesDownloaded);
            DistributionInstaller.this.buildProgressListener.onEvent(new DefaultFileDownloadFinishEvent(endTime, displayName + " finished", descriptor, result));
            if (failure != null) {
                if (failure instanceof Exception) {
                    throw (Exception)failure;
                }
                throw UncheckedException.throwAsUncheckedException(failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long withProgressLogging(URI address, File destination, OperationDescriptor operationDescriptor) throws Throwable {
            ProgressLogger progressLogger = DistributionInstaller.this.progressLoggerFactory.newOperation(DistributionInstaller.class);
            progressLogger.setDescription("Download " + address);
            progressLogger.started();
            try {
                long l = this.withAsyncDownload(address, destination, operationDescriptor);
                return l;
            }
            finally {
                progressLogger.completed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long withAsyncDownload(final URI address, final File destination, OperationDescriptor operationDescriptor) throws Throwable {
            final ForwardingDownloadProgressListener listener = new ForwardingDownloadProgressListener(operationDescriptor);
            DistributionInstaller.this.currentListener.set(DistributionInstaller.this.buildProgressListener);
            try {
                Thread thread = new Thread("Distribution download"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            new Download(new Logger(false), listener, DistributionInstaller.APP_NAME, GradleVersion.current().getVersion(), AsyncDownload.this.systemProperties, DistributionInstaller.this.timeout).download(address, destination);
                        }
                        catch (Throwable t) {
                            Object object = DistributionInstaller.this.lock;
                            synchronized (object) {
                                DistributionInstaller.this.failure = t;
                            }
                        }
                        finally {
                            Object object = DistributionInstaller.this.lock;
                            synchronized (object) {
                                DistributionInstaller.this.completed = true;
                                DistributionInstaller.this.lock.notifyAll();
                            }
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
                Object object = DistributionInstaller.this.lock;
                synchronized (object) {
                    while (!DistributionInstaller.this.completed && !DistributionInstaller.this.cancelled) {
                        try {
                            DistributionInstaller.this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            throw UncheckedException.throwAsUncheckedException(e);
                        }
                    }
                    if (DistributionInstaller.this.failure != null) {
                        throw DistributionInstaller.this.failure;
                    }
                    if (DistributionInstaller.this.cancelled) {
                        thread.interrupt();
                        throw new CancellationException();
                    }
                }
            }
            finally {
                DistributionInstaller.this.currentListener.set(NO_OP);
            }
            return listener.downloaded;
        }
    }

    private class ForwardingDownloadProgressListener
    implements DownloadProgressListener {
        private final OperationDescriptor descriptor;
        private long downloaded = 0L;

        ForwardingDownloadProgressListener(OperationDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public void downloadStatusChanged(URI address, long contentLength, long downloaded) {
            this.downloaded = downloaded;
            DefaultStatusEvent statusEvent = new DefaultStatusEvent(DistributionInstaller.this.clock.getCurrentTime(), this.descriptor, contentLength, downloaded, "bytes");
            ((InternalBuildProgressListener)DistributionInstaller.this.currentListener.get()).onEvent(statusEvent);
        }
    }

    private static class NoOpListener
    implements InternalBuildProgressListener {
        private NoOpListener() {
        }

        @Override
        public void onEvent(Object event) {
        }

        @Override
        public List<String> getSubscribedOperations() {
            return Collections.emptyList();
        }
    }
}

