/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.util.function.ThrowingConsumer;

public final class NativeImageArgFile {
    public static final String LOCATION = "META-INF/native-image/argfile";
    private final List<String> excludes;

    public NativeImageArgFile(Collection<String> excludes) {
        this.excludes = List.copyOf(excludes);
    }

    public void writeIfNecessary(ThrowingConsumer<List<String>> writer) {
        if (this.excludes.isEmpty()) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String exclude : this.excludes) {
            int lastSlash = exclude.lastIndexOf(47);
            String jar = lastSlash != -1 ? exclude.substring(lastSlash + 1) : exclude;
            lines.add("--exclude-config");
            lines.add(Pattern.quote(jar));
            lines.add("^/META-INF/native-image/.*");
        }
        writer.accept(lines);
    }
}

