/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.databinding;

import grails.util.CollectionUtils;
import grails.util.GrailsNameUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.web.databinding.ASTDatabindingHelper;

public class DefaultASTDatabindingHelper
implements ASTDatabindingHelper {
    public static final String CONSTRAINTS_FIELD_NAME = "constraints";
    public static final String BINDABLE_CONSTRAINT_NAME = "bindable";
    public static final String DEFAULT_DATABINDING_WHITELIST = "$defaultDatabindingWhiteList";
    public static final String NO_BINDABLE_PROPERTIES = "$_NO_BINDABLE_PROPERTIES_$";
    private static Map<ClassNode, Set<String>> CLASS_NODE_TO_WHITE_LIST_PROPERTY_NAMES = new HashMap<ClassNode, Set<String>>();
    private static final List<ClassNode> SIMPLE_TYPES = new ArrayList<ClassNode>(){
        {
            this.add(new ClassNode(Boolean.class));
            this.add(new ClassNode(Boolean.TYPE));
            this.add(new ClassNode(Byte.class));
            this.add(new ClassNode(Byte.TYPE));
            this.add(new ClassNode(Character.class));
            this.add(new ClassNode(Character.TYPE));
            this.add(new ClassNode(Short.class));
            this.add(new ClassNode(Short.TYPE));
            this.add(new ClassNode(Integer.class));
            this.add(new ClassNode(Integer.TYPE));
            this.add(new ClassNode(Long.class));
            this.add(new ClassNode(Long.TYPE));
            this.add(new ClassNode(Float.class));
            this.add(new ClassNode(Float.TYPE));
            this.add(new ClassNode(Double.class));
            this.add(new ClassNode(Double.TYPE));
            this.add(new ClassNode(BigInteger.class));
            this.add(new ClassNode(BigDecimal.class));
            this.add(new ClassNode(String.class));
            this.add(new ClassNode(URL.class));
        }
    };
    private static final Set<String> DOMAIN_CLASS_PROPERTIES_TO_EXCLUDE_BY_DEFAULT = CollectionUtils.newSet("id", "version", "dateCreated", "lastUpdated");

    @Override
    public void injectDatabindingCode(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        this.addDefaultDatabindingWhitelistField(source, classNode);
    }

    private void addDefaultDatabindingWhitelistField(SourceUnit sourceUnit, ClassNode classNode) {
        FieldNode defaultWhitelistField = classNode.getDeclaredField(DEFAULT_DATABINDING_WHITELIST);
        if (defaultWhitelistField != null) {
            return;
        }
        Set<String> propertyNamesToIncludeInWhiteList = this.getPropertyNamesToIncludeInWhiteList(sourceUnit, classNode);
        ListExpression listExpression = new ListExpression();
        if (propertyNamesToIncludeInWhiteList.size() > 0) {
            for (String propertyName : propertyNamesToIncludeInWhiteList) {
                ClassNode type;
                listExpression.addExpression(new ConstantExpression(propertyName));
                FieldNode declaredField = this.getDeclaredFieldInInheritanceHierarchy(classNode, propertyName);
                boolean isSimpleType = false;
                if (declaredField != null && (type = declaredField.getType()) != null) {
                    isSimpleType = SIMPLE_TYPES.contains(type);
                }
                if (isSimpleType) continue;
                listExpression.addExpression(new ConstantExpression(propertyName + "_*"));
                listExpression.addExpression(new ConstantExpression(propertyName + ".*"));
            }
        } else {
            listExpression.addExpression(new ConstantExpression(NO_BINDABLE_PROPERTIES));
        }
        classNode.addField(DEFAULT_DATABINDING_WHITELIST, 25, new ClassNode(List.class), listExpression);
    }

    private FieldNode getDeclaredFieldInInheritanceHierarchy(ClassNode classNode, String propertyName) {
        FieldNode fieldNode = classNode.getDeclaredField(propertyName);
        if (fieldNode == null && !classNode.getSuperClass().equals(new ClassNode(Object.class))) {
            return this.getDeclaredFieldInInheritanceHierarchy(classNode.getSuperClass(), propertyName);
        }
        return fieldNode;
    }

    private Set<String> getPropertyNamesToIncludeInWhiteListForParentClass(SourceUnit sourceUnit, ClassNode parentClassNode) {
        Set<String> propertyNames = CLASS_NODE_TO_WHITE_LIST_PROPERTY_NAMES.containsKey(parentClassNode) ? CLASS_NODE_TO_WHITE_LIST_PROPERTY_NAMES.get(parentClassNode) : this.getPropertyNamesToIncludeInWhiteList(sourceUnit, parentClassNode);
        return propertyNames;
    }

    private Set<String> getPropertyNamesToIncludeInWhiteList(SourceUnit sourceUnit, ClassNode classNode) {
        Expression constraintsInitialExpression;
        FieldNode constraintsFieldNode;
        HashSet<String> propertyNamesToIncludeInWhiteList = new HashSet<String>();
        HashSet<String> unbindablePropertyNames = new HashSet<String>();
        HashSet<String> bindablePropertyNames = new HashSet<String>();
        if (!classNode.getSuperClass().equals(new ClassNode(Object.class))) {
            Set<String> parentClassPropertyNames = this.getPropertyNamesToIncludeInWhiteListForParentClass(sourceUnit, classNode.getSuperClass());
            bindablePropertyNames.addAll(parentClassPropertyNames);
        }
        if ((constraintsFieldNode = classNode.getDeclaredField(CONSTRAINTS_FIELD_NAME)) != null && constraintsFieldNode.hasInitialExpression() && (constraintsInitialExpression = constraintsFieldNode.getInitialExpression()) instanceof ClosureExpression) {
            Map<String, Map<String, Expression>> constraintsInfo = GrailsASTUtils.getConstraintMetadata((ClosureExpression)constraintsInitialExpression);
            for (Map.Entry<String, Map<String, Expression>> entry : constraintsInfo.entrySet()) {
                String string = entry.getKey();
                Map<String, Expression> map = entry.getValue();
                for (Map.Entry<String, Expression> entry2 : map.entrySet()) {
                    Object constantValue;
                    String constraintName = entry2.getKey();
                    if (!BINDABLE_CONSTRAINT_NAME.equals(constraintName)) continue;
                    Expression valueExpression = entry2.getValue();
                    Boolean bindableValue = null;
                    if (valueExpression instanceof ConstantExpression && (constantValue = ((ConstantExpression)valueExpression).getValue()) instanceof Boolean) {
                        bindableValue = (Boolean)constantValue;
                    }
                    if (bindableValue != null) {
                        if (Boolean.TRUE.equals(bindableValue)) {
                            unbindablePropertyNames.remove(string);
                            bindablePropertyNames.add(string);
                            continue;
                        }
                        bindablePropertyNames.remove(string);
                        unbindablePropertyNames.add(string);
                        continue;
                    }
                    GrailsASTUtils.warning(sourceUnit, valueExpression, "The bindable constraint for property [" + string + "] in class [" + classNode.getName() + "] has a value which is not a boolean literal and will be ignored.");
                }
            }
        }
        Set<String> fieldsInTransientsList = this.getPropertyNamesExpressedInTransientsList(classNode);
        boolean isDomainClass = GrailsASTUtils.isDomainClass(classNode, sourceUnit);
        propertyNamesToIncludeInWhiteList.addAll(bindablePropertyNames);
        List<FieldNode> fields = classNode.getFields();
        for (FieldNode fieldNode : fields) {
            String string = fieldNode.getName();
            if (unbindablePropertyNames.contains(string) || !bindablePropertyNames.contains(string) && !this.shouldFieldBeInWhiteList(fieldNode, fieldsInTransientsList, isDomainClass)) continue;
            propertyNamesToIncludeInWhiteList.add(string);
        }
        Map<String, MethodNode> map = classNode.getDeclaredMethodsMap();
        for (Map.Entry<String, MethodNode> entry : map.entrySet()) {
            String restOfMethodName;
            String propertyName;
            Parameter parameter;
            ClassNode paramType;
            String methodName;
            Parameter[] parameters;
            MethodNode value = entry.getValue();
            if (!classNode.equals(value.getDeclaringClass()) || (parameters = value.getParameters()) == null || parameters.length != 1 || !(methodName = value.getName()).startsWith("set") || (paramType = (parameter = parameters[0]).getType()).equals(new ClassNode(Object.class)) || unbindablePropertyNames.contains(propertyName = GrailsNameUtils.getPropertyName(restOfMethodName = methodName.substring(3))) || isDomainClass && DOMAIN_CLASS_PROPERTIES_TO_EXCLUDE_BY_DEFAULT.contains(propertyName)) continue;
            propertyNamesToIncludeInWhiteList.add(propertyName);
        }
        CLASS_NODE_TO_WHITE_LIST_PROPERTY_NAMES.put(classNode, propertyNamesToIncludeInWhiteList);
        Map<String, ClassNode> map2 = GrailsASTUtils.getAllAssociationMap(classNode);
        for (String associationName : map2.keySet()) {
            if (propertyNamesToIncludeInWhiteList.contains(associationName) || unbindablePropertyNames.contains(associationName)) continue;
            propertyNamesToIncludeInWhiteList.add(associationName);
        }
        return propertyNamesToIncludeInWhiteList;
    }

    private boolean shouldFieldBeInWhiteList(FieldNode fieldNode, Set<String> fieldsInTransientsList, boolean isDomainClass) {
        boolean shouldInclude = true;
        int modifiers = fieldNode.getModifiers();
        String fieldName = fieldNode.getName();
        if ((modifiers & 8) != 0 || (modifiers & 0x80) != 0 || fieldsInTransientsList.contains(fieldName) || fieldNode.getType().equals(new ClassNode(Object.class)) && !fieldNode.getType().isUsingGenerics()) {
            shouldInclude = false;
        } else if (isDomainClass && DOMAIN_CLASS_PROPERTIES_TO_EXCLUDE_BY_DEFAULT.contains(fieldName)) {
            shouldInclude = false;
        }
        return shouldInclude;
    }

    private Set<String> getPropertyNamesExpressedInTransientsList(ClassNode classNode) {
        Expression initialValueExpression;
        HashSet<String> transientFields = new HashSet<String>();
        FieldNode transientsField = classNode.getField("transients");
        if (transientsField != null && transientsField.isStatic() && (initialValueExpression = transientsField.getInitialValueExpression()) instanceof ListExpression) {
            ListExpression le = (ListExpression)initialValueExpression;
            List<Expression> expressions = le.getExpressions();
            for (Expression expr : expressions) {
                ConstantExpression ce;
                Object contantValue;
                if (!(expr instanceof ConstantExpression) || !((contantValue = (ce = (ConstantExpression)expr).getValue()) instanceof String)) continue;
                transientFields.add((String)contantValue);
            }
        }
        return transientFields;
    }
}

