/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp.compiler.transform;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.TransformWithPriority;
import org.grails.gsp.compiler.transform.LineNumber;
import org.springframework.util.ReflectionUtils;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class LineNumberTransform
implements ASTTransformation,
TransformWithPriority {
    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        String sourceName;
        ClassNode clazz;
        List<ClassNode> classes = source.getAST().getClasses();
        AnnotationNode annotation = null;
        Iterator<ClassNode> iterator = classes.iterator();
        while (iterator.hasNext() && (annotation = this.findAnnotation(clazz = iterator.next())) == null) {
        }
        if (annotation == null) {
            return;
        }
        int[] array = this.extractLineNumberArray(annotation);
        if (array != null) {
            LineNumberVisitor visitor = new LineNumberVisitor(array);
            for (ClassNode clazz2 : classes) {
                visitor.visitClass(clazz2);
            }
        }
        if ((sourceName = this.extractSourceName(annotation)) != null) {
            source.getAST().setDescription(sourceName);
            Field field = ReflectionUtils.findField(SourceUnit.class, "name");
            field.setAccessible(true);
            ReflectionUtils.setField(field, source, sourceName);
        }
    }

    String extractSourceName(AnnotationNode node) {
        ConstantExpression newName = (ConstantExpression)node.getMember("sourceName");
        return (String)newName.getValue();
    }

    AnnotationNode findAnnotation(ClassNode clazz) {
        if (clazz != null) {
            for (AnnotationNode node : clazz.getAnnotations()) {
                if (!node.getClassNode().getName().equals(LineNumber.class.getName())) continue;
                return node;
            }
        }
        return null;
    }

    int[] extractLineNumberArray(AnnotationNode node) {
        ListExpression lineNumberArray = (ListExpression)node.getMember("lines");
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (Expression e : lineNumberArray.getExpressions()) {
            if (e instanceof ConstantExpression) {
                numbers.add((Integer)((ConstantExpression)e).getValue());
                continue;
            }
            numbers.add(-1);
        }
        if (numbers.isEmpty()) {
            return null;
        }
        int[] array = new int[numbers.size()];
        int count = numbers.size();
        for (int i2 = 0; i2 < count; ++i2) {
            array[i2] = (Integer)numbers.get(i2);
        }
        return array;
    }

    @Override
    public int priority() {
        return 2146483632;
    }

    class LineNumberVisitor
    extends ClassCodeVisitorSupport {
        int[] lineNumbers;

        LineNumberVisitor(int[] lineNumbers) {
            this.lineNumbers = lineNumbers;
        }

        @Override
        protected void visitStatement(Statement statement) {
            if (statement.getLineNumber() >= 0 && statement.getLineNumber() < this.lineNumbers.length) {
                statement.setLineNumber(this.lineNumbers[statement.getLineNumber() - 1]);
            }
            if (statement.getLastLineNumber() > 0 && statement.getLastLineNumber() < this.lineNumbers.length) {
                statement.setLastLineNumber(this.lineNumbers[statement.getLastLineNumber() - 1]);
            }
        }

        @Override
        public void visitMethodCallExpression(MethodCallExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitMethodCallExpression(expression);
        }

        @Override
        public void visitStaticMethodCallExpression(StaticMethodCallExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitStaticMethodCallExpression(expression);
        }

        @Override
        public void visitConstructorCallExpression(ConstructorCallExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitConstructorCallExpression(expression);
        }

        @Override
        public void visitBinaryExpression(BinaryExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitBinaryExpression(expression);
        }

        @Override
        public void visitTernaryExpression(TernaryExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitTernaryExpression(expression);
        }

        @Override
        public void visitShortTernaryExpression(ElvisOperatorExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitShortTernaryExpression(expression);
        }

        @Override
        public void visitPostfixExpression(PostfixExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitPostfixExpression(expression);
        }

        @Override
        public void visitPrefixExpression(PrefixExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitPrefixExpression(expression);
        }

        @Override
        public void visitBooleanExpression(BooleanExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitBooleanExpression(expression);
        }

        @Override
        public void visitNotExpression(NotExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitNotExpression(expression);
        }

        @Override
        public void visitClosureExpression(ClosureExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitClosureExpression(expression);
        }

        @Override
        public void visitTupleExpression(TupleExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitTupleExpression(expression);
        }

        @Override
        public void visitListExpression(ListExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitListExpression(expression);
        }

        @Override
        public void visitArrayExpression(ArrayExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitArrayExpression(expression);
        }

        @Override
        public void visitMapExpression(MapExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitMapExpression(expression);
        }

        @Override
        public void visitMapEntryExpression(MapEntryExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitMapEntryExpression(expression);
        }

        @Override
        public void visitRangeExpression(RangeExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitRangeExpression(expression);
        }

        @Override
        public void visitSpreadExpression(SpreadExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitSpreadExpression(expression);
        }

        @Override
        public void visitSpreadMapExpression(SpreadMapExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitSpreadMapExpression(expression);
        }

        @Override
        public void visitMethodPointerExpression(MethodPointerExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitMethodPointerExpression(expression);
        }

        @Override
        public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitUnaryMinusExpression(expression);
        }

        @Override
        public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitUnaryPlusExpression(expression);
        }

        @Override
        public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitBitwiseNegationExpression(expression);
        }

        @Override
        public void visitCastExpression(CastExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitCastExpression(expression);
        }

        @Override
        public void visitConstantExpression(ConstantExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitConstantExpression(expression);
        }

        @Override
        public void visitClassExpression(ClassExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitClassExpression(expression);
        }

        @Override
        public void visitDeclarationExpression(DeclarationExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitDeclarationExpression(expression);
        }

        @Override
        public void visitPropertyExpression(PropertyExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitPropertyExpression(expression);
        }

        @Override
        public void visitAttributeExpression(AttributeExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitAttributeExpression(expression);
        }

        @Override
        public void visitFieldExpression(FieldExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitFieldExpression(expression);
        }

        @Override
        public void visitGStringExpression(GStringExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitGStringExpression(expression);
        }

        @Override
        public void visitArgumentlistExpression(ArgumentListExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitArgumentlistExpression(expression);
        }

        @Override
        public void visitClosureListExpression(ClosureListExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitClosureListExpression(expression);
        }

        @Override
        public void visitBytecodeExpression(BytecodeExpression expression) {
            if (expression.getLineNumber() >= 0 && expression.getLineNumber() < this.lineNumbers.length) {
                expression.setLineNumber(this.lineNumbers[expression.getLineNumber() - 1]);
            }
            if (expression.getLastLineNumber() > 0 && expression.getLastLineNumber() < this.lineNumbers.length) {
                expression.setLastLineNumber(this.lineNumbers[expression.getLastLineNumber() - 1]);
            }
            super.visitBytecodeExpression(expression);
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return null;
        }
    }
}

