/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.grails.forge.application.Project;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.template.Template;
import org.grails.forge.template.Writable;

public class FileSystemOutputHandler
implements OutputHandler {
    File applicationDirectory;
    private final ConsoleOutput console;

    public FileSystemOutputHandler(Project project, boolean inplace, ConsoleOutput console) throws IOException {
        this.console = console;
        File baseDirectory = FileSystemOutputHandler.getDefaultBaseDirectory();
        this.applicationDirectory = inplace ? baseDirectory : new File(baseDirectory, project.getName()).getCanonicalFile();
        if (this.applicationDirectory.exists() && !inplace) {
            throw new IllegalArgumentException("Cannot create the project because the target directory already exists");
        }
    }

    public FileSystemOutputHandler(File directory, ConsoleOutput console) throws IOException {
        this.console = console;
        this.applicationDirectory = directory;
    }

    public static File getDefaultBaseDirectory() throws IOException {
        String userDir = System.getProperty("user.dir");
        File baseDirectory = userDir != null ? new File(userDir).getCanonicalFile() : new File("").getCanonicalFile();
        return baseDirectory;
    }

    @Override
    public String getOutputLocation() {
        return this.applicationDirectory.getAbsolutePath();
    }

    @Override
    public boolean exists(String path) {
        return new File(this.applicationDirectory, path).exists();
    }

    @Override
    public void write(String path, Template contents) throws IOException {
        File targetFile = this.write(path, (Writable)contents);
        if (contents.isExecutable() && !targetFile.setExecutable(true, true)) {
            this.console.warning("Failed to set " + path + " to be executable");
        }
    }

    public File write(String path, Writable contents) throws IOException {
        if ('/' != File.separatorChar) {
            path = path.replace('/', File.separatorChar);
        }
        File targetFile = new File(this.applicationDirectory, path);
        targetFile.getParentFile().mkdirs();
        targetFile.createNewFile();
        try (OutputStream os = Files.newOutputStream(targetFile.toPath(), new OpenOption[0]);){
            contents.write(os);
        }
        return targetFile;
    }

    @Override
    public void close() {
    }
}

