/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.database;

import java.util.Collections;
import java.util.Map;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.feature.FeatureContext;
import org.grails.forge.feature.OneOfFeature;
import org.grails.forge.feature.database.HibernateGorm;
import org.grails.forge.feature.database.TestContainers;

public abstract class DatabaseDriverFeature
implements OneOfFeature {
    private final TestContainers testContainers;
    private final HibernateGorm hibernateGorm;

    public DatabaseDriverFeature() {
        this.testContainers = null;
        this.hibernateGorm = null;
    }

    public DatabaseDriverFeature(HibernateGorm hibernateGorm, TestContainers testContainers) {
        this.hibernateGorm = hibernateGorm;
        this.testContainers = testContainers;
    }

    @Override
    public Class<?> getFeatureClass() {
        return DatabaseDriverFeature.class;
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }

    @Override
    public void processSelectedFeatures(FeatureContext featureContext) {
        if (!featureContext.isPresent(TestContainers.class) && this.testContainers != null) {
            featureContext.addFeature(this.testContainers);
        }
        if (!featureContext.isPresent(HibernateGorm.class) && this.hibernateGorm != null) {
            featureContext.addFeature(this.hibernateGorm);
        }
    }

    @Override
    public String getCategory() {
        return "Database";
    }

    public abstract boolean embedded();

    @Deprecated(since="6.2.2", forRemoval=true)
    public String getJdbcUrl() {
        return this.getJdbcProdUrl();
    }

    public abstract String getJdbcDevUrl();

    public abstract String getJdbcTestUrl();

    public abstract String getJdbcProdUrl();

    public abstract String getDriverClass();

    public abstract String getDefaultUser();

    public abstract String getDefaultPassword();

    public abstract String getDataDialect();

    public Map<String, Object> getAdditionalConfig() {
        return Collections.emptyMap();
    }
}

