/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core.connections;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.multitenancy.TenantDataSourceConfig;
import org.springframework.util.ClassUtils;

public class ConnectionSourcesSupport {
    public static final List<String> DEFAULT_CONNECTION_SOURCE_NAMES = Collections.singletonList("DEFAULT");

    public static String getDefaultConnectionSourceName(PersistentEntity entity) {
        List<String> names = ConnectionSourcesSupport.getConnectionSourceNames(entity);
        if (names.size() == 1 && "ALL".equals(names.get(0))) {
            return "ALL";
        }
        return names.get(0);
    }

    public static List<String> getConnectionSourceNames(PersistentEntity entity) {
        Object mappedForm = entity.getMapping().getMappedForm();
        if (mappedForm != null) {
            return ((Entity)mappedForm).getDatasources();
        }
        return DEFAULT_CONNECTION_SOURCE_NAMES;
    }

    public static boolean usesConnectionSource(PersistentEntity entity, String connectionSourceName) {
        Class[] interfaces = ClassUtils.getAllInterfacesForClass(entity.getJavaClass());
        if (ConnectionSourcesSupport.isMultiTenant(interfaces)) {
            return !ConnectionSourcesSupport.isMultiTenantExcludedDataSource(entity, connectionSourceName);
        }
        List<String> names = ConnectionSourcesSupport.getConnectionSourceNames(entity);
        return names.contains(connectionSourceName) || names.contains("ALL");
    }

    protected static boolean isMultiTenant(Class[] interfaces) {
        for (Class anInterface : interfaces) {
            String name = anInterface.getName();
            if (!name.startsWith("grails.gorm") || !name.endsWith(".MultiTenant")) continue;
            return true;
        }
        return false;
    }

    protected static boolean isMultiTenantExcludedDataSource(PersistentEntity entity, String connectionSourceName) {
        TenantDataSourceConfig tdsc = entity.getJavaClass().getAnnotation(TenantDataSourceConfig.class);
        boolean result = false;
        if (null != tdsc) {
            String[] dataSourcesToExclude = tdsc.dataSourcesToExclude();
            result = Arrays.asList(dataSourcesToExclude).contains(connectionSourceName);
        }
        return result;
    }
}

