/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueColdProducerFields;
import com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueConsumerFields;
import com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueProducerFields;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Iterator;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

abstract class BaseMpscLinkedArrayQueue<E>
extends BaseMpscLinkedArrayQueueColdProducerFields<E> {
    static final VarHandle P_INDEX = BaseMpscLinkedArrayQueue.findVarHandle(BaseMpscLinkedArrayQueueProducerFields.class, "producerIndex", Long.TYPE);
    static final VarHandle C_INDEX = BaseMpscLinkedArrayQueue.findVarHandle(BaseMpscLinkedArrayQueueConsumerFields.class, "consumerIndex", Long.TYPE);
    static final VarHandle P_LIMIT = BaseMpscLinkedArrayQueue.findVarHandle(BaseMpscLinkedArrayQueueColdProducerFields.class, "producerLimit", Long.TYPE);
    static final VarHandle REF_ARRAY = MethodHandles.arrayElementVarHandle(Object[].class);
    private static final Object JUMP = new Object();

    BaseMpscLinkedArrayQueue(int initialCapacity) {
        super(initialCapacity);
        BaseMpscLinkedArrayQueue.soProducerLimit(this, this.producerMask);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    @Override
    public boolean offer(E e) {
        Object[] buffer;
        long mask;
        long pIndex;
        Objects.requireNonNull(e);
        block6: while (true) {
            long producerLimit = this.lvProducerLimit();
            pIndex = BaseMpscLinkedArrayQueue.lvProducerIndex(this);
            if ((pIndex & 1L) == 1L) continue;
            mask = this.producerMask;
            buffer = this.producerBuffer;
            if (producerLimit <= pIndex) {
                int result = this.offerSlowPath(mask, pIndex, producerLimit);
                switch (result) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, e);
                        return true;
                    }
                }
            }
            if (BaseMpscLinkedArrayQueue.casProducerIndex(this, pIndex, pIndex + 2L)) break;
        }
        long offset = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(pIndex, mask);
        BaseMpscLinkedArrayQueue.soElement(buffer, offset, e);
        return true;
    }

    int offerSlowPath(long mask, long pIndex, long producerLimit) {
        long cIndex = BaseMpscLinkedArrayQueue.lvConsumerIndex(this);
        long bufferCapacity = this.getCurrentBufferCapacity(mask);
        int result = 0;
        if (cIndex + bufferCapacity > pIndex) {
            if (!BaseMpscLinkedArrayQueue.casProducerLimit(this, producerLimit, cIndex + bufferCapacity)) {
                result = 1;
            }
        } else {
            result = this.availableInQueue(pIndex, cIndex) <= 0L ? 2 : (BaseMpscLinkedArrayQueue.casProducerIndex(this, pIndex, pIndex + 1L) ? 3 : 1);
        }
        return result;
    }

    protected abstract long availableInQueue(long var1, long var3);

    @Override
    public @Nullable E poll() {
        @Nullable Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(index2, mask);
        @Nullable Object e = BaseMpscLinkedArrayQueue.lvElement(buffer, offset);
        if (e == null) {
            if (index2 != BaseMpscLinkedArrayQueue.lvProducerIndex(this)) {
                while ((e = BaseMpscLinkedArrayQueue.lvElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        if (e == JUMP) {
            @Nullable Object[] nextBuffer = this.getNextBuffer(buffer, mask);
            return (E)this.newBufferPoll(nextBuffer, index2);
        }
        BaseMpscLinkedArrayQueue.soElement(buffer, offset, null);
        BaseMpscLinkedArrayQueue.soConsumerIndex(this, index2 + 2L);
        return (E)e;
    }

    @Override
    public @Nullable E peek() {
        @Nullable Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(index2, mask);
        @Nullable Object e = BaseMpscLinkedArrayQueue.lvElement(buffer, offset);
        if (e == null && index2 != BaseMpscLinkedArrayQueue.lvProducerIndex(this)) {
            while ((e = BaseMpscLinkedArrayQueue.lvElement(buffer, offset)) == null) {
            }
        }
        if (e == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(buffer, mask), index2);
        }
        return (E)e;
    }

    private @Nullable E[] getNextBuffer(@Nullable E[] buffer, long mask) {
        long nextArrayOffset = BaseMpscLinkedArrayQueue.nextArrayOffset(mask);
        Object[] nextBuffer = (Object[])BaseMpscLinkedArrayQueue.lvElement(buffer, nextArrayOffset);
        BaseMpscLinkedArrayQueue.soElement(buffer, nextArrayOffset, null);
        return Objects.requireNonNull(nextBuffer);
    }

    private static long nextArrayOffset(long mask) {
        return BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(mask + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(@Nullable E[] nextBuffer, long index2) {
        long offsetInNew = this.newBufferAndOffset(nextBuffer, index2);
        @Nullable E n = BaseMpscLinkedArrayQueue.lvElement(nextBuffer, offsetInNew);
        Objects.requireNonNull(n, "new buffer must have at least one element");
        BaseMpscLinkedArrayQueue.soElement(nextBuffer, offsetInNew, null);
        BaseMpscLinkedArrayQueue.soConsumerIndex(this, index2 + 2L);
        return n;
    }

    private E newBufferPeek(@Nullable E[] nextBuffer, long index2) {
        long offsetInNew = this.newBufferAndOffset(nextBuffer, index2);
        @Nullable E n = BaseMpscLinkedArrayQueue.lvElement(nextBuffer, offsetInNew);
        Objects.requireNonNull(n, "new buffer must have at least one element");
        return n;
    }

    private long newBufferAndOffset(@Nullable E[] nextBuffer, long index2) {
        this.consumerBuffer = nextBuffer;
        this.consumerMask = (long)nextBuffer.length - 2L << 1;
        return BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(index2, this.consumerMask);
    }

    @Override
    public final int size() {
        long currentProducerIndex;
        long before;
        long after = BaseMpscLinkedArrayQueue.lvConsumerIndex(this);
        do {
            before = after;
            currentProducerIndex = BaseMpscLinkedArrayQueue.lvProducerIndex(this);
        } while (before != (after = BaseMpscLinkedArrayQueue.lvConsumerIndex(this)));
        long size = currentProducerIndex - after >> 1;
        return (int)Math.min(size, Integer.MAX_VALUE);
    }

    @Override
    public final boolean isEmpty() {
        return BaseMpscLinkedArrayQueue.lvConsumerIndex(this) == BaseMpscLinkedArrayQueue.lvProducerIndex(this);
    }

    private long lvProducerLimit() {
        return this.producerLimit;
    }

    public long currentProducerIndex() {
        return BaseMpscLinkedArrayQueue.lvProducerIndex(this) / 2L;
    }

    public long currentConsumerIndex() {
        return BaseMpscLinkedArrayQueue.lvConsumerIndex(this) / 2L;
    }

    public abstract int capacity();

    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    public @Nullable E relaxedPoll() {
        @Nullable Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(index2, mask);
        @Nullable Object e = BaseMpscLinkedArrayQueue.lvElement(buffer, offset);
        if (e == null) {
            return null;
        }
        if (e == JUMP) {
            @Nullable Object[] nextBuffer = this.getNextBuffer(buffer, mask);
            return (E)this.newBufferPoll(nextBuffer, index2);
        }
        BaseMpscLinkedArrayQueue.soElement(buffer, offset, null);
        BaseMpscLinkedArrayQueue.soConsumerIndex(this, index2 + 2L);
        return (E)e;
    }

    public @Nullable E relaxedPeek() {
        @Nullable Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(index2, mask);
        @Nullable Object e = BaseMpscLinkedArrayQueue.lvElement(buffer, offset);
        if (e == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(buffer, mask), index2);
        }
        return (E)e;
    }

    private void resize(long oldMask, @Nullable E[] oldBuffer, long pIndex, E e) {
        int newBufferLength = this.getNextBufferSize(oldBuffer);
        @Nullable E[] newBuffer = BaseMpscLinkedArrayQueue.allocate(newBufferLength);
        this.producerBuffer = newBuffer;
        int newMask = newBufferLength - 2 << 1;
        this.producerMask = newMask;
        long offsetInOld = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(pIndex, oldMask);
        long offsetInNew = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(pIndex, newMask);
        BaseMpscLinkedArrayQueue.soElement(newBuffer, offsetInNew, e);
        BaseMpscLinkedArrayQueue.soElement(oldBuffer, BaseMpscLinkedArrayQueue.nextArrayOffset(oldMask), newBuffer);
        long cIndex = BaseMpscLinkedArrayQueue.lvConsumerIndex(this);
        long availableInQueue = this.availableInQueue(pIndex, cIndex);
        Caffeine.requireState(availableInQueue > 0L);
        BaseMpscLinkedArrayQueue.soProducerLimit(this, pIndex + Math.min((long)newMask, availableInQueue));
        BaseMpscLinkedArrayQueue.soProducerIndex(this, pIndex + 2L);
        BaseMpscLinkedArrayQueue.soElement(oldBuffer, offsetInOld, JUMP);
    }

    protected abstract int getNextBufferSize(@Nullable E[] var1);

    protected abstract long getCurrentBufferCapacity(long var1);

    static long lvProducerIndex(BaseMpscLinkedArrayQueue<?> self) {
        return P_INDEX.getVolatile(self);
    }

    static long lvConsumerIndex(BaseMpscLinkedArrayQueue<?> self) {
        return C_INDEX.getVolatile(self);
    }

    static void soProducerIndex(BaseMpscLinkedArrayQueue<?> self, long v) {
        P_INDEX.setRelease(self, v);
    }

    static boolean casProducerIndex(BaseMpscLinkedArrayQueue<?> self, long expect, long newValue) {
        return P_INDEX.compareAndSet(self, expect, newValue);
    }

    static void soConsumerIndex(BaseMpscLinkedArrayQueue<?> self, long v) {
        C_INDEX.setRelease(self, v);
    }

    static boolean casProducerLimit(BaseMpscLinkedArrayQueue<?> self, long expect, long newValue) {
        return P_LIMIT.compareAndSet(self, expect, newValue);
    }

    static void soProducerLimit(BaseMpscLinkedArrayQueue<?> self, long v) {
        P_LIMIT.setRelease(self, v);
    }

    static <E> void soElement(@Nullable E[] buffer, long offset, @Nullable E e) {
        REF_ARRAY.setRelease(buffer, (int)offset, e);
    }

    static <E> @Nullable E lvElement(@Nullable E @Nullable [] buffer, long offset) {
        return (E)REF_ARRAY.getVolatile(buffer, (int)offset);
    }

    static long modifiedCalcElementOffset(long index2, long mask) {
        return (index2 & mask) >> 1;
    }

    static VarHandle findVarHandle(Class<?> recv, String name, Class<?> type) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(recv, MethodHandles.lookup());
            return lookup.findVarHandle(recv, name, type);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

