// $ANTLR 3.5.2 /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g 2017-06-20 10:22:44

/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
	
package org.apache.flex.compiler.internal.css;

import java.util.Map;
import java.util.HashMap;
import org.apache.flex.compiler.css.*;
import org.apache.flex.compiler.problems.CSSParserProblem;



import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

/**
 * This is a tree grammar for advanced CSS in Flex. It walks the AST generated 
 * by the CSS parser and builds CSS DOM objects.
 */
@SuppressWarnings("all")
public class CSSTree extends TreeParser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ALPHA_VALUE", "ARGUMENTS", "AT_FONT_FACE", 
		"AT_KEYFRAMES", "AT_MEDIA", "AT_NAMESPACE", "AT_WEBKIT_KEYFRAMES", "BEGINS_WITH", 
		"BLOCK_END", "BLOCK_OPEN", "CALC", "CHILD", "CLASS_REFERENCE", "COLON", 
		"COMMA", "COMMENT", "CONTAINS", "DIGIT", "DOT", "DOUBLE_COLON", "EMBED", 
		"ENDS_WITH", "EQUALS", "ESCAPED_HEX", "FORMAT", "HASH_WORD", "HEX_DIGIT", 
		"HREFLANG_MATCH", "ID", "IMPORTANT", "I_ARRAY", "I_CHILD_SELECTOR", "I_DECL", 
		"I_MEDIUM_CONDITIONS", "I_PRECEDED_SELECTOR", "I_RULE", "I_RULES", "I_SELECTOR", 
		"I_SELECTOR_GROUP", "I_SIBLING_SELECTOR", "I_SIMPLE_SELECTOR", "LETTER", 
		"LIST_MATCH", "LOCAL", "NOT", "NULL", "NUMBER", "NUMBER_WITH_PERCENT", 
		"NUMBER_WITH_UNIT", "ONLY", "OPERATOR", "PERCENT", "PIPE", "PRECEDED", 
		"PROPERTY_REFERENCE", "RECT_VALUE", "RGB", "RGBA", "ROTATE_VALUE", "SCALE", 
		"SCALE_VALUE", "SEMI_COLONS", "SQUARE_END", "SQUARE_OPEN", "STAR", "STRING", 
		"STRING_QUOTE", "TILDE", "TRANSLATE3D_VALUE", "URL", "WS", "'and'"
	};
	public static final int EOF=-1;
	public static final int T__75=75;
	public static final int ALPHA_VALUE=4;
	public static final int ARGUMENTS=5;
	public static final int AT_FONT_FACE=6;
	public static final int AT_KEYFRAMES=7;
	public static final int AT_MEDIA=8;
	public static final int AT_NAMESPACE=9;
	public static final int AT_WEBKIT_KEYFRAMES=10;
	public static final int BEGINS_WITH=11;
	public static final int BLOCK_END=12;
	public static final int BLOCK_OPEN=13;
	public static final int CALC=14;
	public static final int CHILD=15;
	public static final int CLASS_REFERENCE=16;
	public static final int COLON=17;
	public static final int COMMA=18;
	public static final int COMMENT=19;
	public static final int CONTAINS=20;
	public static final int DIGIT=21;
	public static final int DOT=22;
	public static final int DOUBLE_COLON=23;
	public static final int EMBED=24;
	public static final int ENDS_WITH=25;
	public static final int EQUALS=26;
	public static final int ESCAPED_HEX=27;
	public static final int FORMAT=28;
	public static final int HASH_WORD=29;
	public static final int HEX_DIGIT=30;
	public static final int HREFLANG_MATCH=31;
	public static final int ID=32;
	public static final int IMPORTANT=33;
	public static final int I_ARRAY=34;
	public static final int I_CHILD_SELECTOR=35;
	public static final int I_DECL=36;
	public static final int I_MEDIUM_CONDITIONS=37;
	public static final int I_PRECEDED_SELECTOR=38;
	public static final int I_RULE=39;
	public static final int I_RULES=40;
	public static final int I_SELECTOR=41;
	public static final int I_SELECTOR_GROUP=42;
	public static final int I_SIBLING_SELECTOR=43;
	public static final int I_SIMPLE_SELECTOR=44;
	public static final int LETTER=45;
	public static final int LIST_MATCH=46;
	public static final int LOCAL=47;
	public static final int NOT=48;
	public static final int NULL=49;
	public static final int NUMBER=50;
	public static final int NUMBER_WITH_PERCENT=51;
	public static final int NUMBER_WITH_UNIT=52;
	public static final int ONLY=53;
	public static final int OPERATOR=54;
	public static final int PERCENT=55;
	public static final int PIPE=56;
	public static final int PRECEDED=57;
	public static final int PROPERTY_REFERENCE=58;
	public static final int RECT_VALUE=59;
	public static final int RGB=60;
	public static final int RGBA=61;
	public static final int ROTATE_VALUE=62;
	public static final int SCALE=63;
	public static final int SCALE_VALUE=64;
	public static final int SEMI_COLONS=65;
	public static final int SQUARE_END=66;
	public static final int SQUARE_OPEN=67;
	public static final int STAR=68;
	public static final int STRING=69;
	public static final int STRING_QUOTE=70;
	public static final int TILDE=71;
	public static final int TRANSLATE3D_VALUE=72;
	public static final int URL=73;
	public static final int WS=74;

	// delegates
	public TreeParser[] getDelegates() {
		return new TreeParser[] {};
	}

	// delegators


	public CSSTree(TreeNodeStream input) {
		this(input, new RecognizerSharedState());
	}
	public CSSTree(TreeNodeStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return CSSTree.tokenNames; }
	@Override public String getGrammarFileName() { return "/Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g"; }



	/**
	 * CSS DOM object.
	 */
	protected CSSDocument model;

	/**
	 * Every definition object needs the token stream to compute source location.
	 */
	private final TokenStream tokenStream = getTreeNodeStream().getTokenStream();

	/**
	 * Tree walker problems.
	 */
	protected List<CSSParserProblem> problems = new ArrayList<CSSParserProblem>();

	/**
	 * Used for building up attribute selector strings until we implement a data
	 * structure for it.
	 */
	protected String curAttribute;


	/**
	 * Collect problems.
	 */
	@Override
	public void displayRecognitionError(String[] tokenNames, RecognitionException e)
	{
	    problems.add(CSSParserProblem.create(this, tokenNames, e));
	}


	protected static class stylesheet_scope {
		List<CSSNamespaceDefinition> namespaces;
		List<CSSRule> rules;
		List<CSSFontFace> fontFaces;
		List<CSSKeyFrames> keyFrames;
	}
	protected Stack<stylesheet_scope> stylesheet_stack = new Stack<stylesheet_scope>();

	public static class stylesheet_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "stylesheet"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:98:1: stylesheet : ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )* ;
	public final CSSTree.stylesheet_return stylesheet() throws RecognitionException {
		stylesheet_stack.push(new stylesheet_scope());
		CSSTree.stylesheet_return retval = new CSSTree.stylesheet_return();
		retval.start = input.LT(1);


		    stylesheet_stack.peek().rules = new ArrayList<CSSRule>();
		    stylesheet_stack.peek().namespaces = new ArrayList<CSSNamespaceDefinition>();
		    stylesheet_stack.peek().fontFaces = new ArrayList<CSSFontFace>();
		    stylesheet_stack.peek().keyFrames = new ArrayList<CSSKeyFrames>();

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:5: ( ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )* )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:9: ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )*
			{
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:9: ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )*
			loop1:
			while (true) {
				int alt1=6;
				switch ( input.LA(1) ) {
				case AT_NAMESPACE:
					{
					alt1=1;
					}
					break;
				case AT_FONT_FACE:
					{
					alt1=2;
					}
					break;
				case AT_KEYFRAMES:
				case AT_WEBKIT_KEYFRAMES:
					{
					alt1=3;
					}
					break;
				case AT_MEDIA:
					{
					alt1=4;
					}
					break;
				case I_RULE:
					{
					alt1=5;
					}
					break;
				}
				switch (alt1) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:11: namespaceStatement
					{
					pushFollow(FOLLOW_namespaceStatement_in_stylesheet94);
					namespaceStatement();
					state._fsp--;

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:32: fontFace
					{
					pushFollow(FOLLOW_fontFace_in_stylesheet98);
					fontFace();
					state._fsp--;

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:43: keyframes
					{
					pushFollow(FOLLOW_keyframes_in_stylesheet102);
					keyframes();
					state._fsp--;

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:55: mediaQuery
					{
					pushFollow(FOLLOW_mediaQuery_in_stylesheet106);
					mediaQuery();
					state._fsp--;

					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:68: ruleset
					{
					pushFollow(FOLLOW_ruleset_in_stylesheet110);
					ruleset();
					state._fsp--;

					}
					break;

				default :
					break loop1;
				}
			}

			}


			    model = new CSSDocument(stylesheet_stack.peek().rules, 
			                            stylesheet_stack.peek().namespaces, 
			                            stylesheet_stack.peek().fontFaces,
			                            ((CommonTree)retval.start),
			                            tokenStream);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			stylesheet_stack.pop();
		}
		return retval;
	}
	// $ANTLR end "stylesheet"


	public static class namespaceStatement_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "namespaceStatement"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:128:1: namespaceStatement : ^( AT_NAMESPACE (id= ID )? uri= STRING ) ;
	public final CSSTree.namespaceStatement_return namespaceStatement() throws RecognitionException {
		CSSTree.namespaceStatement_return retval = new CSSTree.namespaceStatement_return();
		retval.start = input.LT(1);

		CommonTree id=null;
		CommonTree uri=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:135:5: ( ^( AT_NAMESPACE (id= ID )? uri= STRING ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:135:9: ^( AT_NAMESPACE (id= ID )? uri= STRING )
			{
			match(input,AT_NAMESPACE,FOLLOW_AT_NAMESPACE_in_namespaceStatement146); 
			match(input, Token.DOWN, null); 
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:135:26: (id= ID )?
			int alt2=2;
			int LA2_0 = input.LA(1);
			if ( (LA2_0==ID) ) {
				alt2=1;
			}
			switch (alt2) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:135:26: id= ID
					{
					id=(CommonTree)match(input,ID,FOLLOW_ID_in_namespaceStatement150); 
					}
					break;

			}

			uri=(CommonTree)match(input,STRING,FOLLOW_STRING_in_namespaceStatement155); 
			match(input, Token.UP, null); 

			}

			 
			    final CSSNamespaceDefinition ns = new CSSNamespaceDefinition(
			            (id!=null?id.getText():null), (uri!=null?uri.getText():null), ((CommonTree)retval.start), tokenStream);
			    stylesheet_stack.peek().namespaces.add(ns); 

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "namespaceStatement"


	public static class keyframes_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "keyframes"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:138:1: keyframes : ( ^( AT_KEYFRAMES id= ID ( ruleset )* ) | ^( AT_WEBKIT_KEYFRAMES id= ID ( ruleset )* ) );
	public final CSSTree.keyframes_return keyframes() throws RecognitionException {
		CSSTree.keyframes_return retval = new CSSTree.keyframes_return();
		retval.start = input.LT(1);

		CommonTree id=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:139:5: ( ^( AT_KEYFRAMES id= ID ( ruleset )* ) | ^( AT_WEBKIT_KEYFRAMES id= ID ( ruleset )* ) )
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==AT_KEYFRAMES) ) {
				alt5=1;
			}
			else if ( (LA5_0==AT_WEBKIT_KEYFRAMES) ) {
				alt5=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 5, 0, input);
				throw nvae;
			}

			switch (alt5) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:139:9: ^( AT_KEYFRAMES id= ID ( ruleset )* )
					{
					match(input,AT_KEYFRAMES,FOLLOW_AT_KEYFRAMES_in_keyframes178); 
					match(input, Token.DOWN, null); 
					id=(CommonTree)match(input,ID,FOLLOW_ID_in_keyframes182); 
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:139:30: ( ruleset )*
					loop3:
					while (true) {
						int alt3=2;
						int LA3_0 = input.LA(1);
						if ( (LA3_0==I_RULE) ) {
							alt3=1;
						}

						switch (alt3) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:139:30: ruleset
							{
							pushFollow(FOLLOW_ruleset_in_keyframes184);
							ruleset();
							state._fsp--;

							}
							break;

						default :
							break loop3;
						}
					}

					match(input, Token.UP, null); 

					 stylesheet_stack.peek().keyFrames.add(new CSSKeyFrames((id!=null?id.getText():null), CSSModelTreeType.KEYFRAMES, ((CommonTree)retval.start), tokenStream)); 
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:141:9: ^( AT_WEBKIT_KEYFRAMES id= ID ( ruleset )* )
					{
					match(input,AT_WEBKIT_KEYFRAMES,FOLLOW_AT_WEBKIT_KEYFRAMES_in_keyframes208); 
					match(input, Token.DOWN, null); 
					id=(CommonTree)match(input,ID,FOLLOW_ID_in_keyframes212); 
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:141:37: ( ruleset )*
					loop4:
					while (true) {
						int alt4=2;
						int LA4_0 = input.LA(1);
						if ( (LA4_0==I_RULE) ) {
							alt4=1;
						}

						switch (alt4) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:141:37: ruleset
							{
							pushFollow(FOLLOW_ruleset_in_keyframes214);
							ruleset();
							state._fsp--;

							}
							break;

						default :
							break loop4;
						}
					}

					match(input, Token.UP, null); 

					 stylesheet_stack.peek().keyFrames.add(new CSSKeyFrames((id!=null?id.getText():null), CSSModelTreeType.KEYFRAMES_WEBKIT, ((CommonTree)retval.start), tokenStream)); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "keyframes"


	protected static class mediaQuery_scope {
		List<CSSMediaQueryCondition> conditions;
	}
	protected Stack<mediaQuery_scope> mediaQuery_stack = new Stack<mediaQuery_scope>();


	// $ANTLR start "mediaQuery"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:146:1: mediaQuery : ^( AT_MEDIA medium ( ruleset )* ) ;
	public final void mediaQuery() throws RecognitionException {
		mediaQuery_stack.push(new mediaQuery_scope());
		 
		    mediaQuery_stack.peek().conditions = new ArrayList<CSSMediaQueryCondition>(); 

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:156:5: ( ^( AT_MEDIA medium ( ruleset )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:156:9: ^( AT_MEDIA medium ( ruleset )* )
			{
			match(input,AT_MEDIA,FOLLOW_AT_MEDIA_in_mediaQuery261); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_medium_in_mediaQuery263);
			medium();
			state._fsp--;

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:156:27: ( ruleset )*
			loop6:
			while (true) {
				int alt6=2;
				int LA6_0 = input.LA(1);
				if ( (LA6_0==I_RULE) ) {
					alt6=1;
				}

				switch (alt6) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:156:27: ruleset
					{
					pushFollow(FOLLOW_ruleset_in_mediaQuery265);
					ruleset();
					state._fsp--;

					}
					break;

				default :
					break loop6;
				}
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			mediaQuery_stack.pop();
		}
	}
	// $ANTLR end "mediaQuery"



	// $ANTLR start "medium"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:159:1: medium : ^( I_MEDIUM_CONDITIONS ( mediumCondition )* ) ;
	public final void medium() throws RecognitionException {
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:160:5: ( ^( I_MEDIUM_CONDITIONS ( mediumCondition )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:160:9: ^( I_MEDIUM_CONDITIONS ( mediumCondition )* )
			{
			match(input,I_MEDIUM_CONDITIONS,FOLLOW_I_MEDIUM_CONDITIONS_in_medium290); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:160:31: ( mediumCondition )*
				loop7:
				while (true) {
					int alt7=2;
					int LA7_0 = input.LA(1);
					if ( (LA7_0==ARGUMENTS||LA7_0==COMMA||LA7_0==ID||LA7_0==ONLY) ) {
						alt7=1;
					}

					switch (alt7) {
					case 1 :
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:160:31: mediumCondition
						{
						pushFollow(FOLLOW_mediumCondition_in_medium292);
						mediumCondition();
						state._fsp--;

						}
						break;

					default :
						break loop7;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "medium"


	public static class mediumCondition_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "mediumCondition"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:163:1: mediumCondition : ( ID | ONLY id= ID | ARGUMENTS | COMMA );
	public final CSSTree.mediumCondition_return mediumCondition() throws RecognitionException {
		CSSTree.mediumCondition_return retval = new CSSTree.mediumCondition_return();
		retval.start = input.LT(1);

		CommonTree id=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:164:5: ( ID | ONLY id= ID | ARGUMENTS | COMMA )
			int alt8=4;
			switch ( input.LA(1) ) {
			case ID:
				{
				alt8=1;
				}
				break;
			case ONLY:
				{
				alt8=2;
				}
				break;
			case ARGUMENTS:
				{
				alt8=3;
				}
				break;
			case COMMA:
				{
				alt8=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 8, 0, input);
				throw nvae;
			}
			switch (alt8) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:164:9: ID
					{
					match(input,ID,FOLLOW_ID_in_mediumCondition315); 
					 
					        mediaQuery_stack.peek().conditions.add(new CSSMediaQueryCondition(((CommonTree)retval.start), tokenStream)); 
					    
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:168:7: ONLY id= ID
					{
					match(input,ONLY,FOLLOW_ONLY_in_mediumCondition331); 
					id=(CommonTree)match(input,ID,FOLLOW_ID_in_mediumCondition335); 
					 
					        mediaQuery_stack.peek().conditions.add(new CSSMediaQueryCondition(((CommonTree)retval.start), tokenStream)); 
					        mediaQuery_stack.peek().conditions.add(new CSSMediaQueryCondition(id, tokenStream)); 
					    
					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:173:7: ARGUMENTS
					{
					match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_mediumCondition351); 
					 
					        mediaQuery_stack.peek().conditions.add(new CSSMediaQueryCondition(((CommonTree)retval.start), tokenStream)); 
					    
					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:177:7: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_mediumCondition366); 
					 
					        mediaQuery_stack.peek().conditions.add(new CSSMediaQueryCondition(((CommonTree)retval.start), tokenStream)); 
					    
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "mediumCondition"


	public static class fontFace_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "fontFace"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:183:1: fontFace : ^( AT_FONT_FACE d= declarationsBlock ) ;
	public final CSSTree.fontFace_return fontFace() throws RecognitionException {
		CSSTree.fontFace_return retval = new CSSTree.fontFace_return();
		retval.start = input.LT(1);

		List<CSSProperty> d =null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:189:5: ( ^( AT_FONT_FACE d= declarationsBlock ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:189:9: ^( AT_FONT_FACE d= declarationsBlock )
			{
			match(input,AT_FONT_FACE,FOLLOW_AT_FONT_FACE_in_fontFace402); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_declarationsBlock_in_fontFace406);
			d=declarationsBlock();
			state._fsp--;

			match(input, Token.UP, null); 

			}


			    final CSSFontFace fontFace = new CSSFontFace(d, ((CommonTree)retval.start), tokenStream);
			    stylesheet_stack.peek().fontFaces.add(fontFace);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "fontFace"


	protected static class ruleset_scope {
		List<CSSSelector> subjects;
	}
	protected Stack<ruleset_scope> ruleset_stack = new Stack<ruleset_scope>();

	public static class ruleset_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "ruleset"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:192:1: ruleset : ^( I_RULE selectorGroup d= declarationsBlock ) ;
	public final CSSTree.ruleset_return ruleset() throws RecognitionException {
		ruleset_stack.push(new ruleset_scope());
		CSSTree.ruleset_return retval = new CSSTree.ruleset_return();
		retval.start = input.LT(1);

		List<CSSProperty> d =null;


		    ruleset_stack.peek().subjects = new ArrayList<CSSSelector>();

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:218:5: ( ^( I_RULE selectorGroup d= declarationsBlock ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:218:9: ^( I_RULE selectorGroup d= declarationsBlock )
			{
			match(input,I_RULE,FOLLOW_I_RULE_in_ruleset446); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_selectorGroup_in_ruleset448);
			selectorGroup();
			state._fsp--;

			pushFollow(FOLLOW_declarationsBlock_in_ruleset452);
			d=declarationsBlock();
			state._fsp--;

			match(input, Token.UP, null); 

			}


			    final List<CSSMediaQueryCondition> mediaQueryConditions;
			    if (mediaQuery_stack.isEmpty())
			        mediaQueryConditions = null;
			    else
			        mediaQueryConditions = mediaQuery_stack.peek().conditions;
			    
			    final CSSRule cssRule = new CSSRule(
			            mediaQueryConditions,
			            ruleset_stack.peek().subjects,
			            d, 
			            ((CommonTree)retval.start), 
			            tokenStream);
			    stylesheet_stack.peek().rules.add(cssRule);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			ruleset_stack.pop();
		}
		return retval;
	}
	// $ANTLR end "ruleset"



	// $ANTLR start "selectorGroup"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:221:1: selectorGroup : ^( I_SELECTOR_GROUP ( compoundSelector )+ ) ;
	public final void selectorGroup() throws RecognitionException {
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:222:5: ( ^( I_SELECTOR_GROUP ( compoundSelector )+ ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:222:8: ^( I_SELECTOR_GROUP ( compoundSelector )+ )
			{
			match(input,I_SELECTOR_GROUP,FOLLOW_I_SELECTOR_GROUP_in_selectorGroup472); 
			match(input, Token.DOWN, null); 
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:222:27: ( compoundSelector )+
			int cnt9=0;
			loop9:
			while (true) {
				int alt9=2;
				int LA9_0 = input.LA(1);
				if ( (LA9_0==I_SELECTOR) ) {
					alt9=1;
				}

				switch (alt9) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:222:27: compoundSelector
					{
					pushFollow(FOLLOW_compoundSelector_in_selectorGroup474);
					compoundSelector();
					state._fsp--;

					}
					break;

				default :
					if ( cnt9 >= 1 ) break loop9;
					EarlyExitException eee = new EarlyExitException(9, input);
					throw eee;
				}
				cnt9++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selectorGroup"



	// $ANTLR start "compoundSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:225:1: compoundSelector : ^( I_SELECTOR firstSelector[simpleSelectorStack] ( moreSelectors[simpleSelectorStack] )* ) ;
	public final void compoundSelector() throws RecognitionException {

		    final Stack<CSSSelector> simpleSelectorStack = new Stack<CSSSelector>();

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:234:5: ( ^( I_SELECTOR firstSelector[simpleSelectorStack] ( moreSelectors[simpleSelectorStack] )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:234:9: ^( I_SELECTOR firstSelector[simpleSelectorStack] ( moreSelectors[simpleSelectorStack] )* )
			{
			match(input,I_SELECTOR,FOLLOW_I_SELECTOR_in_compoundSelector510); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_firstSelector_in_compoundSelector512);
			firstSelector(simpleSelectorStack);
			state._fsp--;

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:234:57: ( moreSelectors[simpleSelectorStack] )*
			loop10:
			while (true) {
				int alt10=2;
				int LA10_0 = input.LA(1);
				if ( (LA10_0==I_CHILD_SELECTOR||LA10_0==I_PRECEDED_SELECTOR||(LA10_0 >= I_SIBLING_SELECTOR && LA10_0 <= I_SIMPLE_SELECTOR)) ) {
					alt10=1;
				}

				switch (alt10) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:234:57: moreSelectors[simpleSelectorStack]
					{
					pushFollow(FOLLOW_moreSelectors_in_compoundSelector515);
					moreSelectors(simpleSelectorStack);
					state._fsp--;

					}
					break;

				default :
					break loop10;
				}
			}

			match(input, Token.UP, null); 

			}


			    ruleset_stack.peek().subjects.add(simpleSelectorStack.peek());

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "compoundSelector"



	// $ANTLR start "moreSelectors"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:237:1: moreSelectors[Stack<CSSSelector> simpleSelectorStack] : ( ^( I_CHILD_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.CHILD] ) | ^( I_PRECEDED_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.PRECEDED] ) | ^( I_SIBLING_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.SIBLING] ) | ^( I_SIMPLE_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.DESCENDANT] ) );
	public final void moreSelectors(Stack<CSSSelector> simpleSelectorStack) throws RecognitionException {
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:238:5: ( ^( I_CHILD_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.CHILD] ) | ^( I_PRECEDED_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.PRECEDED] ) | ^( I_SIBLING_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.SIBLING] ) | ^( I_SIMPLE_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.DESCENDANT] ) )
			int alt11=4;
			switch ( input.LA(1) ) {
			case I_CHILD_SELECTOR:
				{
				alt11=1;
				}
				break;
			case I_PRECEDED_SELECTOR:
				{
				alt11=2;
				}
				break;
			case I_SIBLING_SELECTOR:
				{
				alt11=3;
				}
				break;
			case I_SIMPLE_SELECTOR:
				{
				alt11=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 11, 0, input);
				throw nvae;
			}
			switch (alt11) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:238:9: ^( I_CHILD_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.CHILD] )
					{
					match(input,I_CHILD_SELECTOR,FOLLOW_I_CHILD_SELECTOR_in_moreSelectors547); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_simpleSelector_in_moreSelectors549);
					simpleSelector(simpleSelectorStack, CombinatorType.CHILD);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:239:9: ^( I_PRECEDED_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.PRECEDED] )
					{
					match(input,I_PRECEDED_SELECTOR,FOLLOW_I_PRECEDED_SELECTOR_in_moreSelectors562); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_simpleSelector_in_moreSelectors564);
					simpleSelector(simpleSelectorStack, CombinatorType.PRECEDED);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:240:9: ^( I_SIBLING_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.SIBLING] )
					{
					match(input,I_SIBLING_SELECTOR,FOLLOW_I_SIBLING_SELECTOR_in_moreSelectors577); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_simpleSelector_in_moreSelectors579);
					simpleSelector(simpleSelectorStack, CombinatorType.SIBLING);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:241:9: ^( I_SIMPLE_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.DESCENDANT] )
					{
					match(input,I_SIMPLE_SELECTOR,FOLLOW_I_SIMPLE_SELECTOR_in_moreSelectors592); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_simpleSelector_in_moreSelectors594);
					simpleSelector(simpleSelectorStack, CombinatorType.DESCENDANT);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "moreSelectors"



	// $ANTLR start "firstSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:244:1: firstSelector[Stack<CSSSelector> simpleSelectorStack] : ^( I_SIMPLE_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.DESCENDANT] ) ;
	public final void firstSelector(Stack<CSSSelector> simpleSelectorStack) throws RecognitionException {
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:245:5: ( ^( I_SIMPLE_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.DESCENDANT] ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:245:9: ^( I_SIMPLE_SELECTOR simpleSelector[simpleSelectorStack, CombinatorType.DESCENDANT] )
			{
			match(input,I_SIMPLE_SELECTOR,FOLLOW_I_SIMPLE_SELECTOR_in_firstSelector619); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_simpleSelector_in_firstSelector621);
			simpleSelector(simpleSelectorStack, CombinatorType.DESCENDANT);
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "firstSelector"


	protected static class simpleSelector_scope {
		String namespace;
		String element;
		List<CSSSelectorCondition> conditions;
	}
	protected Stack<simpleSelector_scope> simpleSelector_stack = new Stack<simpleSelector_scope>();

	public static class simpleSelector_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "simpleSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:248:1: simpleSelector[Stack<CSSSelector> simpleSelectorStack, CombinatorType combinatorType] : ( simpleSelectorFraction )+ ;
	public final CSSTree.simpleSelector_return simpleSelector(Stack<CSSSelector> simpleSelectorStack, CombinatorType combinatorType) throws RecognitionException {
		simpleSelector_stack.push(new simpleSelector_scope());
		CSSTree.simpleSelector_return retval = new CSSTree.simpleSelector_return();
		retval.start = input.LT(1);


		    simpleSelector_stack.peek().conditions = new ArrayList<CSSSelectorCondition>();
		    final CSSCombinator combinator ;
		    if (simpleSelectorStack.isEmpty())
		        combinator = null;
		    else                    
		        combinator = new CSSCombinator(simpleSelectorStack.peek(), combinatorType, ((CommonTree)retval.start), tokenStream);

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:275:5: ( ( simpleSelectorFraction )+ )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:275:9: ( simpleSelectorFraction )+
			{
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:275:9: ( simpleSelectorFraction )+
			int cnt12=0;
			loop12:
			while (true) {
				int alt12=2;
				int LA12_0 = input.LA(1);
				if ( (LA12_0==COLON||(LA12_0 >= DOT && LA12_0 <= DOUBLE_COLON)||LA12_0==HASH_WORD||LA12_0==ID||LA12_0==NUMBER_WITH_PERCENT||LA12_0==PIPE||(LA12_0 >= SQUARE_OPEN && LA12_0 <= STAR)) ) {
					alt12=1;
				}

				switch (alt12) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:275:9: simpleSelectorFraction
					{
					pushFollow(FOLLOW_simpleSelectorFraction_in_simpleSelector658);
					simpleSelectorFraction();
					state._fsp--;

					}
					break;

				default :
					if ( cnt12 >= 1 ) break loop12;
					EarlyExitException eee = new EarlyExitException(12, input);
					throw eee;
				}
				cnt12++;
			}

			}


			    final CSSSelector simpleSelector = new CSSSelector(
			        combinator,
			        simpleSelector_stack.peek().element,
			        simpleSelector_stack.peek().namespace,
			        simpleSelector_stack.peek().conditions, 
			        ((CommonTree)retval.start), 
			        tokenStream);
			    simpleSelectorStack.push(simpleSelector);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			simpleSelector_stack.pop();
		}
		return retval;
	}
	// $ANTLR end "simpleSelector"



	// $ANTLR start "simpleSelectorFraction"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:279:1: simpleSelectorFraction : ( elementSelector | conditionSelector );
	public final void simpleSelectorFraction() throws RecognitionException {
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:280:5: ( elementSelector | conditionSelector )
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==ID||LA13_0==NUMBER_WITH_PERCENT||LA13_0==PIPE||LA13_0==STAR) ) {
				alt13=1;
			}
			else if ( (LA13_0==COLON||(LA13_0 >= DOT && LA13_0 <= DOUBLE_COLON)||LA13_0==HASH_WORD||LA13_0==SQUARE_OPEN) ) {
				alt13=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 13, 0, input);
				throw nvae;
			}

			switch (alt13) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:280:9: elementSelector
					{
					pushFollow(FOLLOW_elementSelector_in_simpleSelectorFraction690);
					elementSelector();
					state._fsp--;

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:281:9: conditionSelector
					{
					pushFollow(FOLLOW_conditionSelector_in_simpleSelectorFraction700);
					conditionSelector();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "simpleSelectorFraction"


	public static class conditionSelector_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "conditionSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:284:1: conditionSelector : ( ^( DOT c= ID ) | HASH_WORD | ^( COLON NOT arg= ARGUMENTS ) | ^( COLON s= ID ) | ^( DOUBLE_COLON dc= ID ) | attributeSelector );
	public final CSSTree.conditionSelector_return conditionSelector() throws RecognitionException {
		CSSTree.conditionSelector_return retval = new CSSTree.conditionSelector_return();
		retval.start = input.LT(1);

		CommonTree c=null;
		CommonTree arg=null;
		CommonTree s=null;
		CommonTree dc=null;
		CommonTree HASH_WORD1=null;


		    ConditionType type = null;
		    String name = null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:295:5: ( ^( DOT c= ID ) | HASH_WORD | ^( COLON NOT arg= ARGUMENTS ) | ^( COLON s= ID ) | ^( DOUBLE_COLON dc= ID ) | attributeSelector )
			int alt14=6;
			switch ( input.LA(1) ) {
			case DOT:
				{
				alt14=1;
				}
				break;
			case HASH_WORD:
				{
				alt14=2;
				}
				break;
			case COLON:
				{
				int LA14_3 = input.LA(2);
				if ( (LA14_3==DOWN) ) {
					int LA14_6 = input.LA(3);
					if ( (LA14_6==NOT) ) {
						alt14=3;
					}
					else if ( (LA14_6==ID) ) {
						alt14=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 14, 6, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case DOUBLE_COLON:
				{
				alt14=5;
				}
				break;
			case SQUARE_OPEN:
				{
				alt14=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 14, 0, input);
				throw nvae;
			}
			switch (alt14) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:295:9: ^( DOT c= ID )
					{
					match(input,DOT,FOLLOW_DOT_in_conditionSelector734); 
					match(input, Token.DOWN, null); 
					c=(CommonTree)match(input,ID,FOLLOW_ID_in_conditionSelector738); 
					match(input, Token.UP, null); 

					 type = ConditionType.CLASS; name = (c!=null?c.getText():null); 
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:296:9: HASH_WORD
					{
					HASH_WORD1=(CommonTree)match(input,HASH_WORD,FOLLOW_HASH_WORD_in_conditionSelector755); 
					 type = ConditionType.ID; name = (HASH_WORD1!=null?HASH_WORD1.getText():null).substring(1); 
					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:297:9: ^( COLON NOT arg= ARGUMENTS )
					{
					match(input,COLON,FOLLOW_COLON_in_conditionSelector770); 
					match(input, Token.DOWN, null); 
					match(input,NOT,FOLLOW_NOT_in_conditionSelector772); 
					arg=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_conditionSelector776); 
					match(input, Token.UP, null); 

					 type = ConditionType.NOT; name = (arg!=null?arg.getText():null); 
					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:298:9: ^( COLON s= ID )
					{
					match(input,COLON,FOLLOW_COLON_in_conditionSelector790); 
					match(input, Token.DOWN, null); 
					s=(CommonTree)match(input,ID,FOLLOW_ID_in_conditionSelector794); 
					match(input, Token.UP, null); 

					 type = ConditionType.PSEUDO; name = (s!=null?s.getText():null); 
					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:299:9: ^( DOUBLE_COLON dc= ID )
					{
					match(input,DOUBLE_COLON,FOLLOW_DOUBLE_COLON_in_conditionSelector809); 
					match(input, Token.DOWN, null); 
					dc=(CommonTree)match(input,ID,FOLLOW_ID_in_conditionSelector813); 
					match(input, Token.UP, null); 

					 type = ConditionType.PSEUDO; name = (dc!=null?dc.getText():null); 
					}
					break;
				case 6 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:300:9: attributeSelector
					{
					pushFollow(FOLLOW_attributeSelector_in_conditionSelector827);
					attributeSelector();
					state._fsp--;

					 type = ConditionType.ATTRIBUTE; name = curAttribute.substring(1); 
					}
					break;

			}

			    simpleSelector_stack.peek().conditions.add(
			        new CSSSelectorCondition(name, type, ((CommonTree)retval.start), tokenStream));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "conditionSelector"



	// $ANTLR start "elementSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:303:1: elementSelector : ( ^( PIPE ns= ID e1= ID ) |e2= ID |np= NUMBER_WITH_PERCENT | STAR );
	public final void elementSelector() throws RecognitionException {
		CommonTree ns=null;
		CommonTree e1=null;
		CommonTree e2=null;
		CommonTree np=null;
		CommonTree STAR2=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:304:5: ( ^( PIPE ns= ID e1= ID ) |e2= ID |np= NUMBER_WITH_PERCENT | STAR )
			int alt15=4;
			switch ( input.LA(1) ) {
			case PIPE:
				{
				alt15=1;
				}
				break;
			case ID:
				{
				alt15=2;
				}
				break;
			case NUMBER_WITH_PERCENT:
				{
				alt15=3;
				}
				break;
			case STAR:
				{
				alt15=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 15, 0, input);
				throw nvae;
			}
			switch (alt15) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:304:9: ^( PIPE ns= ID e1= ID )
					{
					match(input,PIPE,FOLLOW_PIPE_in_elementSelector851); 
					match(input, Token.DOWN, null); 
					ns=(CommonTree)match(input,ID,FOLLOW_ID_in_elementSelector855); 
					e1=(CommonTree)match(input,ID,FOLLOW_ID_in_elementSelector859); 
					match(input, Token.UP, null); 

					 simpleSelector_stack.peek().element = (e1!=null?e1.getText():null); 
					          simpleSelector_stack.peek().namespace = (ns!=null?ns.getText():null); 
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:307:9: e2= ID
					{
					e2=(CommonTree)match(input,ID,FOLLOW_ID_in_elementSelector884); 
					 simpleSelector_stack.peek().element = (e2!=null?e2.getText():null); 
					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:309:9: np= NUMBER_WITH_PERCENT
					{
					np=(CommonTree)match(input,NUMBER_WITH_PERCENT,FOLLOW_NUMBER_WITH_PERCENT_in_elementSelector919); 
					 simpleSelector_stack.peek().element = (np!=null?np.getText():null); 
					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:311:9: STAR
					{
					STAR2=(CommonTree)match(input,STAR,FOLLOW_STAR_in_elementSelector952); 
					 simpleSelector_stack.peek().element = (STAR2!=null?STAR2.getText():null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "elementSelector"



	// $ANTLR start "attributeSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:315:1: attributeSelector : open= SQUARE_OPEN attributeName ( attributeOperator )* ( attributeValue )* close= SQUARE_END ;
	public final void attributeSelector() throws RecognitionException {
		CommonTree open=null;
		CommonTree close=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:316:5: (open= SQUARE_OPEN attributeName ( attributeOperator )* ( attributeValue )* close= SQUARE_END )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:316:9: open= SQUARE_OPEN attributeName ( attributeOperator )* ( attributeValue )* close= SQUARE_END
			{
			open=(CommonTree)match(input,SQUARE_OPEN,FOLLOW_SQUARE_OPEN_in_attributeSelector1000); 
			pushFollow(FOLLOW_attributeName_in_attributeSelector1002);
			attributeName();
			state._fsp--;

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:316:42: ( attributeOperator )*
			loop16:
			while (true) {
				int alt16=2;
				int LA16_0 = input.LA(1);
				if ( (LA16_0==BEGINS_WITH||LA16_0==CONTAINS||(LA16_0 >= ENDS_WITH && LA16_0 <= EQUALS)||LA16_0==HREFLANG_MATCH||LA16_0==LIST_MATCH) ) {
					alt16=1;
				}

				switch (alt16) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:316:42: attributeOperator
					{
					pushFollow(FOLLOW_attributeOperator_in_attributeSelector1004);
					attributeOperator();
					state._fsp--;

					}
					break;

				default :
					break loop16;
				}
			}

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:316:61: ( attributeValue )*
			loop17:
			while (true) {
				int alt17=2;
				int LA17_0 = input.LA(1);
				if ( (LA17_0==STRING) ) {
					alt17=1;
				}

				switch (alt17) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:316:61: attributeValue
					{
					pushFollow(FOLLOW_attributeValue_in_attributeSelector1007);
					attributeValue();
					state._fsp--;

					}
					break;

				default :
					break loop17;
				}
			}

			close=(CommonTree)match(input,SQUARE_END,FOLLOW_SQUARE_END_in_attributeSelector1014); 
			 curAttribute = (open!=null?open.getText():null) + curAttribute + (close!=null?close.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "attributeSelector"



	// $ANTLR start "attributeName"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:320:1: attributeName : n1= ID ;
	public final void attributeName() throws RecognitionException {
		CommonTree n1=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:321:5: (n1= ID )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:321:10: n1= ID
			{
			n1=(CommonTree)match(input,ID,FOLLOW_ID_in_attributeName1045); 
			 curAttribute = (n1!=null?n1.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "attributeName"



	// $ANTLR start "attributeOperator"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:325:1: attributeOperator : (o1= BEGINS_WITH |o2= ENDS_WITH |o3= CONTAINS |o4= LIST_MATCH |o5= HREFLANG_MATCH |o6= EQUALS );
	public final void attributeOperator() throws RecognitionException {
		CommonTree o1=null;
		CommonTree o2=null;
		CommonTree o3=null;
		CommonTree o4=null;
		CommonTree o5=null;
		CommonTree o6=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:326:5: (o1= BEGINS_WITH |o2= ENDS_WITH |o3= CONTAINS |o4= LIST_MATCH |o5= HREFLANG_MATCH |o6= EQUALS )
			int alt18=6;
			switch ( input.LA(1) ) {
			case BEGINS_WITH:
				{
				alt18=1;
				}
				break;
			case ENDS_WITH:
				{
				alt18=2;
				}
				break;
			case CONTAINS:
				{
				alt18=3;
				}
				break;
			case LIST_MATCH:
				{
				alt18=4;
				}
				break;
			case HREFLANG_MATCH:
				{
				alt18=5;
				}
				break;
			case EQUALS:
				{
				alt18=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 18, 0, input);
				throw nvae;
			}
			switch (alt18) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:326:10: o1= BEGINS_WITH
					{
					o1=(CommonTree)match(input,BEGINS_WITH,FOLLOW_BEGINS_WITH_in_attributeOperator1084); 
					 curAttribute += (o1!=null?o1.getText():null); 
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:328:10: o2= ENDS_WITH
					{
					o2=(CommonTree)match(input,ENDS_WITH,FOLLOW_ENDS_WITH_in_attributeOperator1110); 
					 curAttribute += (o2!=null?o2.getText():null); 
					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:330:10: o3= CONTAINS
					{
					o3=(CommonTree)match(input,CONTAINS,FOLLOW_CONTAINS_in_attributeOperator1136); 
					 curAttribute += (o3!=null?o3.getText():null); 
					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:332:10: o4= LIST_MATCH
					{
					o4=(CommonTree)match(input,LIST_MATCH,FOLLOW_LIST_MATCH_in_attributeOperator1162); 
					 curAttribute += (o4!=null?o4.getText():null); 
					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:334:10: o5= HREFLANG_MATCH
					{
					o5=(CommonTree)match(input,HREFLANG_MATCH,FOLLOW_HREFLANG_MATCH_in_attributeOperator1188); 
					 curAttribute += (o5!=null?o5.getText():null); 
					}
					break;
				case 6 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:336:10: o6= EQUALS
					{
					o6=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_attributeOperator1214); 
					 curAttribute += (o6!=null?o6.getText():null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "attributeOperator"



	// $ANTLR start "attributeValue"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:340:1: attributeValue : s= STRING ;
	public final void attributeValue() throws RecognitionException {
		CommonTree s=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:341:5: (s= STRING )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:341:10: s= STRING
			{
			s=(CommonTree)match(input,STRING,FOLLOW_STRING_in_attributeValue1253); 
			 curAttribute += (s!=null?s.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "attributeValue"



	// $ANTLR start "declarationsBlock"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:346:1: declarationsBlock returns [List<CSSProperty> properties] : ^( I_DECL ( declaration )* ) ;
	public final List<CSSProperty> declarationsBlock() throws RecognitionException {
		List<CSSProperty> properties = null;


		TreeRuleReturnScope declaration3 =null;


		    properties = new ArrayList<CSSProperty>();

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:351:5: ( ^( I_DECL ( declaration )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:351:9: ^( I_DECL ( declaration )* )
			{
			match(input,I_DECL,FOLLOW_I_DECL_in_declarationsBlock1300); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:351:18: ( declaration )*
				loop19:
				while (true) {
					int alt19=2;
					int LA19_0 = input.LA(1);
					if ( (LA19_0==COLON) ) {
						alt19=1;
					}

					switch (alt19) {
					case 1 :
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:351:19: declaration
						{
						pushFollow(FOLLOW_declaration_in_declarationsBlock1303);
						declaration3=declaration();
						state._fsp--;

						 
						             if ((declaration3!=null?((CSSTree.declaration_return)declaration3).property:null) != null)
						                 properties.add((declaration3!=null?((CSSTree.declaration_return)declaration3).property:null)); 
						         
						}
						break;

					default :
						break loop19;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return properties;
	}
	// $ANTLR end "declarationsBlock"


	public static class declaration_return extends TreeRuleReturnScope {
		public CSSProperty property;
	};


	// $ANTLR start "declaration"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:359:1: declaration returns [CSSProperty property] : ^( COLON id= ID v= value ) ;
	public final CSSTree.declaration_return declaration() throws RecognitionException {
		CSSTree.declaration_return retval = new CSSTree.declaration_return();
		retval.start = input.LT(1);

		CommonTree id=null;
		TreeRuleReturnScope v =null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:365:5: ( ^( COLON id= ID v= value ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:365:9: ^( COLON id= ID v= value )
			{
			match(input,COLON,FOLLOW_COLON_in_declaration1357); 
			match(input, Token.DOWN, null); 
			id=(CommonTree)match(input,ID,FOLLOW_ID_in_declaration1361); 
			pushFollow(FOLLOW_value_in_declaration1365);
			v=value();
			state._fsp--;

			match(input, Token.UP, null); 

			}


			    if ((id!=null?id.getText():null) != null && (v!=null?((CSSTree.value_return)v).propertyValue:null) != null)
			        retval.property = new CSSProperty((id!=null?id.getText():null), (v!=null?((CSSTree.value_return)v).propertyValue:null), ((CommonTree)retval.start), tokenStream);  

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "declaration"


	public static class value_return extends TreeRuleReturnScope {
		public CSSPropertyValue propertyValue;
	};


	// $ANTLR start "value"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:368:1: value returns [CSSPropertyValue propertyValue] : ( ^( I_ARRAY (s1= singleValue )+ ) |s2= singleValue );
	public final CSSTree.value_return value() throws RecognitionException {
		CSSTree.value_return retval = new CSSTree.value_return();
		retval.start = input.LT(1);

		TreeRuleReturnScope s1 =null;
		TreeRuleReturnScope s2 =null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:369:5: ( ^( I_ARRAY (s1= singleValue )+ ) |s2= singleValue )
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==I_ARRAY) ) {
				alt21=1;
			}
			else if ( (LA21_0==ALPHA_VALUE||LA21_0==CALC||LA21_0==CLASS_REFERENCE||LA21_0==EMBED||LA21_0==HASH_WORD||(LA21_0 >= ID && LA21_0 <= IMPORTANT)||LA21_0==LOCAL||(LA21_0 >= NUMBER_WITH_PERCENT && LA21_0 <= NUMBER_WITH_UNIT)||LA21_0==OPERATOR||(LA21_0 >= PROPERTY_REFERENCE && LA21_0 <= ROTATE_VALUE)||LA21_0==SCALE_VALUE||LA21_0==STRING||(LA21_0 >= TRANSLATE3D_VALUE && LA21_0 <= URL)) ) {
				alt21=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 21, 0, input);
				throw nvae;
			}

			switch (alt21) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:369:9: ^( I_ARRAY (s1= singleValue )+ )
					{
					match(input,I_ARRAY,FOLLOW_I_ARRAY_in_value1395); 
					 final List<CSSPropertyValue> array = new ArrayList<CSSPropertyValue>(); 
					match(input, Token.DOWN, null); 
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:371:12: (s1= singleValue )+
					int cnt20=0;
					loop20:
					while (true) {
						int alt20=2;
						int LA20_0 = input.LA(1);
						if ( (LA20_0==ALPHA_VALUE||LA20_0==CALC||LA20_0==CLASS_REFERENCE||LA20_0==EMBED||LA20_0==HASH_WORD||(LA20_0 >= ID && LA20_0 <= IMPORTANT)||LA20_0==LOCAL||(LA20_0 >= NUMBER_WITH_PERCENT && LA20_0 <= NUMBER_WITH_UNIT)||LA20_0==OPERATOR||(LA20_0 >= PROPERTY_REFERENCE && LA20_0 <= ROTATE_VALUE)||LA20_0==SCALE_VALUE||LA20_0==STRING||(LA20_0 >= TRANSLATE3D_VALUE && LA20_0 <= URL)) ) {
							alt20=1;
						}

						switch (alt20) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:371:14: s1= singleValue
							{
							pushFollow(FOLLOW_singleValue_in_value1445);
							s1=singleValue();
							state._fsp--;

							 array.add((s1!=null?((CSSTree.singleValue_return)s1).propertyValue:null)); 
							}
							break;

						default :
							if ( cnt20 >= 1 ) break loop20;
							EarlyExitException eee = new EarlyExitException(20, input);
							throw eee;
						}
						cnt20++;
					}

					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSArrayPropertyValue(array, ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:373:9: s2= singleValue
					{
					pushFollow(FOLLOW_singleValue_in_value1496);
					s2=singleValue();
					state._fsp--;

					 retval.propertyValue = (s2!=null?((CSSTree.singleValue_return)s2).propertyValue:null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "value"


	public static class singleValue_return extends TreeRuleReturnScope {
		public CSSPropertyValue propertyValue;
	};


	// $ANTLR start "singleValue"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:376:1: singleValue returns [CSSPropertyValue propertyValue] : ( NUMBER_WITH_PERCENT | NUMBER_WITH_UNIT | HASH_WORD | ALPHA_VALUE | RECT_VALUE | ROTATE_VALUE | SCALE_VALUE | TRANSLATE3D_VALUE | RGB | RGBA | ^( CLASS_REFERENCE cr= ARGUMENTS ) | ^( PROPERTY_REFERENCE pr= ARGUMENTS ) | ^( EMBED es= ARGUMENTS ) | ^( URL url= ARGUMENTS (format= formatOption )* ) | ^( LOCAL l= ARGUMENTS ) | ^( CALC l= ARGUMENTS ) |s= STRING | ID | OPERATOR | IMPORTANT );
	public final CSSTree.singleValue_return singleValue() throws RecognitionException {
		CSSTree.singleValue_return retval = new CSSTree.singleValue_return();
		retval.start = input.LT(1);

		CommonTree cr=null;
		CommonTree pr=null;
		CommonTree es=null;
		CommonTree url=null;
		CommonTree l=null;
		CommonTree s=null;
		CommonTree NUMBER_WITH_PERCENT4=null;
		CommonTree NUMBER_WITH_UNIT5=null;
		CommonTree RGB6=null;
		CommonTree RGBA7=null;
		CommonTree CLASS_REFERENCE8=null;
		CommonTree PROPERTY_REFERENCE9=null;
		CommonTree EMBED10=null;
		CommonTree URL11=null;
		CommonTree LOCAL12=null;
		CommonTree CALC13=null;
		TreeRuleReturnScope format =null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:377:5: ( NUMBER_WITH_PERCENT | NUMBER_WITH_UNIT | HASH_WORD | ALPHA_VALUE | RECT_VALUE | ROTATE_VALUE | SCALE_VALUE | TRANSLATE3D_VALUE | RGB | RGBA | ^( CLASS_REFERENCE cr= ARGUMENTS ) | ^( PROPERTY_REFERENCE pr= ARGUMENTS ) | ^( EMBED es= ARGUMENTS ) | ^( URL url= ARGUMENTS (format= formatOption )* ) | ^( LOCAL l= ARGUMENTS ) | ^( CALC l= ARGUMENTS ) |s= STRING | ID | OPERATOR | IMPORTANT )
			int alt23=20;
			switch ( input.LA(1) ) {
			case NUMBER_WITH_PERCENT:
				{
				alt23=1;
				}
				break;
			case NUMBER_WITH_UNIT:
				{
				alt23=2;
				}
				break;
			case HASH_WORD:
				{
				alt23=3;
				}
				break;
			case ALPHA_VALUE:
				{
				alt23=4;
				}
				break;
			case RECT_VALUE:
				{
				alt23=5;
				}
				break;
			case ROTATE_VALUE:
				{
				alt23=6;
				}
				break;
			case SCALE_VALUE:
				{
				alt23=7;
				}
				break;
			case TRANSLATE3D_VALUE:
				{
				alt23=8;
				}
				break;
			case RGB:
				{
				alt23=9;
				}
				break;
			case RGBA:
				{
				alt23=10;
				}
				break;
			case CLASS_REFERENCE:
				{
				alt23=11;
				}
				break;
			case PROPERTY_REFERENCE:
				{
				alt23=12;
				}
				break;
			case EMBED:
				{
				alt23=13;
				}
				break;
			case URL:
				{
				alt23=14;
				}
				break;
			case LOCAL:
				{
				alt23=15;
				}
				break;
			case CALC:
				{
				alt23=16;
				}
				break;
			case STRING:
				{
				alt23=17;
				}
				break;
			case ID:
				{
				alt23=18;
				}
				break;
			case OPERATOR:
				{
				alt23=19;
				}
				break;
			case IMPORTANT:
				{
				alt23=20;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 23, 0, input);
				throw nvae;
			}
			switch (alt23) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:377:9: NUMBER_WITH_PERCENT
					{
					NUMBER_WITH_PERCENT4=(CommonTree)match(input,NUMBER_WITH_PERCENT,FOLLOW_NUMBER_WITH_PERCENT_in_singleValue1534); 
					 retval.propertyValue = new CSSNumberPropertyValue((NUMBER_WITH_PERCENT4!=null?NUMBER_WITH_PERCENT4.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:379:9: NUMBER_WITH_UNIT
					{
					NUMBER_WITH_UNIT5=(CommonTree)match(input,NUMBER_WITH_UNIT,FOLLOW_NUMBER_WITH_UNIT_in_singleValue1557); 
					 retval.propertyValue = new CSSNumberPropertyValue((NUMBER_WITH_UNIT5!=null?NUMBER_WITH_UNIT5.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:381:9: HASH_WORD
					{
					match(input,HASH_WORD,FOLLOW_HASH_WORD_in_singleValue1580); 
					 retval.propertyValue = new CSSColorPropertyValue(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:383:9: ALPHA_VALUE
					{
					match(input,ALPHA_VALUE,FOLLOW_ALPHA_VALUE_in_singleValue1609); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:385:9: RECT_VALUE
					{
					match(input,RECT_VALUE,FOLLOW_RECT_VALUE_in_singleValue1629); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 6 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:387:9: ROTATE_VALUE
					{
					match(input,ROTATE_VALUE,FOLLOW_ROTATE_VALUE_in_singleValue1649); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 7 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:389:9: SCALE_VALUE
					{
					match(input,SCALE_VALUE,FOLLOW_SCALE_VALUE_in_singleValue1669); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 8 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:391:9: TRANSLATE3D_VALUE
					{
					match(input,TRANSLATE3D_VALUE,FOLLOW_TRANSLATE3D_VALUE_in_singleValue1689); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 9 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:393:9: RGB
					{
					RGB6=(CommonTree)match(input,RGB,FOLLOW_RGB_in_singleValue1709); 
					 retval.propertyValue = new CSSRgbColorPropertyValue((RGB6!=null?RGB6.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 10 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:395:9: RGBA
					{
					RGBA7=(CommonTree)match(input,RGBA,FOLLOW_RGBA_in_singleValue1726); 
					 retval.propertyValue = new CSSRgbaColorPropertyValue((RGBA7!=null?RGBA7.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 11 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:397:9: ^( CLASS_REFERENCE cr= ARGUMENTS )
					{
					CLASS_REFERENCE8=(CommonTree)match(input,CLASS_REFERENCE,FOLLOW_CLASS_REFERENCE_in_singleValue1744); 
					match(input, Token.DOWN, null); 
					cr=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1748); 
					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSFunctionCallPropertyValue((CLASS_REFERENCE8!=null?CLASS_REFERENCE8.getText():null), (cr!=null?cr.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 12 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:399:9: ^( PROPERTY_REFERENCE pr= ARGUMENTS )
					{
					PROPERTY_REFERENCE9=(CommonTree)match(input,PROPERTY_REFERENCE,FOLLOW_PROPERTY_REFERENCE_in_singleValue1770); 
					match(input, Token.DOWN, null); 
					pr=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1774); 
					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSFunctionCallPropertyValue((PROPERTY_REFERENCE9!=null?PROPERTY_REFERENCE9.getText():null), (pr!=null?pr.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 13 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:401:9: ^( EMBED es= ARGUMENTS )
					{
					EMBED10=(CommonTree)match(input,EMBED,FOLLOW_EMBED_in_singleValue1796); 
					match(input, Token.DOWN, null); 
					es=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1800); 
					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSFunctionCallPropertyValue((EMBED10!=null?EMBED10.getText():null), (es!=null?es.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 14 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:403:9: ^( URL url= ARGUMENTS (format= formatOption )* )
					{
					URL11=(CommonTree)match(input,URL,FOLLOW_URL_in_singleValue1822); 
					match(input, Token.DOWN, null); 
					url=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1826); 
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:403:35: (format= formatOption )*
					loop22:
					while (true) {
						int alt22=2;
						int LA22_0 = input.LA(1);
						if ( (LA22_0==FORMAT) ) {
							alt22=1;
						}

						switch (alt22) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:403:35: format= formatOption
							{
							pushFollow(FOLLOW_formatOption_in_singleValue1830);
							format=formatOption();
							state._fsp--;

							}
							break;

						default :
							break loop22;
						}
					}

					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSURLAndFormatPropertyValue((URL11!=null?URL11.getText():null), (url!=null?url.getText():null), (format!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(format.start),input.getTreeAdaptor().getTokenStopIndex(format.start))):null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 15 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:405:9: ^( LOCAL l= ARGUMENTS )
					{
					LOCAL12=(CommonTree)match(input,LOCAL,FOLLOW_LOCAL_in_singleValue1853); 
					match(input, Token.DOWN, null); 
					l=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1857); 
					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSFunctionCallPropertyValue((LOCAL12!=null?LOCAL12.getText():null), (l!=null?l.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 16 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:407:9: ^( CALC l= ARGUMENTS )
					{
					CALC13=(CommonTree)match(input,CALC,FOLLOW_CALC_in_singleValue1879); 
					match(input, Token.DOWN, null); 
					l=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1883); 
					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSFunctionCallPropertyValue((CALC13!=null?CALC13.getText():null), (l!=null?l.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 17 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:409:9: s= STRING
					{
					s=(CommonTree)match(input,STRING,FOLLOW_STRING_in_singleValue1906); 
					 retval.propertyValue = new CSSStringPropertyValue((s!=null?s.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 18 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:411:9: ID
					{
					match(input,ID,FOLLOW_ID_in_singleValue1948); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 19 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:413:9: OPERATOR
					{
					match(input,OPERATOR,FOLLOW_OPERATOR_in_singleValue1969); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 20 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:415:9: IMPORTANT
					{
					match(input,IMPORTANT,FOLLOW_IMPORTANT_in_singleValue1990); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "singleValue"


	public static class formatOption_return extends TreeRuleReturnScope {
		public CSSPropertyValue propertyValue;
	};


	// $ANTLR start "formatOption"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:419:1: formatOption returns [CSSPropertyValue propertyValue] : ^( FORMAT format= ARGUMENTS ) ;
	public final CSSTree.formatOption_return formatOption() throws RecognitionException {
		CSSTree.formatOption_return retval = new CSSTree.formatOption_return();
		retval.start = input.LT(1);

		CommonTree format=null;
		CommonTree FORMAT14=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:420:5: ( ^( FORMAT format= ARGUMENTS ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:420:9: ^( FORMAT format= ARGUMENTS )
			{
			FORMAT14=(CommonTree)match(input,FORMAT,FOLLOW_FORMAT_in_formatOption2029); 
			match(input, Token.DOWN, null); 
			format=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_formatOption2033); 
			match(input, Token.UP, null); 

			 retval.propertyValue = new CSSFunctionCallPropertyValue((FORMAT14!=null?FORMAT14.getText():null), (format!=null?format.getText():null), ((CommonTree)retval.start), tokenStream); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "formatOption"


	public static class argumentList_return extends TreeRuleReturnScope {
		public List<String> labels;
		public List<String> values;
	};


	// $ANTLR start "argumentList"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:424:1: argumentList returns [List<String> labels, List<String> values] : ( argument[$labels, $values] )+ ;
	public final CSSTree.argumentList_return argumentList() throws RecognitionException {
		CSSTree.argumentList_return retval = new CSSTree.argumentList_return();
		retval.start = input.LT(1);


		    retval.labels = new ArrayList<String>(3);
		    retval.values = new ArrayList<String>(3);

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:430:5: ( ( argument[$labels, $values] )+ )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:430:9: ( argument[$labels, $values] )+
			{
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:430:9: ( argument[$labels, $values] )+
			int cnt24=0;
			loop24:
			while (true) {
				int alt24=2;
				int LA24_0 = input.LA(1);
				if ( (LA24_0==EQUALS) ) {
					alt24=1;
				}

				switch (alt24) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:430:9: argument[$labels, $values]
					{
					pushFollow(FOLLOW_argument_in_argumentList2074);
					argument(retval.labels, retval.values);
					state._fsp--;

					}
					break;

				default :
					if ( cnt24 >= 1 ) break loop24;
					EarlyExitException eee = new EarlyExitException(24, input);
					throw eee;
				}
				cnt24++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "argumentList"



	// $ANTLR start "argument"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:433:1: argument[List<String> labels, List<String> values] : ^( EQUALS (l= ID )? v= STRING ) ;
	public final void argument(List<String> labels, List<String> values) throws RecognitionException {
		CommonTree l=null;
		CommonTree v=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:440:5: ( ^( EQUALS (l= ID )? v= STRING ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:440:9: ^( EQUALS (l= ID )? v= STRING )
			{
			match(input,EQUALS,FOLLOW_EQUALS_in_argument2107); 
			match(input, Token.DOWN, null); 
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:440:19: (l= ID )?
			int alt25=2;
			int LA25_0 = input.LA(1);
			if ( (LA25_0==ID) ) {
				alt25=1;
			}
			switch (alt25) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:440:19: l= ID
					{
					l=(CommonTree)match(input,ID,FOLLOW_ID_in_argument2111); 
					}
					break;

			}

			v=(CommonTree)match(input,STRING,FOLLOW_STRING_in_argument2116); 
			match(input, Token.UP, null); 

			}


			    // Use null for argument without label.
			    labels.add((l!=null?l.getText():null));
			    values.add((v!=null?v.getText():null)); 

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "argument"

	// Delegated rules



	public static final BitSet FOLLOW_namespaceStatement_in_stylesheet94 = new BitSet(new long[]{0x00000080000007C2L});
	public static final BitSet FOLLOW_fontFace_in_stylesheet98 = new BitSet(new long[]{0x00000080000007C2L});
	public static final BitSet FOLLOW_keyframes_in_stylesheet102 = new BitSet(new long[]{0x00000080000007C2L});
	public static final BitSet FOLLOW_mediaQuery_in_stylesheet106 = new BitSet(new long[]{0x00000080000007C2L});
	public static final BitSet FOLLOW_ruleset_in_stylesheet110 = new BitSet(new long[]{0x00000080000007C2L});
	public static final BitSet FOLLOW_AT_NAMESPACE_in_namespaceStatement146 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_namespaceStatement150 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_STRING_in_namespaceStatement155 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AT_KEYFRAMES_in_keyframes178 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_keyframes182 = new BitSet(new long[]{0x0000008000000008L});
	public static final BitSet FOLLOW_ruleset_in_keyframes184 = new BitSet(new long[]{0x0000008000000008L});
	public static final BitSet FOLLOW_AT_WEBKIT_KEYFRAMES_in_keyframes208 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_keyframes212 = new BitSet(new long[]{0x0000008000000008L});
	public static final BitSet FOLLOW_ruleset_in_keyframes214 = new BitSet(new long[]{0x0000008000000008L});
	public static final BitSet FOLLOW_AT_MEDIA_in_mediaQuery261 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_medium_in_mediaQuery263 = new BitSet(new long[]{0x0000008000000008L});
	public static final BitSet FOLLOW_ruleset_in_mediaQuery265 = new BitSet(new long[]{0x0000008000000008L});
	public static final BitSet FOLLOW_I_MEDIUM_CONDITIONS_in_medium290 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_mediumCondition_in_medium292 = new BitSet(new long[]{0x0020000100040028L});
	public static final BitSet FOLLOW_ID_in_mediumCondition315 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ONLY_in_mediumCondition331 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_ID_in_mediumCondition335 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ARGUMENTS_in_mediumCondition351 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_mediumCondition366 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_FONT_FACE_in_fontFace402 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declarationsBlock_in_fontFace406 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_I_RULE_in_ruleset446 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_selectorGroup_in_ruleset448 = new BitSet(new long[]{0x0000001000000000L});
	public static final BitSet FOLLOW_declarationsBlock_in_ruleset452 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_I_SELECTOR_GROUP_in_selectorGroup472 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_compoundSelector_in_selectorGroup474 = new BitSet(new long[]{0x0000020000000008L});
	public static final BitSet FOLLOW_I_SELECTOR_in_compoundSelector510 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_firstSelector_in_compoundSelector512 = new BitSet(new long[]{0x0000184800000008L});
	public static final BitSet FOLLOW_moreSelectors_in_compoundSelector515 = new BitSet(new long[]{0x0000184800000008L});
	public static final BitSet FOLLOW_I_CHILD_SELECTOR_in_moreSelectors547 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_simpleSelector_in_moreSelectors549 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_I_PRECEDED_SELECTOR_in_moreSelectors562 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_simpleSelector_in_moreSelectors564 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_I_SIBLING_SELECTOR_in_moreSelectors577 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_simpleSelector_in_moreSelectors579 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_I_SIMPLE_SELECTOR_in_moreSelectors592 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_simpleSelector_in_moreSelectors594 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_I_SIMPLE_SELECTOR_in_firstSelector619 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_simpleSelector_in_firstSelector621 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_simpleSelectorFraction_in_simpleSelector658 = new BitSet(new long[]{0x0108000120C20002L,0x0000000000000018L});
	public static final BitSet FOLLOW_elementSelector_in_simpleSelectorFraction690 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_conditionSelector_in_simpleSelectorFraction700 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_conditionSelector734 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_conditionSelector738 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_HASH_WORD_in_conditionSelector755 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_conditionSelector770 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NOT_in_conditionSelector772 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_conditionSelector776 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COLON_in_conditionSelector790 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_conditionSelector794 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DOUBLE_COLON_in_conditionSelector809 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_conditionSelector813 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_attributeSelector_in_conditionSelector827 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PIPE_in_elementSelector851 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_elementSelector855 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_ID_in_elementSelector859 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ID_in_elementSelector884 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_WITH_PERCENT_in_elementSelector919 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STAR_in_elementSelector952 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SQUARE_OPEN_in_attributeSelector1000 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_attributeName_in_attributeSelector1002 = new BitSet(new long[]{0x0000400086100800L,0x0000000000000024L});
	public static final BitSet FOLLOW_attributeOperator_in_attributeSelector1004 = new BitSet(new long[]{0x0000400086100800L,0x0000000000000024L});
	public static final BitSet FOLLOW_attributeValue_in_attributeSelector1007 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000024L});
	public static final BitSet FOLLOW_SQUARE_END_in_attributeSelector1014 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_attributeName1045 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BEGINS_WITH_in_attributeOperator1084 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ENDS_WITH_in_attributeOperator1110 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONTAINS_in_attributeOperator1136 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LIST_MATCH_in_attributeOperator1162 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HREFLANG_MATCH_in_attributeOperator1188 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUALS_in_attributeOperator1214 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_attributeValue1253 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_I_DECL_in_declarationsBlock1300 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declaration_in_declarationsBlock1303 = new BitSet(new long[]{0x0000000000020008L});
	public static final BitSet FOLLOW_COLON_in_declaration1357 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_declaration1361 = new BitSet(new long[]{0x7C58800721014010L,0x0000000000000321L});
	public static final BitSet FOLLOW_value_in_declaration1365 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_I_ARRAY_in_value1395 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_singleValue_in_value1445 = new BitSet(new long[]{0x7C58800321014018L,0x0000000000000321L});
	public static final BitSet FOLLOW_singleValue_in_value1496 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_WITH_PERCENT_in_singleValue1534 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_WITH_UNIT_in_singleValue1557 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_WORD_in_singleValue1580 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALPHA_VALUE_in_singleValue1609 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RECT_VALUE_in_singleValue1629 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ROTATE_VALUE_in_singleValue1649 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SCALE_VALUE_in_singleValue1669 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRANSLATE3D_VALUE_in_singleValue1689 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RGB_in_singleValue1709 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RGBA_in_singleValue1726 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLASS_REFERENCE_in_singleValue1744 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1748 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PROPERTY_REFERENCE_in_singleValue1770 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1774 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_EMBED_in_singleValue1796 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1800 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_URL_in_singleValue1822 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1826 = new BitSet(new long[]{0x0000000010000008L});
	public static final BitSet FOLLOW_formatOption_in_singleValue1830 = new BitSet(new long[]{0x0000000010000008L});
	public static final BitSet FOLLOW_LOCAL_in_singleValue1853 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1857 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CALC_in_singleValue1879 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1883 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRING_in_singleValue1906 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_singleValue1948 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPERATOR_in_singleValue1969 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORTANT_in_singleValue1990 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FORMAT_in_formatOption2029 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_formatOption2033 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_argument_in_argumentList2074 = new BitSet(new long[]{0x0000000004000002L});
	public static final BitSet FOLLOW_EQUALS_in_argument2107 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_argument2111 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_STRING_in_argument2116 = new BitSet(new long[]{0x0000000000000008L});
}
