/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.concrete.PlayerSession;
import flash.util.FieldFormat;
import flash.util.Trace;
import java.io.UnsupportedEncodingException;

public class DMessage {
    public static final int InUnknown = -1;
    public static final int InSetMenuState = 0;
    public static final int InSetProperty = 1;
    public static final int InExit = 2;
    public static final int InNewObject = 3;
    public static final int InRemoveObject = 4;
    public static final int InTrace = 5;
    public static final int InErrorTarget = 6;
    public static final int InErrorExecLimit = 7;
    public static final int InErrorWith = 8;
    public static final int InErrorProtoLimit = 9;
    public static final int InSetVariable = 10;
    public static final int InDeleteVariable = 11;
    public static final int InParam = 12;
    public static final int InPlaceObject = 13;
    public static final int InScript = 14;
    public static final int InAskBreakpoints = 15;
    public static final int InBreakAt = 16;
    public static final int InContinue = 17;
    public static final int InSetLocalVariables = 18;
    public static final int InSetBreakpoint = 19;
    public static final int InNumScript = 20;
    public static final int InRemoveScript = 21;
    public static final int InRemoveBreakpoint = 22;
    public static final int InNotSynced = 23;
    public static final int InErrorURLOpen = 24;
    public static final int InProcessTag = 25;
    public static final int InVersion = 26;
    public static final int InBreakAtExt = 27;
    public static final int InSetVariable2 = 28;
    public static final int InSquelch = 29;
    public static final int InGetVariable = 30;
    public static final int InFrame = 31;
    public static final int InOption = 32;
    public static final int InWatch = 33;
    public static final int InGetSwf = 34;
    public static final int InGetSwd = 35;
    public static final int InErrorException = 36;
    public static final int InErrorStackUnderflow = 37;
    public static final int InErrorZeroDivide = 38;
    public static final int InErrorScriptStuck = 39;
    public static final int InBreakReason = 40;
    public static final int InGetActions = 41;
    public static final int InSwfInfo = 42;
    public static final int InConstantPool = 43;
    public static final int InErrorConsole = 44;
    public static final int InGetFncNames = 45;
    public static final int InCallFunction = 54;
    public static final int InWatch2 = 55;
    public static final int InPassAllExceptionsToDebugger = 56;
    public static final int InBinaryOp = 57;
    public static final int InIsolateCreate = 58;
    public static final int InIsolateExit = 59;
    public static final int InIsolateEnumerate = 60;
    public static final int InSetActiveIsolate = 61;
    public static final int InIsolate = 62;
    public static final int InSetExceptionBreakpoint = 63;
    public static final int InRemoveExceptionBreakpoint = 64;
    public static final int InSIZE = 65;
    public static final int OutUnknown = -2;
    public static final int OutZoomIn = 0;
    public static final int OutZoomOut = 1;
    public static final int OutZoom100 = 2;
    public static final int OutHome = 3;
    public static final int OutSetQuality = 4;
    public static final int OutPlay = 5;
    public static final int OutLoop = 6;
    public static final int OutRewind = 7;
    public static final int OutForward = 8;
    public static final int OutBack = 9;
    public static final int OutPrint = 10;
    public static final int OutSetVariable = 11;
    public static final int OutSetProperty = 12;
    public static final int OutExit = 13;
    public static final int OutSetFocus = 14;
    public static final int OutContinue = 15;
    public static final int OutStopDebug = 16;
    public static final int OutSetBreakpoints = 17;
    public static final int OutRemoveBreakpoints = 18;
    public static final int OutRemoveAllBreakpoints = 19;
    public static final int OutStepOver = 20;
    public static final int OutStepInto = 21;
    public static final int OutStepOut = 22;
    public static final int OutProcessedTag = 23;
    public static final int OutSetSquelch = 24;
    public static final int OutGetVariable = 25;
    public static final int OutGetFrame = 26;
    public static final int OutGetOption = 27;
    public static final int OutSetOption = 28;
    public static final int OutAddWatch = 29;
    public static final int OutRemoveWatch = 30;
    public static final int OutStepContinue = 31;
    public static final int OutGetSwf = 32;
    public static final int OutGetSwd = 33;
    public static final int OutGetVariableWhichInvokesGetter = 34;
    public static final int OutGetBreakReason = 35;
    public static final int OutGetActions = 36;
    public static final int OutSetActions = 37;
    public static final int OutSwfInfo = 38;
    public static final int OutConstantPool = 39;
    public static final int OutGetFncNames = 40;
    public static final int OutCallFunction = 48;
    public static final int OutAddWatch2 = 49;
    public static final int OutRemoveWatch2 = 50;
    public static final int OutPassAllExceptionsToDebugger = 51;
    public static final int OutBinaryOp = 52;
    public static final int OutIsolateEnumerate = 53;
    public static final int OutSetActiveIsolate = 54;
    public static final int OutSetExceptionBreakpoint = 55;
    public static final int OutRemoveExceptionBreakpoint = 56;
    public static final int OutSIZE = 57;
    public static final int kNumberType = 0;
    public static final int kBooleanType = 1;
    public static final int kStringType = 2;
    public static final int kObjectType = 3;
    public static final int kMovieClipType = 4;
    public static final int kNullType = 5;
    public static final int kUndefinedType = 6;
    public static final int kReferenceType = 7;
    public static final int kArrayType = 8;
    public static final int kObjectEndType = 9;
    public static final int kStrictArrayType = 10;
    public static final int kDateType = 11;
    public static final int kLongStringType = 12;
    public static final int kUnsupportedType = 13;
    public static final int kRecordSetType = 14;
    public static final int kXMLType = 15;
    public static final int kTypedObjectType = 16;
    public static final int kAvmPlusObjectType = 17;
    public static final int kNamespaceType = 18;
    public static final int kTraitsType = 19;
    byte[] m_content;
    int m_index;
    int m_type;
    private static int m_sizeofPtr;
    private StringBuilder m_debugFormatted;
    private int m_debugFormattedThroughIndex;
    private int m_targetIsolate;

    public DMessage(int n) {
        this.m_content = new byte[n];
        this.m_debugFormatted = new StringBuilder();
        this.m_debugFormattedThroughIndex = 0;
        this.m_targetIsolate = 1;
        this.clear();
    }

    public int getType() {
        return this.m_type;
    }

    public String getInTypeName() {
        return DMessage.inTypeName(this.getType());
    }

    public String getOutTypeName() {
        return DMessage.outTypeName(this.getType());
    }

    public byte[] getData() {
        return this.m_content;
    }

    public int getSize() {
        return this.m_content == null ? 0 : this.m_content.length;
    }

    public int getRemaining() {
        return this.getSize() - this.m_index;
    }

    public int getPosition() {
        return this.m_index;
    }

    public int getTargetIsolate() {
        return this.m_targetIsolate;
    }

    public void setType(int n) {
        this.m_type = n;
    }

    public void setTargetIsolate(int n) {
        this.m_targetIsolate = n;
    }

    public static int getSizeofPtr() {
        assert (m_sizeofPtr != 0);
        return m_sizeofPtr;
    }

    public static void setSizeofPtr(int n) {
        assert (n != 0);
        m_sizeofPtr = n;
    }

    public void reset() {
        this.m_index = 0;
    }

    public void clear() {
        this.setType(-1);
        this.setTargetIsolate(1);
        this.m_debugFormatted.setLength(0);
        this.m_debugFormattedThroughIndex = 0;
        this.reset();
    }

    private long get(int n) throws ArrayIndexOutOfBoundsException {
        if (this.m_index + n > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(this.m_content.length - this.m_index + " < " + n);
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            long l2 = this.m_content[this.m_index++] & 0xFF;
            long l3 = l2 << 8 * i;
            l |= l3;
        }
        this.debugAppendNumber(l, n);
        return l;
    }

    public int getByte() throws ArrayIndexOutOfBoundsException {
        return (int)this.get(1);
    }

    public int getWord() throws ArrayIndexOutOfBoundsException {
        return (int)this.get(2);
    }

    public long getDWord() throws ArrayIndexOutOfBoundsException {
        return this.get(4);
    }

    public long getLong() throws ArrayIndexOutOfBoundsException {
        return this.get(8);
    }

    public long getPtr() throws ArrayIndexOutOfBoundsException {
        return this.get(DMessage.getSizeofPtr());
    }

    public String getString() throws ArrayIndexOutOfBoundsException {
        String string;
        int n = this.m_index;
        boolean bl = false;
        while (!bl) {
            byte by;
            if ((by = this.m_content[this.m_index++]) == 0) {
                bl = true;
                continue;
            }
            if (this.m_index <= this.m_content.length) continue;
            throw new ArrayIndexOutOfBoundsException("no string terminator found @" + this.m_index);
        }
        try {
            string = new String(this.m_content, n, this.m_index - n - 1, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(this.m_content, n, this.m_index - n - 1);
        }
        this.debugAppendString(string);
        return string;
    }

    public void put(long l, int n) throws ArrayIndexOutOfBoundsException {
        if (this.m_index + n > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(this.m_content.length - this.m_index + " < " + n);
        }
        for (int i = 0; i < n; ++i) {
            this.m_content[this.m_index++] = (byte)(l >> 8 * i);
        }
        this.debugAppendNumber(l, n);
    }

    public void putByte(byte by) throws ArrayIndexOutOfBoundsException {
        this.put(by, 1);
    }

    public void putWord(int n) throws ArrayIndexOutOfBoundsException {
        this.put(n, 2);
    }

    public void putDWord(int n) throws ArrayIndexOutOfBoundsException {
        this.put(n, 4);
    }

    public void putLong(long l) throws ArrayIndexOutOfBoundsException {
        this.put(l, 8);
    }

    public void putPtr(long l) throws ArrayIndexOutOfBoundsException {
        this.put(l, DMessage.getSizeofPtr());
    }

    public static int getStringLength(String string) {
        try {
            return string.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.error) {
                Trace.trace(unsupportedEncodingException.toString());
            }
            return 0;
        }
    }

    public void putString(String string) throws ArrayIndexOutOfBoundsException, UnsupportedEncodingException {
        byte[] byArray = string.getBytes("UTF-8");
        int n = byArray.length;
        int n2 = this.m_index + n + 1;
        if (n2 > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.m_content.length);
        }
        System.arraycopy(byArray, 0, this.m_content, this.m_index, n);
        this.m_index += n;
        this.m_content[this.m_index++] = 0;
        this.debugAppendString(string);
    }

    private void debugAppendNumber(long l, int n) {
        if (PlayerSession.m_debugMsgOn || PlayerSession.m_debugMsgFileOn) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("0x");
            FieldFormat.formatLongToHex(stringBuilder, l, n * 2, true);
            this.debugAppend(stringBuilder.toString());
        }
    }

    private void debugAppendString(String string) {
        if (PlayerSession.m_debugMsgOn || PlayerSession.m_debugMsgFileOn) {
            this.debugAppend('\"' + string + '\"');
        }
    }

    private void debugAppend(String string) {
        if ((PlayerSession.m_debugMsgOn || PlayerSession.m_debugMsgFileOn) && this.m_index > this.m_debugFormattedThroughIndex) {
            this.m_debugFormattedThroughIndex = this.m_index;
            if (this.m_debugFormatted.length() > 0) {
                this.m_debugFormatted.append(' ');
            }
            this.m_debugFormatted.append(string);
        }
    }

    public String inToString() {
        return this.inToString(16);
    }

    public String inToString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getInTypeName());
        stringBuilder.append('[');
        stringBuilder.append(this.getSize());
        stringBuilder.append("] ");
        if (this.getSize() > 0) {
            this.appendContent(stringBuilder, n);
        }
        return stringBuilder.toString();
    }

    public String outToString() {
        return this.outToString(16);
    }

    public String outToString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getOutTypeName());
        stringBuilder.append('[');
        stringBuilder.append(this.getSize());
        stringBuilder.append("] ");
        if (this.getSize() > 0) {
            this.appendContent(stringBuilder, n);
        }
        return stringBuilder.toString();
    }

    public StringBuilder appendContent(StringBuilder stringBuilder, int n) {
        int n2 = this.getSize();
        byte[] byArray = this.getData();
        int n3 = 0;
        stringBuilder.append((CharSequence)this.m_debugFormatted);
        for (n3 = 0; n3 < n && n3 + this.m_debugFormattedThroughIndex < n2; ++n3) {
            int n4 = byArray[n3 + this.m_debugFormattedThroughIndex] & 0xFF;
            stringBuilder.append(" 0x");
            FieldFormat.formatLongToHex(stringBuilder, n4, 2, true);
        }
        if (n3 + this.m_debugFormattedThroughIndex < n2) {
            stringBuilder.append(" ...");
        }
        return stringBuilder;
    }

    public static String inTypeName(int n) {
        String string = "InUnknown(" + n + ")";
        switch (n) {
            case 0: {
                string = "InSetMenuState";
                break;
            }
            case 1: {
                string = "InSetProperty";
                break;
            }
            case 2: {
                string = "InExit";
                break;
            }
            case 3: {
                string = "InNewObject";
                break;
            }
            case 4: {
                string = "InRemoveObject";
                break;
            }
            case 5: {
                string = "InTrace";
                break;
            }
            case 6: {
                string = "InErrorTarget";
                break;
            }
            case 7: {
                string = "InErrorExecLimit";
                break;
            }
            case 8: {
                string = "InErrorWith";
                break;
            }
            case 9: {
                string = "InErrorProtoLimit";
                break;
            }
            case 10: {
                string = "InSetVariable";
                break;
            }
            case 11: {
                string = "InDeleteVariable";
                break;
            }
            case 12: {
                string = "InParam";
                break;
            }
            case 13: {
                string = "InPlaceObject";
                break;
            }
            case 14: {
                string = "InScript";
                break;
            }
            case 15: {
                string = "InAskBreakpoints";
                break;
            }
            case 16: {
                string = "InBreakAt";
                break;
            }
            case 17: {
                string = "InContinue";
                break;
            }
            case 18: {
                string = "InSetLocalVariables";
                break;
            }
            case 19: {
                string = "InSetBreakpoint";
                break;
            }
            case 20: {
                string = "InNumScript";
                break;
            }
            case 21: {
                string = "InRemoveScript";
                break;
            }
            case 22: {
                string = "InRemoveBreakpoint";
                break;
            }
            case 23: {
                string = "InNotSynced";
                break;
            }
            case 24: {
                string = "InErrorURLOpen";
                break;
            }
            case 25: {
                string = "InProcessTag";
                break;
            }
            case 26: {
                string = "InVersion";
                break;
            }
            case 27: {
                string = "InBreakAtExt";
                break;
            }
            case 28: {
                string = "InSetVariable2";
                break;
            }
            case 29: {
                string = "InSquelch";
                break;
            }
            case 30: {
                string = "InGetVariable";
                break;
            }
            case 31: {
                string = "InFrame";
                break;
            }
            case 32: {
                string = "InOption";
                break;
            }
            case 33: {
                string = "InWatch";
                break;
            }
            case 34: {
                string = "InGetSwf";
                break;
            }
            case 35: {
                string = "InGetSwd";
                break;
            }
            case 36: {
                string = "InErrorException";
                break;
            }
            case 37: {
                string = "InErrorStackUnderflow";
                break;
            }
            case 38: {
                string = "InErrorZeroDivide";
                break;
            }
            case 39: {
                string = "InErrorScriptStuck";
                break;
            }
            case 40: {
                string = "InBreakReason";
                break;
            }
            case 41: {
                string = "InGetActions";
                break;
            }
            case 42: {
                string = "InSwfInfo";
                break;
            }
            case 43: {
                string = "InConstantPool";
                break;
            }
            case 44: {
                string = "InErrorConsole";
                break;
            }
            case 45: {
                string = "InGetFncNames";
                break;
            }
            case 54: {
                string = "InCallFunction";
                break;
            }
            case 55: {
                string = "InWatch2";
                break;
            }
            case 56: {
                string = "InPassAllExceptionsToDebugger";
                break;
            }
            case 57: {
                string = "InBinaryOp";
                break;
            }
            case 58: {
                string = "InIsolateCreate";
                break;
            }
            case 59: {
                string = "InIsolateExit";
                break;
            }
            case 60: {
                string = "InIsolateEnumerate";
                break;
            }
            case 61: {
                string = "InSetActiveIsolate";
                break;
            }
            case 62: {
                string = "InIsolate";
                break;
            }
            case 63: {
                string = "InSetExceptionBreakpoint";
                break;
            }
            case 64: {
                string = "InRemoveExceptionBreakpoint";
            }
        }
        return string;
    }

    public static String outTypeName(int n) {
        String string = "OutUnknown(" + n + ")";
        switch (n) {
            case 0: {
                string = "OutZoomIn";
                break;
            }
            case 1: {
                string = "OutZoomOut";
                break;
            }
            case 2: {
                string = "OutZoom100";
                break;
            }
            case 3: {
                string = "OutHome";
                break;
            }
            case 4: {
                string = "OutSetQuality";
                break;
            }
            case 5: {
                string = "OutPlay";
                break;
            }
            case 6: {
                string = "OutLoop";
                break;
            }
            case 7: {
                string = "OutRewind";
                break;
            }
            case 8: {
                string = "OutForward";
                break;
            }
            case 9: {
                string = "OutBack";
                break;
            }
            case 10: {
                string = "OutPrint";
                break;
            }
            case 11: {
                string = "OutSetVariable";
                break;
            }
            case 12: {
                string = "OutSetProperty";
                break;
            }
            case 13: {
                string = "OutExit";
                break;
            }
            case 14: {
                string = "OutSetFocus";
                break;
            }
            case 15: {
                string = "OutContinue";
                break;
            }
            case 16: {
                string = "OutStopDebug";
                break;
            }
            case 17: {
                string = "OutSetBreakpoints";
                break;
            }
            case 18: {
                string = "OutRemoveBreakpoints";
                break;
            }
            case 19: {
                string = "OutRemoveAllBreakpoints";
                break;
            }
            case 20: {
                string = "OutStepOver";
                break;
            }
            case 21: {
                string = "OutStepInto";
                break;
            }
            case 22: {
                string = "OutStepOut";
                break;
            }
            case 23: {
                string = "OutProcessedTag";
                break;
            }
            case 24: {
                string = "OutSetSquelch";
                break;
            }
            case 25: {
                string = "OutGetVariable";
                break;
            }
            case 26: {
                string = "OutGetFrame";
                break;
            }
            case 27: {
                string = "OutGetOption";
                break;
            }
            case 28: {
                string = "OutSetOption";
                break;
            }
            case 29: {
                string = "OutAddWatch";
                break;
            }
            case 30: {
                string = "OutRemoveWatch";
                break;
            }
            case 31: {
                string = "OutStepContinue";
                break;
            }
            case 32: {
                string = "OutGetSwf";
                break;
            }
            case 33: {
                string = "OutGetSwd";
                break;
            }
            case 34: {
                string = "OutGetVariableWhichInvokesGetter";
                break;
            }
            case 35: {
                string = "OutGetBreakReason";
                break;
            }
            case 36: {
                string = "OutGetActions";
                break;
            }
            case 37: {
                string = "OutSetActions";
                break;
            }
            case 38: {
                string = "OutSwfInfo";
                break;
            }
            case 39: {
                string = "OutConstantPool";
                break;
            }
            case 40: {
                string = "OutGetFncNames";
                break;
            }
            case 48: {
                string = "OutCallFunction";
                break;
            }
            case 49: {
                string = "OutAddWatch2";
                break;
            }
            case 50: {
                string = "OutRemoveWatch2";
                break;
            }
            case 51: {
                string = "OutPassAllExceptionsToDebugger";
                break;
            }
            case 52: {
                string = "OutBinaryOp";
                break;
            }
            case 53: {
                string = "OutIsolateEnumerate";
                break;
            }
            case 54: {
                string = "OutSetActiveIsolate";
                break;
            }
            case 55: {
                string = "OutSetExceptionBreakpoint";
                break;
            }
            case 56: {
                string = "OutRemoveExceptionBreakpoint";
            }
        }
        return string;
    }
}

