/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.as;

import org.apache.flex.compiler.definitions.AppliedVectorDefinitionFactory;
import org.apache.flex.compiler.definitions.IAppliedVectorDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.internal.tree.as.BaseLiteralContainerNode;
import org.apache.flex.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.flex.compiler.internal.tree.as.LiteralNode;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.ILiteralNode;

public class VectorLiteralNode
extends BaseLiteralContainerNode {
    private ExpressionNodeBase collectionTypeNode;

    public VectorLiteralNode() {
        super(new LiteralNode(ILiteralNode.LiteralType.VECTOR, ""));
    }

    protected VectorLiteralNode(VectorLiteralNode other) {
        super(other);
        this.collectionTypeNode = other.collectionTypeNode != null ? other.collectionTypeNode.copy() : null;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.VectorLiteralID;
    }

    @Override
    public int getChildCount() {
        if (this.collectionTypeNode != null && this.contentsNode != null) {
            return 2;
        }
        if (this.collectionTypeNode != null || this.contentsNode != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public IASNode getChild(int i) {
        if (i == 0) {
            return this.collectionTypeNode != null ? this.collectionTypeNode : this.contentsNode;
        }
        if (i == 1) {
            return this.contentsNode;
        }
        return null;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.collectionTypeNode != null) {
            this.collectionTypeNode.setParent(this);
        }
        if (this.contentsNode != null) {
            this.contentsNode.setParent(this);
        }
    }

    @Override
    public IDefinition resolve(ICompilerProject project) {
        IDefinition type = this.collectionTypeNode.resolve(project);
        if (type instanceof ITypeDefinition) {
            IAppliedVectorDefinition v = AppliedVectorDefinitionFactory.newVector(project, (ITypeDefinition)type);
            return v;
        }
        return null;
    }

    @Override
    protected VectorLiteralNode copy() {
        return new VectorLiteralNode(this);
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        return this.collectionTypeNode.isDynamicExpression(project);
    }

    @Override
    public ILiteralNode.LiteralType getLiteralType() {
        return ILiteralNode.LiteralType.VECTOR;
    }

    public ExpressionNodeBase getCollectionTypeNode() {
        return this.collectionTypeNode;
    }

    public void setCollectionTypeNode(ExpressionNodeBase collectionType) {
        this.collectionTypeNode = collectionType;
    }
}

