/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.mxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.common.MutablePrefixMap;
import org.apache.flex.compiler.common.PrefixMap;
import org.apache.flex.compiler.common.PrefixedXMLName;
import org.apache.flex.compiler.common.SourceLocation;
import org.apache.flex.compiler.common.XMLName;
import org.apache.flex.compiler.filespecs.IFileSpecification;
import org.apache.flex.compiler.internal.mxml.MXMLData;
import org.apache.flex.compiler.internal.mxml.MXMLDialect;
import org.apache.flex.compiler.internal.mxml.MXMLNamespaceAttributeData;
import org.apache.flex.compiler.internal.mxml.MXMLStateSplitter;
import org.apache.flex.compiler.internal.mxml.MXMLTagAttributeData;
import org.apache.flex.compiler.internal.mxml.MXMLUnitData;
import org.apache.flex.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.flex.compiler.mxml.IMXMLData;
import org.apache.flex.compiler.mxml.IMXMLNamespaceAttributeData;
import org.apache.flex.compiler.mxml.IMXMLTagAttributeData;
import org.apache.flex.compiler.mxml.IMXMLTagData;
import org.apache.flex.compiler.mxml.IMXMLTextData;
import org.apache.flex.compiler.mxml.IMXMLUnitData;
import org.apache.flex.compiler.parsing.IMXMLToken;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.MXMLDuplicateAttributeProblem;
import org.apache.flex.compiler.problems.MXMLUnclosedTagProblem;
import org.apache.flex.compiler.problems.SyntaxProblem;
import org.apache.flex.utils.FastStack;

public class MXMLTagData
extends MXMLUnitData
implements IMXMLTagData {
    private static final IMXMLTagAttributeData[] NO_ATTRIBUTES = new IMXMLTagAttributeData[0];
    protected String tagName;
    protected String uri;
    protected String stateName;
    protected IMXMLTagAttributeData[] attributes;
    protected Map<String, IMXMLTagAttributeData> attributeMap;
    protected int nameStart;
    protected int contentEnd;
    protected int nameType;
    protected IMXMLToken commentToken;
    protected int stateStart;
    protected int attributesStart;
    protected boolean emptyTag;
    protected boolean explicitCloseToken;
    Collection<ICompilerProblem> problems;

    public MXMLTagData() {
        this.attributeMap = Collections.emptyMap();
        this.attributes = NO_ATTRIBUTES;
    }

    protected MXMLTagData(MXMLTagData other) {
        super(other);
        this.nameStart = other.nameStart;
        this.contentEnd = other.contentEnd;
        this.tagName = other.tagName;
        this.nameType = other.nameType;
        this.commentToken = other.commentToken;
        this.stateStart = other.stateStart;
        this.stateName = other.stateName;
        this.attributesStart = other.attributesStart;
        this.emptyTag = other.emptyTag;
        this.explicitCloseToken = other.explicitCloseToken;
        this.attributeMap = other.attributeMap;
        this.attributes = other.attributes;
        this.uri = other.uri;
        this.setOffsets(other.getStart(), other.getEnd());
        this.setLine(other.getLine());
        this.setColumn(other.getColumn());
        this.setEndLine(other.getEndLine());
        this.setEndColumn(other.getEndColumn());
    }

    @Override
    public int getContentStart() {
        return this.nameStart;
    }

    @Override
    public int getContentEnd() {
        return this.contentEnd;
    }

    MutablePrefixMap init(IMXMLData mxmlData, MXMLToken nameToken, ListIterator<MXMLToken> tokenIterator, MXMLDialect dialect, IFileSpecification spec, Collection<ICompilerProblem> problems) {
        int nameEnd;
        this.problems = problems;
        this.setSourcePath(mxmlData.getPath());
        MutablePrefixMap map = null;
        this.emptyTag = false;
        this.explicitCloseToken = false;
        int startOffset = nameToken.getStart();
        if (nameToken.getType() == 8) {
            nameToken.truncate(1, 0);
        } else if (nameToken.getType() == 3) {
            nameToken.truncate(2, 0);
        } else {
            problems.add(new SyntaxProblem(nameToken));
            return map;
        }
        int nameStart = nameToken.getStart();
        MXMLStateSplitter splitState = new MXMLStateSplitter(nameToken, dialect, problems, spec);
        this.tagName = splitState.getBaseName();
        if (splitState.getStateName() != null) {
            this.stateName = splitState.getStateName();
            this.stateStart = nameToken.getStart() + splitState.getStateNameOffset();
        }
        this.nameType = nameToken.getType();
        int contentEnd = nameEnd = nameStart + this.tagName.length();
        this.setTagOffsets(startOffset, nameEnd, nameStart, contentEnd);
        this.setColumn(nameToken.getColumn());
        this.setLine(nameToken.getLine());
        this.setEndColumn(nameToken.getEndColumn());
        this.setEndLine(nameToken.getEndLine());
        this.attributesStart = this.getNameEnd();
        ArrayList<MXMLTagAttributeData> attrs = new ArrayList<MXMLTagAttributeData>();
        this.attributeMap = new LinkedHashMap<String, IMXMLTagAttributeData>();
        boolean foundTagEnd = false;
        boolean putTokenBack = false;
        while (tokenIterator.hasNext() && !foundTagEnd) {
            MXMLToken token = tokenIterator.next();
            MXMLTagAttributeData attribute = null;
            switch (token.getType()) {
                case 7: {
                    if (this.nameType == 3) {
                        problems.add(new SyntaxProblem(token));
                        while (tokenIterator.hasNext() && !foundTagEnd) {
                            token = tokenIterator.next();
                            switch (token.getType()) {
                                case 5: 
                                case 11: {
                                    foundTagEnd = true;
                                }
                            }
                        }
                        break;
                    }
                    if (token.getText().startsWith("xmlns")) {
                        attribute = new MXMLNamespaceAttributeData(token, tokenIterator, dialect, spec, problems);
                        if (map == null) {
                            map = new MutablePrefixMap();
                        }
                        map.add(((IMXMLNamespaceAttributeData)((Object)attribute)).getNamespacePrefix(), ((IMXMLNamespaceAttributeData)((Object)attribute)).getNamespace());
                    } else {
                        attribute = new MXMLTagAttributeData(token, tokenIterator, dialect, spec, problems);
                    }
                    attribute.setParent(this);
                    if (this.attributeMap.containsKey(token.getText())) {
                        MXMLDuplicateAttributeProblem problem = new MXMLDuplicateAttributeProblem(attribute);
                        problems.add(problem);
                    }
                    attrs.add(attribute);
                    this.attributeMap.put(token.getText(), attribute);
                    contentEnd = attribute.getAbsoluteEnd();
                    this.setTagOffsets(startOffset, contentEnd, nameStart, contentEnd);
                    break;
                }
                case 11: {
                    foundTagEnd = true;
                    this.explicitCloseToken = !token.isImplicit();
                    break;
                }
                case 5: {
                    this.emptyTag = true;
                    this.explicitCloseToken = !token.isImplicit();
                    foundTagEnd = true;
                    break;
                }
                case 3: 
                case 8: {
                    problems.add(new SyntaxProblem(token));
                    foundTagEnd = true;
                    putTokenBack = true;
                    break;
                }
                default: {
                    problems.add(new SyntaxProblem(token));
                }
            }
            if (foundTagEnd) {
                if (token.isImplicit() && token.getStart() == -1) {
                    this.explicitCloseToken = false;
                    if (tokenIterator.hasNext()) {
                        MXMLToken next = tokenIterator.next();
                        if (next == null) continue;
                        this.setTagOffsets(this.getAbsoluteStart() == -1 ? next.getStart() : this.getAbsoluteStart(), this.getAbsoluteEnd() == -1 ? next.getStart() : this.getAbsoluteEnd(), nameStart == -1 ? next.getStart() : nameStart, contentEnd == -1 ? next.getStart() : contentEnd);
                        tokenIterator.previous();
                        continue;
                    }
                    this.setOffsets(startOffset, this.getNameEnd());
                    continue;
                }
                contentEnd = token.getStart();
                if (!putTokenBack) {
                    this.setTagOffsets(startOffset, token.getEnd(), nameStart, contentEnd);
                    continue;
                }
                this.setTagOffsets(startOffset, contentEnd, nameStart, contentEnd);
                tokenIterator.previous();
                continue;
            }
            if (this.getAbsoluteEnd() >= token.getEnd()) continue;
            contentEnd = token.getEnd();
            this.setTagOffsets(startOffset, contentEnd, nameStart, contentEnd);
        }
        this.attributes = attrs.toArray(new MXMLTagAttributeData[0]);
        return map;
    }

    @Override
    public boolean containsOffset(int offset) {
        boolean ret = offset >= this.nameStart && offset <= this.contentEnd;
        return ret;
    }

    private void setTagOffsets(int start, int end, int contentStart, int contentEnd) {
        assert (!(start > contentStart || contentStart > contentEnd && contentEnd != -1 || contentEnd > end && end != -1));
        this.setOffsets(start, end);
        this.nameStart = contentStart;
        if (contentEnd != -1) {
            this.contentEnd = contentEnd;
        }
    }

    public void setCommentToken(IMXMLToken commentToken) {
        this.commentToken = commentToken;
    }

    public IMXMLToken getCommentToken() {
        return this.commentToken;
    }

    @Override
    public void setParentUnitDataIndex(int parentIndex) {
        if (this.emptyTag && !this.explicitCloseToken && parentIndex == -1) {
            this.emptyTag = false;
        }
        super.setParentUnitDataIndex(parentIndex);
    }

    @Override
    public void adjustOffsets(int offsetAdjustment) {
        super.adjustOffsets(offsetAdjustment);
        this.nameStart += offsetAdjustment;
        this.contentEnd += offsetAdjustment;
        if (this.stateName != null) {
            this.stateStart += offsetAdjustment;
        }
        this.attributesStart += offsetAdjustment;
        for (int i = 0; i < this.attributes.length; ++i) {
            IMXMLTagAttributeData attribute = this.attributes[i];
            ((MXMLTagAttributeData)attribute).adjustOffsets(offsetAdjustment);
        }
    }

    @Override
    public boolean isTag() {
        return true;
    }

    @Override
    public boolean isEmptyTag() {
        return this.emptyTag;
    }

    public void setEmptyTag() {
        this.emptyTag = true;
    }

    @Override
    public boolean hasExplicitCloseTag() {
        return this.explicitCloseToken;
    }

    public boolean isDocumentRoot() {
        if (this.isOpenTag() && this.getParentUnitDataIndex() == -1) {
            int index = this.getIndex();
            if (index == 0) {
                return true;
            }
            --index;
            while (index >= 0) {
                IMXMLUnitData unit = this.getParent().getUnit(index);
                if (unit == null || unit.isTag()) {
                    return false;
                }
                --index;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isOpenTag() {
        return this.nameType == 8;
    }

    @Override
    public boolean isOpenAndNotEmptyTag() {
        return this.isOpenTag() && !this.isEmptyTag();
    }

    @Override
    public boolean isCloseTag() {
        return this.nameType == 3;
    }

    @Override
    public String getName() {
        return this.tagName;
    }

    public PrefixedXMLName getPrefixedXMLName() {
        return new PrefixedXMLName(this.getName(), this.getURI());
    }

    @Override
    public XMLName getXMLName() {
        return new XMLName(this.getURI(), this.getShortName());
    }

    @Override
    public PrefixMap getPrefixMap() {
        return this.getParent().getPrefixMapForData(this);
    }

    @Override
    public PrefixMap getCompositePrefixMap() {
        MutablePrefixMap compMap = new MutablePrefixMap();
        for (IMXMLTagData lookingAt = this; lookingAt != null; lookingAt = lookingAt.getParentTag()) {
            PrefixMap depth = this.getParent().getPrefixMapForData(lookingAt);
            if (depth == null) continue;
            compMap.addAll(depth, true);
        }
        return compMap;
    }

    @Override
    public String getPrefix() {
        String name = this.getName();
        int i = name.indexOf(58);
        return i != -1 ? name.substring(0, i) : "";
    }

    @Override
    public String getShortName() {
        String name = this.getName();
        int i = name.indexOf(58);
        return i != -1 ? name.substring(i + 1) : name;
    }

    @Override
    public String getURI() {
        if (this.uri == null) {
            String prefix = this.getPrefix();
            for (IMXMLTagData lookingAt = this; lookingAt != null; lookingAt = lookingAt.getParentTag()) {
                PrefixMap depth = this.getParent().getPrefixMapForData(lookingAt);
                if (depth == null || !depth.containsPrefix(prefix)) continue;
                this.uri = depth.getNamespaceForPrefix(prefix);
                break;
            }
        }
        return this.uri;
    }

    public void invalidateURI() {
        this.uri = null;
        int length = this.attributes.length;
        for (int i = 0; i < length; ++i) {
            ((MXMLTagAttributeData)this.attributes[i]).invalidateURI();
        }
    }

    @Override
    public String getStateName() {
        return this.stateName != null ? this.stateName : "";
    }

    public boolean hasAttribute(String attributeName) {
        return this.attributeMap.containsKey(attributeName);
    }

    public boolean hasState() {
        return this.stateName != null;
    }

    public int getStateStart() {
        return this.stateStart;
    }

    public int getStateEnd() {
        return this.stateName != null ? this.stateName.length() + this.stateStart : 0;
    }

    @Override
    public String getRawAttributeValue(String attributeName) {
        IMXMLTagAttributeData attributeData = this.attributeMap.get(attributeName);
        if (attributeData != null) {
            return attributeData.getRawValue();
        }
        return null;
    }

    @Override
    public IMXMLTagAttributeData getTagAttributeData(String attributeName) {
        return this.attributeMap.get(attributeName);
    }

    public int getNameStart() {
        return this.nameStart;
    }

    public int getNameEnd() {
        return this.nameStart + this.tagName.length();
    }

    public int getStateNameStart() {
        return this.stateName != null ? this.stateStart : -1;
    }

    public int getStateNameEnd() {
        return this.getStateEnd();
    }

    public int getAttributesStart() {
        return this.attributesStart;
    }

    public int getAttributesEnd() {
        return this.getAbsoluteEnd();
    }

    @Override
    public boolean isOffsetInAttributeList(int offset) {
        return MXMLData.contains(this.attributesStart, this.getAbsoluteEnd(), offset);
    }

    public boolean isInsideStateName(int offset) {
        if (this.stateName != null) {
            return MXMLData.contains(this.getStateStart(), this.getStateEnd(), offset);
        }
        return false;
    }

    public boolean isOffsetInsideContents(int offset) {
        return MXMLData.contains(this.getContentStart(), this.getContentEnd(), offset);
    }

    public String[] getAttributeNames() {
        String[] attributeNames = new String[this.attributes.length];
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeNames[i] = this.attributes[i].getName();
        }
        return attributeNames;
    }

    @Override
    public IMXMLTagAttributeData[] getAttributeDatas() {
        return this.attributes;
    }

    public IMXMLTagAttributeData findAttributeContainingOffset(int offset) {
        ISourceLocation lastAttribute = null;
        IMXMLTagAttributeData attribute = null;
        for (int i = 0; i < this.attributes.length && (attribute = this.attributes[i]).getAbsoluteStart() < offset; ++i) {
            lastAttribute = attribute;
        }
        if (lastAttribute != null && (lastAttribute.getAbsoluteEnd() == -1 || lastAttribute.getAbsoluteEnd() >= offset)) {
            return lastAttribute;
        }
        return null;
    }

    public int[] getTextContentOffsets() {
        int startOffset = -1;
        int endOffset = -1;
        if (!this.isEmptyTag() && this.isOpenTag()) {
            int index;
            IMXMLUnitData[] list = this.getParent().getUnits();
            for (int i = index = this.getIndex() + 1; i < list.length; ++i) {
                IMXMLUnitData next = list[i];
                if (next instanceof IMXMLTextData && ((IMXMLTextData)next).getTextType() == IMXMLTextData.TextType.WHITESPACE) continue;
                if (next.isText()) {
                    startOffset = startOffset == -1 ? next.getAbsoluteStart() : startOffset;
                    endOffset = next.getAbsoluteEnd();
                    continue;
                }
                if (startOffset != -1 || endOffset != -1) break;
                startOffset = this.getAbsoluteEnd();
                endOffset = next.getAbsoluteStart();
                break;
            }
        }
        return new int[]{startOffset, endOffset};
    }

    @Override
    public String getCompilableText() {
        StringBuilder sb = new StringBuilder();
        for (IMXMLUnitData unit = this.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            if (!unit.isText()) continue;
            sb.append(((IMXMLTextData)unit).getCompilableText());
        }
        return sb.toString();
    }

    @Override
    public IMXMLTagData findMatchingEndTag() {
        return this.findMatchingEndTag(false);
    }

    public IMXMLTagData findMatchingEndTag(boolean includeImplicit) {
        IMXMLTagData parentTag;
        if (this.isCloseTag() || this.isEmptyTag()) {
            return null;
        }
        IMXMLTagData startTag = this;
        while ((parentTag = startTag.getContainingTag(startTag.getAbsoluteStart())) != null) {
            startTag = parentTag;
            if (parentTag.getName().equals(this.getName())) continue;
            break;
        }
        IMXMLUnitData[] list = this.getParent().getUnits();
        FastStack<IMXMLTagData> tagStack = new FastStack<IMXMLTagData>();
        IMXMLTagData result = null;
        for (int i = startTag.getIndex(); i < list.length; ++i) {
            IMXMLTagData curTag;
            IMXMLUnitData curUnit = list[i];
            if (!curUnit.isTag() || (curTag = (IMXMLTagData)curUnit).isEmptyTag()) continue;
            if (curTag.isOpenTag()) {
                tagStack.push(curTag);
                continue;
            }
            if (!curTag.isCloseTag()) continue;
            if (tagStack.isEmpty()) {
                return null;
            }
            IMXMLTagData pop = (IMXMLTagData)tagStack.pop();
            if (!pop.getName().equals(curTag.getName()) && !pop.getShortName().equals(curTag.getShortName())) {
                return null;
            }
            if (pop == this) {
                result = curTag;
            }
            if (!tagStack.isEmpty()) continue;
            if (result.isImplicit() && !includeImplicit) {
                return null;
            }
            return result;
        }
        if (!tagStack.isEmpty()) {
            IMXMLTagData pop = (IMXMLTagData)tagStack.pop();
            this.problems.add(new MXMLUnclosedTagProblem(pop, pop.getName()));
        }
        return null;
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    public boolean hasEndTag() {
        if (this.isCloseTag() || this.isEmptyTag()) {
            return this.explicitCloseToken;
        }
        IMXMLTagData tagData = this.findMatchingEndTag();
        return tagData != null && !tagData.isImplicit();
    }

    @Override
    public IMXMLUnitData getFirstChildUnit() {
        if (!this.isOpenAndNotEmptyTag()) {
            return null;
        }
        IMXMLUnitData next = this.getNext();
        if (next == this.findMatchingEndTag()) {
            return null;
        }
        return next;
    }

    @Override
    public IMXMLTagData getFirstChild(boolean includeEmptyTags) {
        IMXMLTagData nextTag = null;
        if (this.isEmptyTag()) {
            return null;
        }
        if (this.isOpenTag()) {
            nextTag = this.getNextTag();
        } else {
            IMXMLTagData openTag = this.getContainingTag(this.getAbsoluteStart());
            nextTag = openTag.getNextTag();
        }
        while (nextTag != null && !nextTag.isCloseTag()) {
            if (nextTag.isOpenAndNotEmptyTag() || nextTag.isEmptyTag() && includeEmptyTags) {
                return nextTag;
            }
            nextTag = nextTag.getNextTag();
        }
        return null;
    }

    @Override
    public IMXMLTagData getNextSibling(boolean includeEmptyTags) {
        IMXMLTagData nextTag = null;
        if (this.isCloseTag() || this.isEmptyTag()) {
            nextTag = this.getNextTag();
        } else {
            IMXMLTagData endTag = this.findMatchingEndTag();
            if (endTag == null) {
                return null;
            }
            nextTag = endTag.getNextTag();
        }
        while (nextTag != null && !nextTag.isCloseTag()) {
            if (nextTag.isOpenAndNotEmptyTag() || nextTag.isEmptyTag() && includeEmptyTags) {
                return nextTag;
            }
            nextTag = nextTag.getNextTag();
        }
        return null;
    }

    public IMXMLTagData[] getChildren(boolean includeEmptyTags) {
        ArrayList<IMXMLTagData> children = new ArrayList<IMXMLTagData>();
        for (IMXMLTagData child = this.getFirstChild(includeEmptyTags); child != null; child = child.getNextSibling(includeEmptyTags)) {
            children.add(child);
        }
        return children.toArray(new IMXMLTagData[0]);
    }

    @Override
    public IMXMLTagData getParentTag() {
        IMXMLUnitData data = this.getParentUnitData();
        if (data instanceof IMXMLTagData) {
            return (IMXMLTagData)data;
        }
        return null;
    }

    @Override
    public ISourceLocation getLocationOfChildUnits() {
        String sourcePath = this.getSourcePath();
        int start = this.getStart();
        int end = this.getEnd();
        int line = this.getLine();
        int column = this.getColumn();
        boolean foundFirstChild = false;
        for (IMXMLUnitData unit = this.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            if (!foundFirstChild) {
                sourcePath = unit.getSourcePath();
                start = unit.getStart();
                line = unit.getLine();
                column = unit.getColumn();
                foundFirstChild = true;
            }
            end = unit.getEnd();
        }
        return new SourceLocation(sourcePath, start, end, line, column);
    }

    @Override
    public boolean verify() {
        super.verify();
        for (IMXMLTagAttributeData attribute : this.getAttributeDatas()) {
            ((MXMLTagAttributeData)attribute).verify();
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        if (this.isCloseTag()) {
            sb.append('/');
        }
        sb.append(this.getName());
        if (this.isEmptyTag()) {
            sb.append('/');
        }
        sb.append('>');
        sb.append(' ');
        sb.append(super.toString());
        sb.append(' ');
        sb.append('(');
        sb.append(this.nameStart);
        sb.append('-');
        sb.append(this.contentEnd);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String toDumpString() {
        return this.buildDumpString(false);
    }

    @Override
    public String buildDumpString(boolean skipSrcPath) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildDumpString(skipSrcPath));
        sb.append('\t');
        sb.append('|');
        sb.append(this.getName());
        sb.append('|');
        return sb.toString();
    }

    public String stringify() {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        if (this.isCloseTag()) {
            sb.append('/');
        }
        sb.append(this.getName());
        for (IMXMLTagAttributeData attribute : this.getAttributeDatas()) {
            sb.append(" ");
            sb.append(attribute.getName());
            sb.append("=\"");
            sb.append(attribute.getRawValue());
            sb.append("\"");
        }
        if (this.isEmptyTag()) {
            sb.append('/');
        }
        sb.append('>');
        for (IMXMLUnitData unit = this.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            if (unit.isText()) {
                sb.append(((IMXMLTextData)unit).getCompilableText());
                continue;
            }
            if (!(unit instanceof MXMLTagData)) continue;
            sb.append(((MXMLTagData)unit).stringify());
        }
        if (!this.isEmptyTag()) {
            sb.append('<');
            sb.append('/');
            sb.append(this.getName());
            sb.append('>');
        }
        return sb.toString();
    }
}

