/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.abc.semantics;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.flex.abc.graph.IBasicBlock;
import org.apache.flex.abc.graph.IFlowgraph;
import org.apache.flex.abc.instructionlist.InstructionList;
import org.apache.flex.abc.semantics.ControlFlowGraph;
import org.apache.flex.abc.semantics.ExceptionInfo;
import org.apache.flex.abc.semantics.FrameCountVisitor;
import org.apache.flex.abc.semantics.Instruction;
import org.apache.flex.abc.semantics.InstructionFactory;
import org.apache.flex.abc.semantics.Label;
import org.apache.flex.abc.semantics.MethodInfo;
import org.apache.flex.abc.semantics.Traits;
import org.apache.flex.abc.visitors.IDiagnosticsVisitor;

public class MethodBodyInfo {
    MethodInfo methodInfo;
    public int max_stack;
    public int max_scope;
    public int initial_scope;
    public int max_local;
    public int max_slot;
    public int code_len;
    Integer explicit_max_stack;
    Integer explicit_init_scope;
    Integer explicit_max_scope;
    Integer explicit_max_local;
    Integer explicit_max_slot;
    Traits traits = new Traits();
    private boolean hasNewclass = false;
    private Vector<ExceptionInfo> exceptions = new Vector();
    InstructionList instructions = new InstructionList();
    IFlowgraph cfg = null;
    byte[] bytecode = null;

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public void setMethodInfo(MethodInfo minfo) {
        this.methodInfo = minfo;
    }

    public Traits getTraits() {
        return this.traits;
    }

    public void setTraits(Traits t) {
        this.traits = t;
    }

    public void setBytecode(byte[] bytecode) {
        this.bytecode = bytecode;
        this.instructions = null;
        this.cfg = null;
    }

    public byte[] getBytecode() {
        assert (this.bytecode != null);
        return this.bytecode;
    }

    public boolean hasBytecode() {
        return this.bytecode != null;
    }

    public IFlowgraph getCfg() {
        if (null == this.cfg) {
            this.rebuildCfg();
        }
        return this.cfg;
    }

    private void rebuildCfg() {
        assert (this.instructions != null) : "Unable to build control flow graph after serialization to ABC";
        this.cfg = new ControlFlowGraph(this);
    }

    public Instruction insn(int opcode) {
        return this.instructions.addInstruction(opcode);
    }

    public Instruction insn(int opcode, Object[] operands) {
        Instruction result = InstructionFactory.getInstruction(opcode, operands);
        this.instructions.addInstruction(result);
        return result;
    }

    public Instruction insn(int opcode, Object pooledValue) {
        Instruction i = InstructionFactory.getInstruction(opcode, pooledValue);
        this.instructions.addInstruction(i);
        return i;
    }

    public Instruction insn(int opcode, int immed) {
        Instruction i = InstructionFactory.getInstruction(opcode, immed);
        this.instructions.addInstruction(i);
        return i;
    }

    public void insn(Instruction instruction) {
        this.instructions.addInstruction(instruction);
    }

    public void computeFrameCounts(IDiagnosticsVisitor diagnosticsVisitor) {
        if (this.explicit_max_stack != null && this.explicit_max_scope != null && this.explicit_max_local != null && this.explicit_max_slot != null) {
            return;
        }
        FrameCountVisitor counts = new FrameCountVisitor(this, diagnosticsVisitor, this.initial_scope);
        this.getCfg().traverseGraph(counts);
        this.max_stack = Math.max(counts.max_stack, this.max_stack);
        this.max_scope = Math.max(counts.max_scope, this.max_scope);
        this.max_local = Math.max(counts.max_local, this.max_local);
        this.max_slot = Math.max(counts.max_slot, this.max_slot);
        this.hasNewclass |= counts.hasNewclassInstruction();
    }

    public int getMaxStack() {
        if (this.explicit_max_stack != null) {
            return this.explicit_max_stack;
        }
        return this.max_stack;
    }

    public int getLocalCount() {
        if (this.explicit_max_local != null) {
            return this.explicit_max_local;
        }
        if ((this.methodInfo.getFlags() & 4) != 0) {
            return this.max_local + 1;
        }
        return this.max_local;
    }

    public int getMaxSlotCount() {
        if (this.explicit_max_slot != null) {
            return this.explicit_max_slot;
        }
        if (this.max_slot < this.traits.getTraitCount()) {
            return this.traits.getTraitCount();
        }
        return this.max_slot;
    }

    public int getMaxScopeDepth() {
        if (this.explicit_max_scope != null) {
            return this.explicit_max_scope;
        }
        return this.max_scope;
    }

    public int addExceptionInfo(ExceptionInfo ex) {
        this.exceptions.add(ex);
        return this.exceptions.size() - 1;
    }

    public int getInitScopeDepth() {
        if (this.explicit_init_scope != null) {
            return this.explicit_init_scope;
        }
        return this.initial_scope;
    }

    public IBasicBlock getBlock(Label target) {
        return this.getBlock(target, true);
    }

    public IBasicBlock getBlock(Label target, boolean throwOnError) {
        IBasicBlock result = this.cfg.getBlock(target);
        if (result == null && throwOnError) {
            throw new IllegalArgumentException("Label " + target.toString() + " was referenced, but never defined.");
        }
        return result;
    }

    public List<ExceptionInfo> getExceptions() {
        if (this.exceptions != null) {
            return this.exceptions;
        }
        return Collections.emptyList();
    }

    public boolean isCatchTarget(Label l) {
        for (ExceptionInfo e : this.exceptions) {
            Label target = e.getTarget();
            if (l.getPosition() != target.getPosition() && l != target) continue;
            return true;
        }
        return false;
    }

    public void setInstructionList(InstructionList new_list) {
        this.instructions = new_list;
        if (this.cfg != null) {
            this.rebuildCfg();
        }
    }

    public InstructionList getInstructionList() {
        assert (this.instructions != null) : "No active InstructionList";
        return this.instructions;
    }

    public void labelCurrent(Label l) {
        assert (this.instructions != null) : "No active InstructionList";
        this.instructions.labelCurrent(l);
    }

    public void labelNext(Label l) {
        assert (this.instructions != null) : "No active InstructionList";
        this.instructions.labelNext(l);
    }

    public boolean hasNewclassInstruction() {
        return this.hasNewclass;
    }
}

