/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.adapters;

import flex.messaging.MessageException;
import flex.messaging.services.messaging.adapters.JMSProducer;
import java.io.Serializable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.NamingException;

public class JMSQueueProducer
extends JMSProducer {
    private QueueSender sender;

    @Override
    public void start() throws NamingException, JMSException {
        super.start();
        Queue queue = null;
        try {
            queue = (Queue)this.destination;
        }
        catch (ClassCastException cce) {
            MessageException me = new MessageException();
            me.setMessage(10813, new Object[]{this.destinationJndiName, this.destination.getClass().getName()});
            throw me;
        }
        try {
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)this.connectionFactory;
            this.connection = this.connectionCredentials != null ? queueFactory.createQueueConnection(this.connectionCredentials.getUsername(), this.connectionCredentials.getPassword()) : queueFactory.createQueueConnection();
        }
        catch (ClassCastException cce) {
            MessageException me = new MessageException();
            me.setMessage(10814, new Object[]{this.destinationJndiName, this.connectionFactory.getClass().getName()});
            throw me;
        }
        QueueConnection queueConnection = (QueueConnection)this.connection;
        this.session = queueConnection.createQueueSession(false, this.getAcknowledgeMode());
        QueueSession queueSession = (QueueSession)this.session;
        this.sender = queueSession.createSender(queue);
        this.producer = this.sender;
        this.connection.start();
    }

    @Override
    void sendTextMessage(String text, Map properties) throws JMSException {
        if (text == null) {
            return;
        }
        TextMessage message = this.session.createTextMessage();
        message.setText(text);
        this.copyHeadersToProperties(properties, (Message)message);
        this.sender.send((Message)message, this.getDeliveryMode(), this.messagePriority, this.getTimeToLive(properties));
    }

    @Override
    void sendObjectMessage(Serializable obj, Map properties) throws JMSException {
        if (obj == null) {
            return;
        }
        ObjectMessage message = this.session.createObjectMessage();
        message.setObject(obj);
        this.copyHeadersToProperties(properties, (Message)message);
        this.sender.send((Message)message, this.getDeliveryMode(), this.messagePriority, this.getTimeToLive(properties));
    }

    @Override
    void sendMapMessage(Map<String, ?> map, Map properties) throws JMSException {
        if (map == null) {
            return;
        }
        MapMessage message = this.session.createMapMessage();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            message.setObject(entry.getKey(), entry.getValue());
        }
        this.copyHeadersToProperties(properties, (Message)message);
        this.sender.send((Message)message, this.getDeliveryMode(), this.messagePriority, this.getTimeToLive(properties));
    }
}

