/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.MessageException;
import flex.messaging.io.ArrayCollection;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.PagedRowSet;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.StatusInfoProxy;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.AbstractAmfOutput;
import flex.messaging.io.amf.Amf3Output;
import flex.messaging.io.amf.AmfTypes;
import flex.messaging.io.amf.TraitsInfo;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.RowSet;
import org.w3c.dom.Document;

public class Amf0Output
extends AbstractAmfOutput
implements AmfTypes {
    public static final byte[] OBJECT_END_MARKER = new byte[]{0, 0, 9};
    protected IdentityHashMap serializedObjects;
    protected int serializedObjectCount = 0;
    protected boolean avmPlus;
    protected Amf3Output avmPlusOutput;

    public Amf0Output(SerializationContext context) {
        super(context);
        context.supportDatesByReference = false;
        this.serializedObjects = new IdentityHashMap(64);
    }

    public void setAvmPlus(boolean a) {
        this.avmPlus = a;
    }

    @Override
    public void reset() {
        super.reset();
        this.serializedObjects.clear();
        this.serializedObjectCount = 0;
        if (this.avmPlusOutput != null) {
            this.avmPlusOutput.reset();
        }
    }

    protected void createAMF3Output() {
        this.avmPlusOutput = new Amf3Output(this.context);
        this.avmPlusOutput.setOutputStream(this.out);
        this.avmPlusOutput.setDebugTrace(this.trace);
    }

    @Override
    public void writeObject(Object o) throws IOException {
        if (o == null) {
            this.writeAMFNull();
            return;
        }
        if (o instanceof String) {
            this.writeAMFString((String)o);
        } else if (o instanceof Number) {
            if (!this.context.legacyBigNumbers && (o instanceof BigInteger || o instanceof BigDecimal)) {
                this.writeAMFString(o.toString());
            } else {
                this.writeAMFDouble(((Number)o).doubleValue());
            }
        } else if (o instanceof Boolean) {
            this.writeAMFBoolean((Boolean)o);
        } else if (o instanceof Character) {
            String s = o.toString();
            this.writeAMFString(s);
        } else if (o instanceof Date) {
            this.writeAMFDate((Date)o);
        } else if (o instanceof Calendar) {
            this.writeAMFDate(((Calendar)o).getTime());
        } else if (o instanceof Enum && PropertyProxyRegistry.getRegistry().getProxy(o.getClass()) == null) {
            Enum enumValue = (Enum)o;
            this.writeAMFString(enumValue.name());
        } else if (this.avmPlus) {
            if (this.avmPlusOutput == null) {
                this.createAMF3Output();
            }
            this.out.writeByte(17);
            this.avmPlusOutput.writeObject(o);
        } else {
            Class<?> cls = o.getClass();
            if (cls.isArray()) {
                this.writeAMFArray(o, cls.getComponentType());
            } else if (o instanceof Map && this.context.legacyMap && !(o instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o);
            } else if (o instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o, null);
                } else {
                    this.writeArrayCollection((Collection)o, null);
                }
            } else if (o instanceof Document) {
                this.out.write(15);
                String xml = this.documentToString(o);
                if (this.isDebug) {
                    this.trace.write(xml);
                }
                this.writeUTF(xml, true, false);
            } else {
                if (o instanceof RowSet) {
                    o = new PagedRowSet((RowSet)o, Integer.MAX_VALUE, false);
                } else if (o instanceof Throwable && this.context.legacyThrowable) {
                    o = new StatusInfoProxy((Throwable)o);
                }
                this.writeCustomObject(o);
            }
        }
    }

    @Override
    public void writeObjectTraits(TraitsInfo traits) throws IOException {
        String className = null;
        if (traits != null) {
            className = traits.getClassName();
        }
        if (this.isDebug) {
            this.trace.startAMFObject(className, this.serializedObjectCount - 1);
        }
        if (className == null || className.length() == 0) {
            this.out.write(3);
        } else {
            this.out.write(16);
            this.out.writeUTF(className);
        }
    }

    @Override
    public void writeObjectProperty(String name, Object value) throws IOException {
        if (this.isDebug) {
            this.trace.namedElement(name);
        }
        this.out.writeUTF(name);
        this.increaseNestObjectLevel();
        this.writeObject(value);
        this.decreaseNestObjectLevel();
    }

    @Override
    public void writeObjectEnd() throws IOException {
        this.out.write(OBJECT_END_MARKER, 0, OBJECT_END_MARKER.length);
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
    }

    protected void writeAMFBoolean(boolean b) throws IOException {
        if (this.isDebug) {
            this.trace.write(b);
        }
        this.out.write(1);
        this.out.writeBoolean(b);
    }

    protected void writeAMFDouble(double d) throws IOException {
        if (this.isDebug) {
            this.trace.write(d);
        }
        this.out.write(0);
        this.out.writeDouble(d);
    }

    protected void writeAMFDate(Date d) throws IOException {
        if (this.isDebug) {
            this.trace.write(d);
        }
        this.out.write(11);
        this.out.writeDouble(d.getTime());
        int nCurrentTimezoneOffset = TimeZone.getDefault().getRawOffset();
        this.out.writeShort(nCurrentTimezoneOffset / 60000);
    }

    protected void writeAMFArray(Object o, Class componentType) throws IOException {
        if (componentType.isPrimitive()) {
            this.writePrimitiveArray(o);
        } else if (componentType.equals(Character.class)) {
            this.writeCharArrayAsString((Character[])o);
        } else {
            this.writeObjectArray((Object[])o, null);
        }
    }

    protected void writeArrayCollection(Collection col, SerializationDescriptor desc) throws IOException {
        if (!this.serializeAsReference(col)) {
            ArrayCollection ac;
            if (col instanceof ArrayCollection) {
                ac = (ArrayCollection)col;
            } else {
                ac = new ArrayCollection(col);
                if (desc != null) {
                    ac.setDescriptor(desc);
                }
            }
            PropertyProxy proxy = PropertyProxyRegistry.getProxy(ac);
            this.writePropertyProxy(proxy, ac);
        }
    }

    protected void writeCustomObject(Object o) throws IOException {
        PropertyProxy proxy = null;
        if (o instanceof PropertyProxy) {
            proxy = (PropertyProxy)o;
            if ((o = proxy.getDefaultInstance()) == null) {
                this.writeAMFNull();
                return;
            }
            if (o instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o, proxy.getDescriptor());
                } else {
                    this.writeArrayCollection((Collection)o, proxy.getDescriptor());
                }
                return;
            }
            if (o.getClass().isArray()) {
                this.writeObjectArray((Object[])o, proxy.getDescriptor());
                return;
            }
            if (this.context.legacyMap && o instanceof Map && !(o instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o);
                return;
            }
        }
        if (!this.serializeAsReference(o)) {
            if (proxy == null) {
                proxy = PropertyProxyRegistry.getProxyAndRegister(o);
            }
            this.writePropertyProxy(proxy, o);
        }
    }

    protected void writePropertyProxy(PropertyProxy pp, Object instance) throws IOException {
        Object newInst = pp.getInstanceToSerialize(instance);
        if (newInst != instance) {
            if (newInst == null) {
                throw new MessageException("PropertyProxy.getInstanceToSerialize class: " + pp.getClass() + " returned null for instance class: " + instance.getClass().getName());
            }
            pp = PropertyProxyRegistry.getProxyAndRegister(newInst);
            instance = newInst;
        }
        boolean externalizable = false;
        List propertyNames = pp.getPropertyNames(instance);
        if (pp instanceof BeanProxy) {
            BeanProxy bp = (BeanProxy)pp;
            Iterator it = propertyNames.iterator();
            while (it.hasNext()) {
                String propName = (String)it.next();
                if (!bp.isWriteOnly(instance, propName)) continue;
                it.remove();
            }
        }
        TraitsInfo ti = new TraitsInfo(pp.getAlias(instance), pp.isDynamic(), externalizable, propertyNames);
        this.writeObjectTraits(ti);
        if (propertyNames != null) {
            for (String propName : propertyNames) {
                Object value = pp.getValue(instance, propName);
                this.writeObjectProperty(propName, value);
            }
        }
        this.writeObjectEnd();
    }

    protected void writeMapAsECMAArray(Map m) throws IOException {
        if (!this.serializeAsReference(m)) {
            if (this.isDebug) {
                this.trace.startECMAArray(this.serializedObjectCount - 1);
            }
            this.out.write(8);
            this.out.writeInt(0);
            for (Object key : m.keySet()) {
                Object value = m.get(key);
                this.writeObjectProperty(key.toString(), value);
            }
            this.writeObjectEnd();
        }
    }

    protected void writeAMFNull() throws IOException {
        if (this.isDebug) {
            this.trace.writeNull();
        }
        this.out.write(5);
    }

    protected void writeAMFString(String str) throws IOException {
        if (this.isDebug) {
            this.trace.writeString(str);
        }
        this.writeUTF(str, false, true);
    }

    protected void writeObjectArray(Object[] values, SerializationDescriptor descriptor) throws IOException {
        if (!this.serializeAsReference(values)) {
            if (this.isDebug) {
                this.trace.startAMFArray(this.serializedObjectCount - 1);
            }
            this.out.write(10);
            this.out.writeInt(values.length);
            for (int i = 0; i < values.length; ++i) {
                Object item;
                if (this.isDebug) {
                    this.trace.arrayElement(i);
                }
                if (!((item = values[i]) == null || descriptor == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Character)) {
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(descriptor);
                    item = proxy;
                }
                this.increaseNestObjectLevel();
                this.writeObject(item);
                this.decreaseNestObjectLevel();
            }
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writeCollection(Collection c, SerializationDescriptor descriptor) throws IOException {
        if (!this.serializeAsReference(c)) {
            if (this.isDebug) {
                this.trace.startAMFArray(this.serializedObjectCount - 1);
            }
            this.out.write(10);
            this.out.writeInt(c.size());
            Iterator it = c.iterator();
            int i = 0;
            while (it.hasNext()) {
                Object item;
                if (this.isDebug) {
                    this.trace.arrayElement(i++);
                }
                if (!((item = it.next()) == null || descriptor == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Character)) {
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(descriptor);
                    item = proxy;
                }
                this.increaseNestObjectLevel();
                this.writeObject(item);
                this.decreaseNestObjectLevel();
            }
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writePrimitiveArray(Object obj) throws IOException {
        block11: {
            Class<?> aType;
            block10: {
                aType = obj.getClass().getComponentType();
                if (!aType.equals(Character.TYPE)) break block10;
                char[] c = (char[])obj;
                this.writeCharArrayAsString(c);
                break block11;
            }
            if (this.serializeAsReference(obj)) break block11;
            if (aType.equals(Boolean.TYPE)) {
                this.out.write(10);
                boolean[] b = (boolean[])obj;
                this.out.writeInt(b.length);
                if (this.isDebug) {
                    this.trace.startAMFArray(this.serializedObjectCount - 1);
                    for (int i = 0; i < b.length; ++i) {
                        this.trace.arrayElement(i);
                        this.writeAMFBoolean(b[i]);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i = 0; i < b.length; ++i) {
                        this.writeAMFBoolean(b[i]);
                    }
                }
            } else {
                this.out.write(10);
                int length = Array.getLength(obj);
                this.out.writeInt(length);
                if (this.isDebug) {
                    this.trace.startAMFArray(this.serializedObjectCount - 1);
                    for (int i = 0; i < length; ++i) {
                        this.trace.arrayElement(i);
                        double v = Array.getDouble(obj, i);
                        this.writeAMFDouble(v);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i = 0; i < length; ++i) {
                        double v = Array.getDouble(obj, i);
                        this.writeAMFDouble(v);
                    }
                }
            }
        }
    }

    protected void writeCharArrayAsString(Character[] ca) throws IOException {
        int length = ca.length;
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            Character c = ca[i];
            chars[i] = c == null ? (char)'\u0000' : ca[i].charValue();
        }
        this.writeCharArrayAsString(chars);
    }

    protected void writeCharArrayAsString(char[] ca) throws IOException {
        this.writeAMFString(new String(ca));
    }

    protected void writeUTF(String str, boolean forceLong, boolean writeType) throws IOException {
        byte[] bytearr;
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        char[] charr = this.getTempCharArray(strlen);
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        int type = forceLong ? 12 : (utflen <= 65535 ? 2 : 12);
        if (writeType) {
            bytearr = this.getTempByteArray(utflen + (type == 2 ? 3 : 5));
            bytearr[count++] = (byte)type;
        } else {
            bytearr = this.getTempByteArray(utflen + (type == 2 ? 2 : 4));
        }
        if (type == 12) {
            bytearr[count++] = (byte)(utflen >>> 24 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 16 & 0xFF);
        }
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c & 0x3F);
        }
        this.out.write(bytearr, 0, count);
    }

    protected void rememberObjectReference(Object obj) {
        this.serializedObjects.put(obj, new Integer(this.serializedObjectCount++));
    }

    /*
     * Unable to fully structure code
     */
    protected boolean serializeAsReference(Object obj) throws IOException {
        ref = this.serializedObjects.get(obj);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                this.out.write(7);
                this.out.writeShort(refNum);
                if (!this.isDebug) ** GOTO lbl13
                this.trace.writeRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("Object reference value is not an Integer");
            }
        } else {
            this.rememberObjectReference(obj);
        }
lbl13:
        // 3 sources

        return ref != null;
    }
}

