/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.widgets.Messages;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CertificateInfoComposite
extends Composite {
    private static final String[] ATTRIBUTES = new String[]{"CN", "L", "ST", "O", "OU", "C", "STREET", "DC", "UID"};
    public static final int GENERAL_TAB_INDEX = 0;
    public static final int DETAILS_TAB_INDEX = 1;
    private TabFolder tabFolder;
    private Text issuedToCN;
    private Text issuedToO;
    private Text issuedToOU;
    private Text serialNumber;
    private Text issuedByCN;
    private Text issuedByO;
    private Text issuedByOU;
    private Text issuesOn;
    private Text expiresOn;
    private Text fingerprintSHA1;
    private Text fingerprintMD5;
    private TreeViewer hierarchyTreeViewer;
    private Tree certificateTree;
    private Text valueText;

    public CertificateInfoComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.createTabFolder();
        this.createGeneralTab();
        this.createDetailsTab();
    }

    private void createTabFolder() {
        this.tabFolder = new TabFolder((Composite)this, 128);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginWidth = 50;
        mainLayout.marginHeight = 50;
        this.tabFolder.setLayout((Layout)mainLayout);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createGeneralTab() {
        Composite generalContainer = new Composite((Composite)this.tabFolder, 0);
        GridLayout currentLayout = new GridLayout(1, false);
        currentLayout.marginHeight = 10;
        currentLayout.marginWidth = 10;
        generalContainer.setLayout((Layout)currentLayout);
        generalContainer.setLayoutData((Object)new GridData(768));
        Group issuedToGroup = BaseWidgetUtils.createGroup((Composite)generalContainer, (String)Messages.getString("CertificateInfoComposite.IssuedToLabel"), (int)1);
        issuedToGroup.setLayoutData((Object)new GridData(768));
        Composite issuedToComposite = BaseWidgetUtils.createColumnContainer((Composite)issuedToGroup, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)issuedToComposite, (String)Messages.getString("CertificateInfoComposite.CommonNameLabel"), (int)1);
        this.issuedToCN = BaseWidgetUtils.createLabeledText((Composite)issuedToComposite, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)issuedToComposite, (String)Messages.getString("CertificateInfoComposite.OrganizationLabel"), (int)1);
        this.issuedToO = BaseWidgetUtils.createLabeledText((Composite)issuedToComposite, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)issuedToComposite, (String)Messages.getString("CertificateInfoComposite.OrganizationalUnitLabel"), (int)1);
        this.issuedToOU = BaseWidgetUtils.createLabeledText((Composite)issuedToComposite, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)issuedToComposite, (String)Messages.getString("CertificateInfoComposite.SerialNumberLabel"), (int)1);
        this.serialNumber = BaseWidgetUtils.createLabeledText((Composite)issuedToComposite, (String)"", (int)1);
        Group issuedFromGroup = BaseWidgetUtils.createGroup((Composite)generalContainer, (String)Messages.getString("CertificateInfoComposite.IssuedByLabel"), (int)1);
        issuedFromGroup.setLayoutData((Object)new GridData(768));
        Composite issuedFromComposite = BaseWidgetUtils.createColumnContainer((Composite)issuedFromGroup, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)issuedFromComposite, (String)Messages.getString("CertificateInfoComposite.CommonNameLabel"), (int)1);
        this.issuedByCN = BaseWidgetUtils.createLabeledText((Composite)issuedFromComposite, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)issuedFromComposite, (String)Messages.getString("CertificateInfoComposite.OrganizationLabel"), (int)1);
        this.issuedByO = BaseWidgetUtils.createLabeledText((Composite)issuedFromComposite, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)issuedFromComposite, (String)Messages.getString("CertificateInfoComposite.OrganizationalUnitLabel"), (int)1);
        this.issuedByOU = BaseWidgetUtils.createLabeledText((Composite)issuedFromComposite, (String)"", (int)1);
        Group validityGroup = BaseWidgetUtils.createGroup((Composite)generalContainer, (String)Messages.getString("CertificateInfoComposite.ValidityLabel"), (int)1);
        validityGroup.setLayoutData((Object)new GridData(768));
        Composite generalComposite = BaseWidgetUtils.createColumnContainer((Composite)validityGroup, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)generalComposite, (String)Messages.getString("CertificateInfoComposite.IssuedOnLabel"), (int)1);
        this.issuesOn = BaseWidgetUtils.createLabeledText((Composite)generalComposite, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)generalComposite, (String)Messages.getString("CertificateInfoComposite.ExpiresOnLabel"), (int)1);
        this.expiresOn = BaseWidgetUtils.createLabeledText((Composite)generalComposite, (String)"", (int)1);
        Group fingerprintsGroup = BaseWidgetUtils.createGroup((Composite)generalContainer, (String)Messages.getString("CertificateInfoComposite.FingerprintsLabel"), (int)1);
        fingerprintsGroup.setLayoutData((Object)new GridData(768));
        Composite fingerprintsComposite = BaseWidgetUtils.createColumnContainer((Composite)fingerprintsGroup, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)fingerprintsComposite, (String)Messages.getString("CertificateInfoComposite.SHA1FingerprintLabel"), (int)1);
        this.fingerprintSHA1 = BaseWidgetUtils.createLabeledText((Composite)fingerprintsComposite, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)fingerprintsComposite, (String)Messages.getString("CertificateInfoComposite.MD5FingerprintLabel"), (int)1);
        this.fingerprintMD5 = BaseWidgetUtils.createLabeledText((Composite)fingerprintsComposite, (String)"", (int)1);
        TabItem generalTab = new TabItem(this.tabFolder, 0, 0);
        generalTab.setText(Messages.getString("CertificateInfoComposite.General"));
        generalTab.setControl((Control)generalContainer);
    }

    private void createDetailsTab() {
        SashForm detailsForm = new SashForm((Composite)this.tabFolder, 512);
        detailsForm.setLayout((Layout)new FillLayout());
        Composite hierarchyContainer = new Composite((Composite)detailsForm, 0);
        GridLayout hierarchyLayout = new GridLayout(1, false);
        hierarchyLayout.marginTop = 10;
        hierarchyLayout.marginWidth = 10;
        hierarchyContainer.setLayout((Layout)hierarchyLayout);
        BaseWidgetUtils.createLabel((Composite)hierarchyContainer, (String)Messages.getString("CertificateInfoComposite.CertificateHierarchyLabel"), (int)1);
        this.hierarchyTreeViewer = new TreeViewer(hierarchyContainer);
        this.hierarchyTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.hierarchyTreeViewer.setContentProvider((IContentProvider)new HierarchyContentProvider());
        this.hierarchyTreeViewer.setLabelProvider((IBaseLabelProvider)new HierarchyLabelProvider());
        this.hierarchyTreeViewer.addSelectionChangedListener(event -> this.populateCertificateTree());
        Composite certificateContainer = new Composite((Composite)detailsForm, 0);
        GridLayout certificateLayout = new GridLayout(1, false);
        certificateLayout.marginWidth = 10;
        certificateContainer.setLayout((Layout)certificateLayout);
        BaseWidgetUtils.createLabel((Composite)certificateContainer, (String)Messages.getString("CertificateInfoComposite.CertificateFieldsLabel"), (int)1);
        this.certificateTree = new Tree(certificateContainer, 2048);
        this.certificateTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.certificateTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem item = (TreeItem)event.item;
                if (item == null || item.getData() == null) {
                    CertificateInfoComposite.this.valueText.setText("");
                } else {
                    CertificateInfoComposite.this.valueText.setText(item.getData().toString());
                }
            }
        });
        Composite valueContainer = new Composite((Composite)detailsForm, 0);
        GridLayout valueLayout = new GridLayout(1, false);
        valueLayout.marginWidth = 10;
        valueLayout.marginBottom = 10;
        valueContainer.setLayout((Layout)valueLayout);
        BaseWidgetUtils.createLabel((Composite)valueContainer, (String)Messages.getString("CertificateInfoComposite.FieldValuesLabel"), (int)1);
        this.valueText = new Text(valueContainer, 2826);
        this.valueText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.valueText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.valueText.setBackground(detailsForm.getBackground());
        detailsForm.setWeights(new int[]{1, 2, 1});
        TabItem detailsTab = new TabItem(this.tabFolder, 0, 1);
        detailsTab.setText(Messages.getString("CertificateInfoComposite.Details"));
        detailsTab.setControl((Control)detailsForm);
    }

    public void setInput(X509Certificate[] certificateChain) {
        X509Certificate certificate = certificateChain[0];
        X500Principal issuedToPrincipal = certificate.getSubjectX500Principal();
        Map<String, String> issuedToAttributes = this.getAttributeMap(issuedToPrincipal);
        this.issuedToCN.setText(issuedToAttributes.get("CN"));
        this.issuedToO.setText(issuedToAttributes.get("O"));
        this.issuedToOU.setText(issuedToAttributes.get("OU"));
        this.serialNumber.setText(certificate.getSerialNumber().toString(16));
        X500Principal issuedFromPrincipal = certificate.getIssuerX500Principal();
        Map<String, String> issuedFromAttributes = this.getAttributeMap(issuedFromPrincipal);
        this.issuedByCN.setText(issuedFromAttributes.get("CN"));
        this.issuedByO.setText(issuedFromAttributes.get("O"));
        this.issuedByOU.setText(issuedFromAttributes.get("OU"));
        this.issuesOn.setText(DateFormatUtils.ISO_DATE_FORMAT.format(certificate.getNotBefore()));
        this.expiresOn.setText(DateFormatUtils.ISO_DATE_FORMAT.format(certificate.getNotAfter()));
        byte[] encoded2 = null;
        try {
            encoded2 = certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {}
        byte[] md5 = DigestUtils.md5((byte[])encoded2);
        String md5HexString = this.getHexString(md5);
        this.fingerprintMD5.setText(md5HexString);
        byte[] sha = DigestUtils.sha((byte[])encoded2);
        String shaHexString = this.getHexString(sha);
        this.fingerprintSHA1.setText(shaHexString);
        CertificateChainItem parentItem = null;
        CertificateChainItem certificateItem = null;
        X509Certificate[] x509CertificateArray = certificateChain;
        int n = certificateChain.length;
        int n2 = 0;
        while (n2 < n) {
            X509Certificate cert = x509CertificateArray[n2];
            CertificateChainItem item = new CertificateChainItem(cert);
            if (parentItem != null) {
                item.child = parentItem;
                parentItem.parent = item;
            }
            if (certificateItem == null) {
                certificateItem = item;
            }
            parentItem = item;
            ++n2;
        }
        this.hierarchyTreeViewer.setInput((Object)new CertificateChainItem[]{parentItem});
        this.hierarchyTreeViewer.expandAll();
        this.hierarchyTreeViewer.setSelection((ISelection)new StructuredSelection((Object)certificateItem), true);
        this.certificateTree.removeAll();
        this.populateCertificateTree();
        this.valueText.setText("");
    }

    private void populateCertificateTree() {
        this.certificateTree.removeAll();
        this.valueText.setText("");
        IStructuredSelection selection = (IStructuredSelection)this.hierarchyTreeViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        CertificateChainItem certificateItem = (CertificateChainItem)selection.getFirstElement();
        X509Certificate certificate = certificateItem.certificate;
        TreeItem rootItem = new TreeItem(this.certificateTree, 0);
        Map<String, String> attributeMap = this.getAttributeMap(certificate.getSubjectX500Principal());
        rootItem.setText(attributeMap.get("CN"));
        TreeItem certItem = this.createTreeItem(rootItem, Messages.getString("CertificateInfoComposite.Certificate"), "");
        this.createTreeItem(certItem, Messages.getString("CertificateInfoComposite.Version"), String.valueOf(certificate.getVersion()));
        this.createTreeItem(certItem, Messages.getString("CertificateInfoComposite.SerialNumber"), certificate.getSerialNumber().toString(16));
        this.createTreeItem(certItem, Messages.getString("CertificateInfoComposite.Signature"), certificate.getSigAlgName());
        this.createTreeItem(certItem, Messages.getString("CertificateInfoComposite.Issuer"), certificate.getIssuerX500Principal().getName());
        TreeItem validityItem = this.createTreeItem(certItem, Messages.getString("CertificateInfoComposite.Validity"), "");
        this.createTreeItem(validityItem, Messages.getString("CertificateInfoComposite.NotBefore"), certificate.getNotBefore().toString());
        this.createTreeItem(validityItem, Messages.getString("CertificateInfoComposite.NotAfter"), certificate.getNotAfter().toString());
        this.createTreeItem(certItem, Messages.getString("CertificateInfoComposite.Subject"), certificate.getSubjectX500Principal().getName());
        TreeItem pkiItem = this.createTreeItem(certItem, Messages.getString("CertificateInfoComposite.SubjectPublicKeyInfo"), "");
        this.createTreeItem(pkiItem, Messages.getString("CertificateInfoComposite.SubjectPublicKeyAlgorithm"), certificate.getPublicKey().getAlgorithm());
        this.createTreeItem(pkiItem, Messages.getString("CertificateInfoComposite.SubjectPublicKey"), new String(Hex.encodeHex((byte[])certificate.getPublicKey().getEncoded())));
        TreeItem extItem = this.createTreeItem(certItem, Messages.getString("CertificateInfoComposite.Extensions"), "");
        this.populateExtensions(extItem, certificate, true);
        this.populateExtensions(extItem, certificate, false);
        this.createTreeItem(rootItem, Messages.getString("CertificateInfoComposite.SignatureAlgorithm"), certificate.getSigAlgName());
        this.createTreeItem(rootItem, Messages.getString("CertificateInfoComposite.Signature"), new String(Hex.encodeHex((byte[])certificate.getSignature())));
        rootItem.setExpanded(true);
        certItem.setExpanded(true);
        validityItem.setExpanded(true);
        pkiItem.setExpanded(true);
        extItem.setExpanded(true);
    }

    private TreeItem createTreeItem(TreeItem parent, String field, String value) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(field);
        item.setData((Object)value);
        return item;
    }

    private void populateExtensions(TreeItem extensionsItem, X509Certificate certificate, boolean critical) {
        Set<String> oids;
        Set<String> set = oids = critical ? certificate.getCriticalExtensionOIDs() : certificate.getNonCriticalExtensionOIDs();
        if (oids != null) {
            for (String oid : oids) {
                byte[] extensionValueBin = certificate.getExtensionValue(oid);
                String extensionValue = null;
                try {
                    ASN1Primitive extension = X509ExtensionUtil.fromExtensionValue((byte[])extensionValueBin);
                    extensionValue = extension.toString();
                }
                catch (IOException iOException) {
                    extensionValue = new String(Hex.encodeHex((byte[])extensionValueBin));
                }
                String value = String.valueOf(Messages.getString("CertificateInfoComposite.ExtensionOIDColon")) + oid + '\n';
                value = String.valueOf(value) + Messages.getString("CertificateInfoComposite.CriticalColon") + Boolean.toString(critical) + '\n';
                value = String.valueOf(value) + Messages.getString("CertificateInfoComposite.ExtensionValueColon") + extensionValue + '\n';
                TreeItem item = this.createTreeItem(extensionsItem, oid, value);
                this.createTreeItem(item, Messages.getString("CertificateInfoComposite.ExtensionOID"), oid);
                this.createTreeItem(item, Messages.getString("CertificateInfoComposite.Critical"), Boolean.toString(critical));
                this.createTreeItem(item, Messages.getString("CertificateInfoComposite.ExtensionValue"), extensionValue);
            }
        }
    }

    private String getHexString(byte[] bytes) {
        char[] hex = Hex.encodeHex((byte[])bytes);
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < hex.length) {
            if (i % 2 == 0 && i > 0) {
                buffer.append(':');
            }
            buffer.append(Character.toUpperCase(hex[i]));
            ++i;
        }
        return buffer.toString();
    }

    private Map<String, String> getAttributeMap(X500Principal principal) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = ATTRIBUTES;
        int n = ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            map.put(attribute, "-");
            ++n2;
        }
        try {
            String name = principal.getName();
            Dn dn = new Dn(new String[]{name});
            for (Rdn rdn : dn) {
                map.put(rdn.getType().toUpperCase(), rdn.getValue());
            }
        }
        catch (LdapInvalidDnException lide) {
            map.put("CN", lide.getMessage());
        }
        return map;
    }

    private class CertificateChainItem {
        private X509Certificate certificate;
        private CertificateChainItem parent;
        private CertificateChainItem child;

        public CertificateChainItem(X509Certificate certificate) {
            this.certificate = certificate;
        }
    }

    class HierarchyContentProvider
    implements ITreeContentProvider {
        HierarchyContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            CertificateChainItem item;
            if (parentElement instanceof CertificateChainItem && (item = (CertificateChainItem)parentElement).child != null) {
                return new CertificateChainItem[]{item.child};
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof CertificateChainItem) {
                CertificateChainItem item = (CertificateChainItem)element;
                return item.parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CertificateChainItem[]) {
                return (CertificateChainItem[])inputElement;
            }
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class HierarchyLabelProvider
    extends LabelProvider {
        HierarchyLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof CertificateChainItem) {
                CertificateChainItem item = (CertificateChainItem)element;
                Map attributeMap = CertificateInfoComposite.this.getAttributeMap(item.certificate.getSubjectX500Principal());
                return (String)attributeMap.get("CN");
            }
            return null;
        }
    }
}

