/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.config.beans.DirectoryServiceBean;
import org.apache.directory.server.config.beans.ExtendedOpHandlerBean;
import org.apache.directory.server.config.beans.InterceptorBean;
import org.apache.directory.server.config.beans.LdapServerBean;
import org.apache.directory.server.config.beans.SaslMechHandlerBean;
import org.apache.directory.server.config.beans.ServerBean;
import org.apache.directory.server.config.beans.TcpTransportBean;
import org.apache.directory.server.config.beans.TransportBean;
import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditorPage;
import org.apache.directory.studio.apacheds.configuration.editor.SupportedCipher;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LdapLdapsServersPage
extends ServerConfigurationEditorPage {
    private static final int DEFAULT_NB_THREADS = 4;
    private static final int DEFAULT_BACKLOG_SIZE = 50;
    private static final String TRANSPORT_ID_LDAP = "ldap";
    public static final String TRANSPORT_ID_LDAPS = "ldaps";
    private static final String SASL_MECHANISMS_SIMPLE = "SIMPLE";
    private static final String SSL_V3 = "SSLv3";
    private static final String TLS_V1_0 = "TLSv1";
    private static final String TLS_V1_1 = "TLSv1.1";
    private static final String TLS_V1_2 = "TLSv1.2";
    private static final String START_TLS_HANDLER_ID = "starttlshandler";
    private static final String START_TLS_HANDLER_CLASS = "org.apache.directory.server.ldap.handlers.extended.StartTlsHandler";
    private static final String HASHING_PASSWORD_INTERCEPTOR_ID = "passwordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA512 = "org.apache.directory.server.core.hash.Ssha512PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA512 = "org.apache.directory.server.core.hash.Sha512PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA384 = "org.apache.directory.server.core.hash.Ssha384PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA384 = "org.apache.directory.server.core.hash.Sha384PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA256 = "org.apache.directory.server.core.hash.Ssha256PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA256 = "org.apache.directory.server.core.hash.Sha256PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_CRYPT = "org.apache.directory.server.core.hash.CryptPasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SMD5 = "org.apache.directory.server.core.hash.Smd5PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_MD5 = "org.apache.directory.server.core.hash.Md5PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA = "org.apache.directory.server.core.hash.SshaPasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA = "org.apache.directory.server.core.hash.ShaPasswordHashingInterceptor";
    public static final String ID = LdapLdapsServersPage.class.getName();
    private static final String TITLE = Messages.getString("LdapLdapsServersPage.LdapLdapsServers");
    private Button enableLdapCheckbox;
    private Text ldapPortText;
    private Text ldapAddressText;
    private Text ldapNbThreadsText;
    private Text ldapBackLogSizeText;
    private Button enableLdapsCheckbox;
    private Text ldapsPortText;
    private Text ldapsAddressText;
    private Text ldapsNbThreadsText;
    private Text ldapsBackLogSizeText;
    private Button needClientAuthCheckbox;
    private Button wantClientAuthCheckbox;
    private boolean wantClientAuthStatus;
    private CheckboxTableViewer ciphersSuiteTableViewer;
    private Button sslv3Checkbox;
    private Button tlsv1_0Checkbox;
    private Button tlsv1_1Checkbox;
    private Button tlsv1_2Checkbox;
    private Text maxTimeLimitText;
    private Text maxSizeLimitText;
    private Text maxPduSizeText;
    private Button authMechSimpleCheckbox;
    private Button authMechCramMd5Checkbox;
    private Button authMechDigestMd5Checkbox;
    private Button authMechGssapiCheckbox;
    private Button authMechNtlmCheckbox;
    private Text authMechNtlmText;
    private Button authMechGssSpnegoCheckbox;
    private Text authMechGssSpnegoText;
    private Text saslHostText;
    private Text saslPrincipalText;
    private Text saslSearchBaseDnText;
    private TableViewer saslRealmsTableViewer;
    private Button addSaslRealmsButton;
    private Button editSaslRealmsButton;
    private Button deleteSaslRealmsButton;
    private Button enableTlsCheckbox;
    private Button enableServerSidePasswordHashingCheckbox;
    private ComboViewer hashingMethodComboViewer;
    private Text keystoreFileText;
    private Button keystoreFileBrowseButton;
    private Text keystorePasswordText;
    private Button showPasswordCheckbox;
    private Text replicationPingerSleepText;
    private Text diskSynchronizationDelayText;
    private SelectionAdapter enableLdapCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean enabled = LdapLdapsServersPage.this.enableLdapCheckbox.getSelection();
            LdapLdapsServersPage.this.getLdapServerTransportBean().setEnabled(enabled);
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.ldapPortText, enabled);
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.ldapAddressText, enabled);
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.ldapNbThreadsText, enabled);
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.ldapBackLogSizeText, enabled);
        }
    };
    private ModifyListener ldapPortTextListener = event -> {
        try {
            int port = Integer.parseInt(this.ldapPortText.getText());
            this.getLdapServerTransportBean().setSystemPort(port);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Wrong LDAP TCP Port : it must be an integer");
        }
    };
    private ModifyListener ldapAddressTextListener = event -> this.getLdapServerTransportBean().setTransportAddress(this.ldapAddressText.getText());
    private ModifyListener ldapNbThreadsTextListener = event -> {
        try {
            int nbThreads = Integer.parseInt(this.ldapNbThreadsText.getText());
            this.getLdapServerTransportBean().setTransportNbThreads(nbThreads);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Wrong LDAP NbThreads : it must be an integer");
        }
    };
    private ModifyListener ldapBackLogSizeTextListener = event -> {
        try {
            int backLogSize = Integer.parseInt(this.ldapBackLogSizeText.getText());
            this.getLdapServerTransportBean().setTransportBackLog(backLogSize);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Wrong LDAP BackLog size : it must be an integer");
        }
    };
    private SelectionAdapter enableLdapsCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean enabled = LdapLdapsServersPage.this.enableLdapsCheckbox.getSelection();
            LdapLdapsServersPage.this.getLdapsServerTransportBean().setEnabled(enabled);
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.ldapsPortText, enabled);
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.ldapsAddressText, enabled);
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.ldapsNbThreadsText, enabled);
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.ldapsBackLogSizeText, enabled);
        }
    };
    private ModifyListener ldapsPortTextListener = event -> {
        try {
            int port = Integer.parseInt(this.ldapsPortText.getText());
            this.getLdapsServerTransportBean().setSystemPort(port);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Wrong LDAPS Port : it must be an integer");
        }
    };
    private ModifyListener ldapsAddressTextListener = event -> this.getLdapsServerTransportBean().setTransportAddress(this.ldapsAddressText.getText());
    private ModifyListener ldapsNbThreadsTextListener = event -> {
        try {
            int nbThreads = Integer.parseInt(this.ldapsNbThreadsText.getText());
            this.getLdapsServerTransportBean().setTransportNbThreads(nbThreads);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Wrong LDAPS NbThreads : it must be an integer");
        }
    };
    private ModifyListener ldapsBackLogSizeTextListener = event -> {
        try {
            int backLogSize = Integer.parseInt(this.ldapsBackLogSizeText.getText());
            this.getLdapsServerTransportBean().setTransportBackLog(backLogSize);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Wrong LDAPS BackLog size : it must be an integer");
        }
    };
    private SelectionAdapter needClientAuthListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean enabled = LdapLdapsServersPage.this.needClientAuthCheckbox.getSelection();
            TransportBean ldapTransport = LdapLdapsServersPage.this.getLdapServerTransportBean();
            ldapTransport.setWantClientAuth(enabled);
            TransportBean ldapsTransport = LdapLdapsServersPage.this.getLdapsServerTransportBean();
            ldapsTransport.setWantClientAuth(enabled);
            if (enabled) {
                LdapLdapsServersPage.this.wantClientAuthCheckbox.setSelection(enabled);
            } else {
                LdapLdapsServersPage.this.wantClientAuthCheckbox.setSelection(LdapLdapsServersPage.this.wantClientAuthStatus);
            }
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.wantClientAuthCheckbox, !enabled);
        }
    };
    private SelectionAdapter wantClientAuthListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean enabled = LdapLdapsServersPage.this.wantClientAuthCheckbox.getSelection();
            TransportBean ldapTransport = LdapLdapsServersPage.this.getLdapServerTransportBean();
            ldapTransport.setWantClientAuth(enabled);
            TransportBean ldapsTransport = LdapLdapsServersPage.this.getLdapsServerTransportBean();
            ldapsTransport.setWantClientAuth(enabled);
            LdapLdapsServersPage.this.wantClientAuthStatus = enabled;
        }
    };
    private ModifyListener saslHostTextListener = event -> this.getLdapServerBean().setLdapServerSaslHost(this.saslHostText.getText());
    private ModifyListener saslPrincipalTextListener = event -> this.getLdapServerBean().setLdapServerSaslPrincipal(this.saslPrincipalText.getText());
    private ModifyListener saslSearchBaseDnTextListener = event -> {
        String searchBaseDnValue = this.saslSearchBaseDnText.getText();
        try {
            Dn searchBaseDn = new Dn(new String[]{searchBaseDnValue});
            this.getLdapServerBean().setSearchBaseDn(searchBaseDn);
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {}
    };
    private ISelectionChangedListener saslRealmsTableViewerSelectionChangedListener = event -> {
        StructuredSelection selection = (StructuredSelection)this.saslRealmsTableViewer.getSelection();
        this.editSaslRealmsButton.setEnabled(!selection.isEmpty());
        this.deleteSaslRealmsButton.setEnabled(!selection.isEmpty());
    };
    private IDoubleClickListener saslRealmsTableViewerDoubleClickListener = event -> this.editSaslRealmsAction();
    private SelectionListener addSaslRealmsButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            InputDialog dialog = new InputDialog(LdapLdapsServersPage.this.editSaslRealmsButton.getShell(), Messages.getString("LdapLdapsServersPage.Add"), Messages.getString("LdapLdapsServersPage.SaslRealms"), null, null);
            if (dialog.open() == 0) {
                String newSaslRealms = dialog.getValue();
                LdapLdapsServersPage.this.getLdapServerBean().addSaslRealms(new String[]{newSaslRealms});
                LdapLdapsServersPage.this.saslRealmsTableViewer.refresh();
                LdapLdapsServersPage.this.saslRealmsTableViewer.setSelection((ISelection)new StructuredSelection((Object)newSaslRealms));
                LdapLdapsServersPage.this.setEditorDirty();
            }
        }
    };
    private SelectionListener editSaslRealmsButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.editSaslRealmsAction();
        }
    };
    private SelectionListener deleteSaslRealmsButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            String selectedSaslRealms = LdapLdapsServersPage.this.getSelectedSaslRealms();
            if (selectedSaslRealms != null) {
                LdapLdapsServersPage.this.getLdapServerBean().getLdapServerSaslRealms().remove(selectedSaslRealms);
                LdapLdapsServersPage.this.saslRealmsTableViewer.refresh();
                LdapLdapsServersPage.this.setEditorDirty();
            }
        }
    };
    private SelectionAdapter authMechSimpleCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableSupportedAuthenticationMechanism(LdapLdapsServersPage.SASL_MECHANISMS_SIMPLE, LdapLdapsServersPage.this.authMechSimpleCheckbox.getSelection());
        }
    };
    private SelectionAdapter authMechGssapiCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableSupportedAuthenticationMechanism("GSSAPI", LdapLdapsServersPage.this.authMechGssapiCheckbox.getSelection());
        }
    };
    private SelectionAdapter authMechCramMd5CheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableSupportedAuthenticationMechanism("CRAM-MD5", LdapLdapsServersPage.this.authMechCramMd5Checkbox.getSelection());
        }
    };
    private SelectionAdapter authMechDigestMd5CheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableSupportedAuthenticationMechanism("DIGEST-MD5", LdapLdapsServersPage.this.authMechDigestMd5Checkbox.getSelection());
        }
    };
    private SelectionAdapter authMechGssSpnegoCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableSupportedAuthenticationMechanism("GSS-SPNEGO", LdapLdapsServersPage.this.authMechGssSpnegoCheckbox.getSelection());
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.authMechGssSpnegoText, LdapLdapsServersPage.this.authMechGssSpnegoCheckbox.getSelection());
        }
    };
    private ModifyListener authMechGssSpnegoTextListener = event -> this.setNtlmMechProviderSupportedAuthenticationMechanism("GSS-SPNEGO", this.authMechGssSpnegoText.getText());
    private SelectionAdapter authMechNtlmCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableSupportedAuthenticationMechanism("NTLM", LdapLdapsServersPage.this.authMechNtlmCheckbox.getSelection());
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.authMechNtlmText, LdapLdapsServersPage.this.authMechNtlmCheckbox.getSelection());
        }
    };
    private ModifyListener authMechNtlmTextListener = event -> this.setNtlmMechProviderSupportedAuthenticationMechanism("NTLM", this.authMechNtlmText.getText());
    private ModifyListener maxTimeLimitTextListener = event -> this.getLdapServerBean().setLdapServerMaxTimeLimit(Integer.parseInt(this.maxTimeLimitText.getText()));
    private ModifyListener maxSizeLimitTextListener = event -> this.getLdapServerBean().setLdapServerMaxSizeLimit(Integer.parseInt(this.maxSizeLimitText.getText()));
    private ModifyListener maxPduSizeTextListener = event -> this.getLdapServerBean().setMaxPDUSize(Integer.parseInt(this.maxPduSizeText.getText()));
    private SelectionAdapter enableTlsCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            this.setEnableTls(LdapLdapsServersPage.this.enableTlsCheckbox.getSelection());
        }

        private void setEnableTls(boolean enabled) {
            LdapLdapsServersPage.this.getTlsExtendedOpHandlerBean().setEnabled(enabled);
        }
    };
    private SelectionAdapter enableServerSidePasswordHashingCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (LdapLdapsServersPage.this.enableServerSidePasswordHashingCheckbox.getSelection()) {
                this.enableHashingPasswordInterceptor();
            } else {
                this.disableHashingPasswordInterceptor();
            }
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.hashingMethodComboViewer.getCombo(), LdapLdapsServersPage.this.enableServerSidePasswordHashingCheckbox.getSelection());
        }

        private void enableHashingPasswordInterceptor() {
            InterceptorBean hashingPasswordInterceptor = LdapLdapsServersPage.this.getHashingPasswordInterceptor();
            if (hashingPasswordInterceptor == null) {
                hashingPasswordInterceptor = LdapLdapsServersPage.this.createHashingPasswordInterceptor();
            }
            hashingPasswordInterceptor.setEnabled(true);
        }

        private void disableHashingPasswordInterceptor() {
            InterceptorBean hashingPasswordInterceptor = LdapLdapsServersPage.this.getHashingPasswordInterceptor();
            if (hashingPasswordInterceptor != null) {
                hashingPasswordInterceptor.setEnabled(false);
            }
        }
    };
    private ISelectionChangedListener hashingMethodComboViewerListener = event -> this.updateHashingMethod();
    private ModifyListener keystoreFileTextListener = event -> {
        String keystoreFile = this.keystoreFileText.getText();
        if (keystoreFile == null || keystoreFile.length() == 0) {
            this.getLdapServerBean().setLdapServerKeystoreFile(null);
        } else {
            this.getLdapServerBean().setLdapServerKeystoreFile(keystoreFile);
        }
    };
    private SelectionListener keystoreFileBrowseButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            FileDialog fileDialog = new FileDialog(LdapLdapsServersPage.this.keystoreFileBrowseButton.getShell(), 4096);
            File file = new File(LdapLdapsServersPage.this.keystoreFileText.getText());
            if (file.isFile()) {
                fileDialog.setFilterPath(file.getParent());
                fileDialog.setFileName(file.getName());
            } else if (file.isDirectory()) {
                fileDialog.setFilterPath(file.getPath());
            } else {
                fileDialog.setFilterPath(null);
            }
            String returnedFileName = fileDialog.open();
            if (returnedFileName != null) {
                LdapLdapsServersPage.this.keystoreFileText.setText(returnedFileName);
                LdapLdapsServersPage.this.setEditorDirty();
            }
        }
    };
    private ModifyListener keystorePasswordTextListener = event -> {
        String keystorePassword = this.keystorePasswordText.getText();
        if (keystorePassword == null || keystorePassword.length() == 0) {
            this.getLdapServerBean().setLdapServerCertificatePassword(null);
        } else {
            this.getLdapServerBean().setLdapServerCertificatePassword(keystorePassword);
        }
    };
    private SelectionListener showPasswordCheckboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (LdapLdapsServersPage.this.showPasswordCheckbox.getSelection()) {
                LdapLdapsServersPage.this.keystorePasswordText.setEchoChar('\u0000');
            } else {
                LdapLdapsServersPage.this.keystorePasswordText.setEchoChar('\u2022');
            }
        }
    };
    private ICheckStateListener ciphersSuiteTableViewerListener = event -> {
        Object[] selectedCipherObjects;
        TransportBean transport = this.getLdapTransportBean(TRANSPORT_ID_LDAP);
        if (transport == null) {
            transport = this.getLdapTransportBean(TRANSPORT_ID_LDAPS);
        }
        if (transport == null) {
            return;
        }
        if (transport.getEnabledCiphers() == null) {
            transport.setEnabledCiphers(SupportedCipher.supportedCipherNamesJava8);
        }
        if (transport.getEnabledCiphers().size() == 1 && !event.getChecked()) {
            CommonUIUtils.openErrorDialog((String)Messages.getString("LdapLdapsServersPage.AtLeastOneCipherMustBeSelected"));
            this.ciphersSuiteTableViewer.setChecked(event.getElement(), !event.getChecked());
            return;
        }
        this.setEditorDirty();
        transport.getEnabledCiphers().clear();
        Object[] objectArray = selectedCipherObjects = this.ciphersSuiteTableViewer.getCheckedElements();
        int n = selectedCipherObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object cipher = objectArray[n2];
            if (cipher instanceof SupportedCipher) {
                SupportedCipher supportedCipher = (SupportedCipher)((Object)((Object)cipher));
                transport.getEnabledCiphers().add(supportedCipher.getCipher());
            }
            ++n2;
        }
    };
    private SelectionAdapter sslv3CheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setProtocol(LdapLdapsServersPage.this.sslv3Checkbox.getSelection(), LdapLdapsServersPage.SSL_V3);
        }
    };
    private SelectionAdapter tlsv1_0CheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setProtocol(LdapLdapsServersPage.this.tlsv1_0Checkbox.getSelection(), LdapLdapsServersPage.TLS_V1_0);
        }
    };
    private SelectionAdapter tlsv1_1CheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setProtocol(LdapLdapsServersPage.this.tlsv1_1Checkbox.getSelection(), LdapLdapsServersPage.TLS_V1_1);
        }
    };
    private SelectionAdapter tlsv1_2CheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setProtocol(LdapLdapsServersPage.this.tlsv1_2Checkbox.getSelection(), LdapLdapsServersPage.TLS_V1_2);
        }
    };
    private ModifyListener replicationPingerSleepTextListener = event -> this.getLdapServerBean().setReplPingerSleep(Integer.parseInt(this.replicationPingerSleepText.getText()));
    private ModifyListener diskSynchronizationDelayTextListener = event -> this.getDirectoryServiceBean().setDsSyncPeriodMillis(Long.parseLong(this.diskSynchronizationDelayText.getText()));

    public LdapLdapsServersPage(ServerConfigurationEditor editor) {
        super(editor, ID, TITLE);
    }

    @Override
    protected void createFormContent(Composite parent, FormToolkit toolkit) {
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        twl.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)twl);
        Composite leftComposite = toolkit.createComposite(parent);
        leftComposite.setLayout((Layout)new GridLayout());
        TableWrapData leftCompositeTableWrapData = new TableWrapData(128, 16);
        leftCompositeTableWrapData.grabHorizontal = true;
        leftComposite.setLayoutData((Object)leftCompositeTableWrapData);
        Composite rightComposite = toolkit.createComposite(parent);
        rightComposite.setLayout((Layout)new GridLayout());
        TableWrapData rightCompositeTableWrapData = new TableWrapData(128, 16);
        rightCompositeTableWrapData.grabHorizontal = true;
        rightComposite.setLayoutData((Object)rightCompositeTableWrapData);
        this.createLdapServerSection(toolkit, leftComposite);
        this.createLimitsSection(toolkit, leftComposite);
        this.createSslStartTlsKeystoreSection(toolkit, leftComposite);
        this.createSslAdvancedSettingsSection(toolkit, leftComposite);
        this.createSupportedAuthenticationMechanismsSection(toolkit, rightComposite);
        this.createSaslSettingsSection(toolkit, rightComposite);
        this.createAdvancedSection(toolkit, rightComposite);
        this.refreshUI();
    }

    private void createLdapServerSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 322);
        section.setText(Messages.getString("LdapLdapsServersPage.LdapLdapsServers"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        section.setClient((Control)composite);
        this.enableLdapCheckbox = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.EnableLdapServer"), 32);
        this.enableLdapCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, gridLayout.numColumns, 1));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.Port"));
        this.ldapPortText = this.createPortText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, Integer.toString(10389));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.Address"));
        this.ldapAddressText = this.createAddressText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, "0.0.0.0");
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.NbThreads"));
        this.ldapNbThreadsText = this.createNbThreadsText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, Integer.toString(4));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.BackLogSize"));
        this.ldapBackLogSizeText = this.createBackLogSizeText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, Integer.toString(50));
        this.enableLdapsCheckbox = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.EnableLdapsServer"), 32);
        this.enableLdapsCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, gridLayout.numColumns, 1));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.Port"));
        this.ldapsPortText = this.createPortText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, Integer.toString(10636));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.Address"));
        this.ldapsAddressText = this.createAddressText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, "0.0.0.0");
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.NbThreads"));
        this.ldapsNbThreadsText = this.createNbThreadsText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, Integer.toString(4));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.BackLogSize"));
        this.ldapsBackLogSizeText = this.createBackLogSizeText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, Integer.toString(50));
    }

    private void createLimitsSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 290);
        section.setText(Messages.getString("LdapLdapsServersPage.Limits"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout glayout = new GridLayout(2, false);
        composite.setLayout((Layout)glayout);
        section.setClient((Control)composite);
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.MaxTimeLimit"));
        this.maxTimeLimitText = BaseWidgetUtils.createIntegerText((FormToolkit)toolkit, (Composite)composite);
        this.maxTimeLimitText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.MaxSizeLimit"));
        this.maxSizeLimitText = BaseWidgetUtils.createIntegerText((FormToolkit)toolkit, (Composite)composite);
        this.maxSizeLimitText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.MaxPduSize"));
        this.maxPduSizeText = BaseWidgetUtils.createIntegerText((FormToolkit)toolkit, (Composite)composite);
        this.maxPduSizeText.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private void createSslStartTlsKeystoreSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 290);
        section.setText(Messages.getString("LdapLdapsServersPage.SslStartTlsKeystore"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout glayout = new GridLayout(3, false);
        composite.setLayout((Layout)glayout);
        section.setClient((Control)composite);
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.Keystore"));
        this.keystoreFileText = toolkit.createText(composite, "");
        this.setGridDataWithDefaultWidth((Control)this.keystoreFileText, new GridData(4, 0x1000000, true, false));
        this.keystoreFileBrowseButton = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.Browse"), 8);
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.Password"));
        this.keystorePasswordText = toolkit.createText(composite, "");
        this.keystorePasswordText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.keystorePasswordText.setEchoChar('\u2022');
        toolkit.createLabel(composite, "");
        this.showPasswordCheckbox = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.ShowPassword"), 32);
        this.showPasswordCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.showPasswordCheckbox.setSelection(false);
    }

    private void createSslAdvancedSettingsSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 290);
        section.setText(Messages.getString("LdapLdapsServersPage.SslAdvancedSettings"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout glayout = new GridLayout(4, false);
        composite.setLayout((Layout)glayout);
        section.setClient((Control)composite);
        this.needClientAuthCheckbox = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.NeedClientAuth"), 32);
        this.needClientAuthCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        toolkit.createLabel(composite, "      ");
        this.wantClientAuthCheckbox = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.WantClientAuth"), 32);
        this.wantClientAuthCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        Label ciphersLabel = toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.CiphersSuite"), 64);
        this.setBold(ciphersLabel);
        ciphersLabel.setLayoutData((Object)new GridData(4, 0, true, false, glayout.numColumns, 1));
        this.ciphersSuiteTableViewer = new CheckboxTableViewer(new Table(composite, 2080));
        this.ciphersSuiteTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ciphersSuiteTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object cipher) {
                if (cipher instanceof SupportedCipher) {
                    SupportedCipher supportedCipher = (SupportedCipher)((Object)cipher);
                    return supportedCipher.getCipher();
                }
                return super.getText(cipher);
            }
        });
        ArrayList<SupportedCipher> supportedCiphers = new ArrayList<SupportedCipher>();
        SupportedCipher[] supportedCipherArray = SupportedCipher.SUPPORTED_CIPHERS;
        int n = SupportedCipher.SUPPORTED_CIPHERS.length;
        int n2 = 0;
        while (n2 < n) {
            SupportedCipher supportedCipher = supportedCipherArray[n2];
            if (supportedCipher.isJava8Implemented()) {
                supportedCiphers.add(supportedCipher);
            }
            ++n2;
        }
        this.ciphersSuiteTableViewer.setInput(supportedCiphers);
        GridData ciphersSuiteTableViewerGridData = new GridData(4, 0, true, false, glayout.numColumns, 5);
        ciphersSuiteTableViewerGridData.heightHint = 60;
        this.ciphersSuiteTableViewer.getControl().setLayoutData((Object)ciphersSuiteTableViewerGridData);
        Label protocolsLabel = toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.EnabledProtocols"), 64);
        this.setBold(protocolsLabel);
        protocolsLabel.setLayoutData((Object)new GridData(4, 0, true, false, glayout.numColumns, 1));
        this.sslv3Checkbox = toolkit.createButton(composite, SSL_V3, 32);
        this.sslv3Checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tlsv1_0Checkbox = toolkit.createButton(composite, TLS_V1_0, 32);
        this.tlsv1_0Checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tlsv1_1Checkbox = toolkit.createButton(composite, TLS_V1_1, 32);
        this.tlsv1_1Checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tlsv1_2Checkbox = toolkit.createButton(composite, TLS_V1_2, 32);
        this.tlsv1_2Checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createAdvancedSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 290);
        section.setText(Messages.getString("LdapLdapsServersPage.Advanced"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout glayout = new GridLayout(2, false);
        composite.setLayout((Layout)glayout);
        section.setClient((Control)composite);
        this.enableTlsCheckbox = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.EnableTls"), 32);
        this.enableTlsCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.enableServerSidePasswordHashingCheckbox = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.EnableServerSidePasswordHashing"), 32);
        this.enableServerSidePasswordHashingCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        Composite hashingMethodComposite = toolkit.createComposite(composite);
        hashingMethodComposite.setLayout((Layout)new GridLayout(3, false));
        hashingMethodComposite.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(hashingMethodComposite, Messages.getString("LdapLdapsServersPage.HashingMethod"));
        Combo hashingMethodCombo = new Combo(hashingMethodComposite, 12);
        hashingMethodCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.adapt((Composite)hashingMethodCombo);
        this.hashingMethodComboViewer = new ComboViewer(hashingMethodCombo);
        this.hashingMethodComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.hashingMethodComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof LdapSecurityConstants) {
                    LdapSecurityConstants hashingMethod = (LdapSecurityConstants)element;
                    return hashingMethod.getName();
                }
                return super.getText(element);
            }
        });
        Object[] hashingMethods = new Object[]{LdapSecurityConstants.HASH_METHOD_SHA, LdapSecurityConstants.HASH_METHOD_SSHA, LdapSecurityConstants.HASH_METHOD_MD5, LdapSecurityConstants.HASH_METHOD_SMD5, LdapSecurityConstants.HASH_METHOD_CRYPT, LdapSecurityConstants.HASH_METHOD_SHA256, LdapSecurityConstants.HASH_METHOD_SSHA256, LdapSecurityConstants.HASH_METHOD_SHA384, LdapSecurityConstants.HASH_METHOD_SSHA384, LdapSecurityConstants.HASH_METHOD_SHA512, LdapSecurityConstants.HASH_METHOD_SSHA512, LdapSecurityConstants.HASH_METHOD_PKCS5S2};
        this.hashingMethodComboViewer.setInput((Object)hashingMethods);
        this.setSelection((Viewer)this.hashingMethodComboViewer, LdapSecurityConstants.HASH_METHOD_SSHA);
        toolkit.createLabel(hashingMethodComposite, "   ");
        Label defaultLabel = this.createDefaultValueLabel(toolkit, hashingMethodComposite, "SSHA");
        defaultLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(composite, "Replication Pinger Sleep (sec):");
        this.replicationPingerSleepText = BaseWidgetUtils.createIntegerText((FormToolkit)toolkit, (Composite)composite);
        this.replicationPingerSleepText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, "Disk Synchronization Delay (ms):");
        this.diskSynchronizationDelayText = BaseWidgetUtils.createIntegerText((FormToolkit)toolkit, (Composite)composite);
        this.diskSynchronizationDelayText.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private void createSupportedAuthenticationMechanismsSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("LdapLdapsServersPage.SupportedAuthenticationMechanisms"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new GridLayout(2, true));
        section.setClient((Control)composite);
        this.authMechSimpleCheckbox = toolkit.createButton(composite, "Simple", 32);
        this.authMechSimpleCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.authMechGssapiCheckbox = toolkit.createButton(composite, "GSSAPI", 32);
        this.authMechGssapiCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.authMechCramMd5Checkbox = toolkit.createButton(composite, "CRAM-MD5", 32);
        this.authMechCramMd5Checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.authMechDigestMd5Checkbox = toolkit.createButton(composite, "DIGEST-MD5", 32);
        this.authMechDigestMd5Checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.authMechNtlmCheckbox = toolkit.createButton(composite, "NTLM", 32);
        this.authMechNtlmCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.createLabel(composite, "");
        Composite authMechNtlmComposite = toolkit.createComposite(composite);
        authMechNtlmComposite.setLayout((Layout)new GridLayout(3, false));
        toolkit.createLabel(authMechNtlmComposite, "   ");
        toolkit.createLabel(authMechNtlmComposite, Messages.getString("LdapLdapsServersPage.Provider"));
        this.authMechNtlmText = toolkit.createText(authMechNtlmComposite, "");
        this.authMechNtlmText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        authMechNtlmComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.authMechGssSpnegoCheckbox = toolkit.createButton(composite, "GSS-SPNEGO", 32);
        this.authMechGssSpnegoCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.createLabel(composite, "");
        Composite authMechGssSpnegoComposite = toolkit.createComposite(composite);
        authMechGssSpnegoComposite.setLayout((Layout)new GridLayout(3, false));
        toolkit.createLabel(authMechGssSpnegoComposite, "   ");
        toolkit.createLabel(authMechGssSpnegoComposite, Messages.getString("LdapLdapsServersPage.Provider"));
        this.authMechGssSpnegoText = toolkit.createText(authMechGssSpnegoComposite, "");
        this.authMechGssSpnegoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        authMechGssSpnegoComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
    }

    private void createSaslSettingsSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 290);
        section.setText(Messages.getString("LdapLdapsServersPage.SaslSettings"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout glayout = new GridLayout(3, false);
        composite.setLayout((Layout)glayout);
        section.setClient((Control)composite);
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.SaslHost"));
        this.saslHostText = toolkit.createText(composite, "");
        this.setGridDataWithDefaultWidth((Control)this.saslHostText, new GridData(4, 0, true, false, 2, 1));
        Label defaultSaslHostLabel = this.createDefaultValueLabel(toolkit, composite, "ldap.example.com");
        defaultSaslHostLabel.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.SaslPrincipal"));
        this.saslPrincipalText = toolkit.createText(composite, "");
        this.setGridDataWithDefaultWidth((Control)this.saslPrincipalText, new GridData(4, 0, true, false, 2, 1));
        Label defaultSaslPrincipalLabel = this.createDefaultValueLabel(toolkit, composite, "ldap/ldap.example.com@EXAMPLE.COM");
        defaultSaslPrincipalLabel.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.SearchBaseDn"));
        this.saslSearchBaseDnText = toolkit.createText(composite, "");
        this.setGridDataWithDefaultWidth((Control)this.saslSearchBaseDnText, new GridData(4, 0, true, false, 2, 1));
        Label defaultSaslSearchBaseDnLabel = this.createDefaultValueLabel(toolkit, composite, "ou=users,dc=example,dc=com");
        defaultSaslSearchBaseDnLabel.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        Label saslRealmsLabel = toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.SaslRealms"), 64);
        this.setBold(saslRealmsLabel);
        saslRealmsLabel.setLayoutData((Object)new GridData(4, 0, true, false, glayout.numColumns, 1));
        this.saslRealmsTableViewer = new TableViewer(composite);
        this.saslRealmsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData saslRealmsTableViewerGridData = new GridData(4, 0x1000000, true, false, 2, 3);
        saslRealmsTableViewerGridData.heightHint = 60;
        this.saslRealmsTableViewer.getControl().setLayoutData((Object)saslRealmsTableViewerGridData);
        this.addSaslRealmsButton = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.Add"), 8);
        this.addSaslRealmsButton.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        this.editSaslRealmsButton = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.Edit"), 8);
        this.editSaslRealmsButton.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        this.editSaslRealmsButton.setEnabled(false);
        this.deleteSaslRealmsButton = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.Delete"), 8);
        this.deleteSaslRealmsButton.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        this.deleteSaslRealmsButton.setEnabled(false);
    }

    private void addListeners() {
        this.addDirtyListener(this.enableLdapCheckbox);
        this.addSelectionListener(this.enableLdapCheckbox, (SelectionListener)this.enableLdapCheckboxListener);
        this.addDirtyListener(this.ldapPortText);
        this.addModifyListener(this.ldapPortText, this.ldapPortTextListener);
        this.addDirtyListener(this.ldapAddressText);
        this.addModifyListener(this.ldapAddressText, this.ldapAddressTextListener);
        this.addDirtyListener(this.ldapNbThreadsText);
        this.addModifyListener(this.ldapNbThreadsText, this.ldapNbThreadsTextListener);
        this.addDirtyListener(this.ldapBackLogSizeText);
        this.addModifyListener(this.ldapBackLogSizeText, this.ldapBackLogSizeTextListener);
        this.addDirtyListener(this.enableLdapsCheckbox);
        this.addSelectionListener(this.enableLdapsCheckbox, (SelectionListener)this.enableLdapsCheckboxListener);
        this.addDirtyListener(this.ldapsAddressText);
        this.addModifyListener(this.ldapsAddressText, this.ldapsAddressTextListener);
        this.addDirtyListener(this.ldapsPortText);
        this.addModifyListener(this.ldapsPortText, this.ldapsPortTextListener);
        this.addDirtyListener(this.ldapsNbThreadsText);
        this.addModifyListener(this.ldapsNbThreadsText, this.ldapsNbThreadsTextListener);
        this.addDirtyListener(this.ldapsBackLogSizeText);
        this.addModifyListener(this.ldapsBackLogSizeText, this.ldapsBackLogSizeTextListener);
        this.addDirtyListener(this.wantClientAuthCheckbox);
        this.addSelectionListener(this.wantClientAuthCheckbox, (SelectionListener)this.wantClientAuthListener);
        this.addDirtyListener(this.needClientAuthCheckbox);
        this.addSelectionListener(this.needClientAuthCheckbox, (SelectionListener)this.needClientAuthListener);
        this.addDirtyListener(this.authMechSimpleCheckbox);
        this.addSelectionListener(this.authMechSimpleCheckbox, (SelectionListener)this.authMechSimpleCheckboxListener);
        this.addDirtyListener(this.authMechGssapiCheckbox);
        this.addSelectionListener(this.authMechGssapiCheckbox, (SelectionListener)this.authMechGssapiCheckboxListener);
        this.addDirtyListener(this.authMechCramMd5Checkbox);
        this.addSelectionListener(this.authMechCramMd5Checkbox, (SelectionListener)this.authMechCramMd5CheckboxListener);
        this.addDirtyListener(this.authMechDigestMd5Checkbox);
        this.addSelectionListener(this.authMechDigestMd5Checkbox, (SelectionListener)this.authMechDigestMd5CheckboxListener);
        this.addDirtyListener(this.authMechNtlmCheckbox);
        this.addSelectionListener(this.authMechNtlmCheckbox, (SelectionListener)this.authMechNtlmCheckboxListener);
        this.addDirtyListener(this.authMechNtlmText);
        this.addModifyListener(this.authMechNtlmText, this.authMechNtlmTextListener);
        this.addDirtyListener(this.authMechGssSpnegoCheckbox);
        this.addSelectionListener(this.authMechGssSpnegoCheckbox, (SelectionListener)this.authMechGssSpnegoCheckboxListener);
        this.addModifyListener(this.authMechGssSpnegoText, this.authMechGssSpnegoTextListener);
        this.addDirtyListener(this.authMechGssSpnegoText);
        this.addModifyListener(this.authMechGssSpnegoText, this.authMechGssSpnegoTextListener);
        this.addDirtyListener(this.keystoreFileText);
        this.addModifyListener(this.keystoreFileText, this.keystoreFileTextListener);
        this.addSelectionListener(this.keystoreFileBrowseButton, this.keystoreFileBrowseButtonSelectionListener);
        this.addDirtyListener(this.keystorePasswordText);
        this.addModifyListener(this.keystorePasswordText, this.keystorePasswordTextListener);
        this.addSelectionListener(this.showPasswordCheckbox, this.showPasswordCheckboxSelectionListener);
        this.addDirtyListener(this.saslHostText);
        this.addModifyListener(this.saslHostText, this.saslHostTextListener);
        this.addDirtyListener(this.saslPrincipalText);
        this.addModifyListener(this.saslPrincipalText, this.saslPrincipalTextListener);
        this.addDirtyListener(this.saslSearchBaseDnText);
        this.addModifyListener(this.saslSearchBaseDnText, this.saslSearchBaseDnTextListener);
        this.addSelectionChangedListener((Viewer)this.saslRealmsTableViewer, this.saslRealmsTableViewerSelectionChangedListener);
        this.addDoubleClickListener((StructuredViewer)this.saslRealmsTableViewer, this.saslRealmsTableViewerDoubleClickListener);
        this.addSelectionListener(this.editSaslRealmsButton, this.editSaslRealmsButtonListener);
        this.addSelectionListener(this.addSaslRealmsButton, this.addSaslRealmsButtonListener);
        this.addSelectionListener(this.deleteSaslRealmsButton, this.deleteSaslRealmsButtonListener);
        this.addDirtyListener(this.maxTimeLimitText);
        this.addModifyListener(this.maxTimeLimitText, this.maxTimeLimitTextListener);
        this.addDirtyListener(this.maxSizeLimitText);
        this.addModifyListener(this.maxSizeLimitText, this.maxSizeLimitTextListener);
        this.addDirtyListener(this.maxPduSizeText);
        this.addModifyListener(this.maxPduSizeText, this.maxPduSizeTextListener);
        this.addDirtyListener(this.enableTlsCheckbox);
        this.addSelectionListener(this.enableTlsCheckbox, (SelectionListener)this.enableTlsCheckboxListener);
        this.addDirtyListener(this.enableServerSidePasswordHashingCheckbox);
        this.addSelectionListener(this.enableServerSidePasswordHashingCheckbox, (SelectionListener)this.enableServerSidePasswordHashingCheckboxListener);
        this.addDirtyListener((Viewer)this.hashingMethodComboViewer);
        this.addSelectionChangedListener((Viewer)this.hashingMethodComboViewer, this.hashingMethodComboViewerListener);
        this.ciphersSuiteTableViewer.addCheckStateListener(this.ciphersSuiteTableViewerListener);
        this.addDirtyListener(this.sslv3Checkbox);
        this.addSelectionListener(this.sslv3Checkbox, (SelectionListener)this.sslv3CheckboxListener);
        this.addDirtyListener(this.tlsv1_0Checkbox);
        this.addSelectionListener(this.tlsv1_0Checkbox, (SelectionListener)this.tlsv1_0CheckboxListener);
        this.addDirtyListener(this.tlsv1_1Checkbox);
        this.addSelectionListener(this.tlsv1_1Checkbox, (SelectionListener)this.tlsv1_1CheckboxListener);
        this.addDirtyListener(this.tlsv1_2Checkbox);
        this.addSelectionListener(this.tlsv1_2Checkbox, (SelectionListener)this.tlsv1_2CheckboxListener);
        this.addDirtyListener(this.replicationPingerSleepText);
        this.addModifyListener(this.replicationPingerSleepText, this.replicationPingerSleepTextListener);
        this.addDirtyListener(this.diskSynchronizationDelayText);
        this.addModifyListener(this.diskSynchronizationDelayText, this.diskSynchronizationDelayTextListener);
    }

    private void removeListeners() {
        this.removeDirtyListener(this.enableLdapCheckbox);
        this.removeSelectionListener(this.enableLdapCheckbox, (SelectionListener)this.enableLdapCheckboxListener);
        this.removeDirtyListener(this.ldapPortText);
        this.removeModifyListener(this.ldapPortText, this.ldapPortTextListener);
        this.removeDirtyListener(this.ldapAddressText);
        this.removeModifyListener(this.ldapAddressText, this.ldapAddressTextListener);
        this.removeDirtyListener(this.ldapNbThreadsText);
        this.removeModifyListener(this.ldapNbThreadsText, this.ldapNbThreadsTextListener);
        this.removeDirtyListener(this.ldapBackLogSizeText);
        this.removeModifyListener(this.ldapBackLogSizeText, this.ldapBackLogSizeTextListener);
        this.removeDirtyListener(this.enableLdapsCheckbox);
        this.removeSelectionListener(this.enableLdapsCheckbox, (SelectionListener)this.enableLdapsCheckboxListener);
        this.removeDirtyListener(this.ldapsPortText);
        this.removeModifyListener(this.ldapsPortText, this.ldapsPortTextListener);
        this.removeDirtyListener(this.ldapsAddressText);
        this.removeModifyListener(this.ldapsAddressText, this.ldapsAddressTextListener);
        this.removeDirtyListener(this.ldapsNbThreadsText);
        this.removeModifyListener(this.ldapsNbThreadsText, this.ldapsNbThreadsTextListener);
        this.removeDirtyListener(this.ldapsBackLogSizeText);
        this.removeModifyListener(this.ldapsBackLogSizeText, this.ldapsBackLogSizeTextListener);
        this.removeDirtyListener(this.wantClientAuthCheckbox);
        this.removeSelectionListener(this.wantClientAuthCheckbox, (SelectionListener)this.wantClientAuthListener);
        this.removeDirtyListener(this.needClientAuthCheckbox);
        this.removeSelectionListener(this.needClientAuthCheckbox, (SelectionListener)this.needClientAuthListener);
        this.removeDirtyListener(this.authMechSimpleCheckbox);
        this.removeSelectionListener(this.authMechSimpleCheckbox, (SelectionListener)this.authMechSimpleCheckboxListener);
        this.removeDirtyListener(this.authMechCramMd5Checkbox);
        this.removeSelectionListener(this.authMechCramMd5Checkbox, (SelectionListener)this.authMechCramMd5CheckboxListener);
        this.removeDirtyListener(this.authMechDigestMd5Checkbox);
        this.removeSelectionListener(this.authMechDigestMd5Checkbox, (SelectionListener)this.authMechDigestMd5CheckboxListener);
        this.removeDirtyListener(this.authMechGssapiCheckbox);
        this.removeSelectionListener(this.authMechGssapiCheckbox, (SelectionListener)this.authMechGssapiCheckboxListener);
        this.removeDirtyListener(this.authMechNtlmCheckbox);
        this.removeSelectionListener(this.authMechNtlmCheckbox, (SelectionListener)this.authMechNtlmCheckboxListener);
        this.removeModifyListener(this.authMechNtlmText, this.authMechNtlmTextListener);
        this.removeDirtyListener(this.authMechNtlmText);
        this.removeModifyListener(this.authMechNtlmText, this.authMechNtlmTextListener);
        this.removeDirtyListener(this.authMechGssSpnegoCheckbox);
        this.removeSelectionListener(this.authMechGssSpnegoCheckbox, (SelectionListener)this.authMechGssSpnegoCheckboxListener);
        this.removeModifyListener(this.authMechGssSpnegoText, this.authMechGssSpnegoTextListener);
        this.removeDirtyListener(this.authMechGssSpnegoText);
        this.removeModifyListener(this.authMechGssSpnegoText, this.authMechGssSpnegoTextListener);
        this.removeDirtyListener(this.keystoreFileText);
        this.removeModifyListener(this.keystoreFileText, this.keystoreFileTextListener);
        this.removeSelectionListener(this.keystoreFileBrowseButton, this.keystoreFileBrowseButtonSelectionListener);
        this.removeDirtyListener(this.keystorePasswordText);
        this.removeModifyListener(this.keystorePasswordText, this.keystorePasswordTextListener);
        this.removeSelectionListener(this.showPasswordCheckbox, this.showPasswordCheckboxSelectionListener);
        this.removeDirtyListener(this.saslHostText);
        this.removeModifyListener(this.saslHostText, this.saslHostTextListener);
        this.removeDirtyListener(this.saslPrincipalText);
        this.removeModifyListener(this.saslPrincipalText, this.saslPrincipalTextListener);
        this.removeDirtyListener(this.saslSearchBaseDnText);
        this.removeModifyListener(this.saslSearchBaseDnText, this.saslSearchBaseDnTextListener);
        this.removeSelectionChangedListener((Viewer)this.saslRealmsTableViewer, this.saslRealmsTableViewerSelectionChangedListener);
        this.removeDoubleClickListener((StructuredViewer)this.saslRealmsTableViewer, this.saslRealmsTableViewerDoubleClickListener);
        this.removeSelectionListener(this.addSaslRealmsButton, this.addSaslRealmsButtonListener);
        this.removeSelectionListener(this.editSaslRealmsButton, this.editSaslRealmsButtonListener);
        this.removeSelectionListener(this.deleteSaslRealmsButton, this.deleteSaslRealmsButtonListener);
        this.removeDirtyListener(this.maxTimeLimitText);
        this.removeModifyListener(this.maxTimeLimitText, this.maxTimeLimitTextListener);
        this.removeDirtyListener(this.maxSizeLimitText);
        this.removeModifyListener(this.maxSizeLimitText, this.maxSizeLimitTextListener);
        this.removeDirtyListener(this.maxPduSizeText);
        this.removeModifyListener(this.maxPduSizeText, this.maxPduSizeTextListener);
        this.removeDirtyListener(this.enableServerSidePasswordHashingCheckbox);
        this.removeSelectionListener(this.enableServerSidePasswordHashingCheckbox, (SelectionListener)this.enableServerSidePasswordHashingCheckboxListener);
        this.removeDirtyListener((Viewer)this.hashingMethodComboViewer);
        this.removeSelectionChangedListener((Viewer)this.hashingMethodComboViewer, this.hashingMethodComboViewerListener);
        this.ciphersSuiteTableViewer.removeCheckStateListener(this.ciphersSuiteTableViewerListener);
        this.removeDirtyListener(this.sslv3Checkbox);
        this.removeSelectionListener(this.sslv3Checkbox, (SelectionListener)this.sslv3CheckboxListener);
        this.removeDirtyListener(this.tlsv1_0Checkbox);
        this.removeSelectionListener(this.tlsv1_0Checkbox, (SelectionListener)this.tlsv1_0CheckboxListener);
        this.removeDirtyListener(this.tlsv1_1Checkbox);
        this.removeSelectionListener(this.tlsv1_1Checkbox, (SelectionListener)this.tlsv1_1CheckboxListener);
        this.removeDirtyListener(this.tlsv1_2Checkbox);
        this.removeSelectionListener(this.tlsv1_2Checkbox, (SelectionListener)this.tlsv1_2CheckboxListener);
        this.removeDirtyListener(this.replicationPingerSleepText);
        this.removeModifyListener(this.replicationPingerSleepText, this.replicationPingerSleepTextListener);
        this.removeDirtyListener(this.diskSynchronizationDelayText);
        this.removeModifyListener(this.diskSynchronizationDelayText, this.diskSynchronizationDelayTextListener);
    }

    @Override
    protected void refreshUI() {
        if (this.isInitialized()) {
            this.removeListeners();
            TransportBean ldapServerTransportBean = this.getLdapServerTransportBean();
            this.setSelection(this.enableLdapCheckbox, ldapServerTransportBean.isEnabled());
            boolean ldapEnabled = this.enableLdapCheckbox.getSelection();
            this.setEnabled((Control)this.ldapPortText, ldapEnabled);
            this.setText(this.ldapPortText, Integer.toString(ldapServerTransportBean.getSystemPort()));
            this.setEnabled((Control)this.ldapAddressText, ldapEnabled);
            this.setText(this.ldapAddressText, ldapServerTransportBean.getTransportAddress());
            this.setEnabled((Control)this.ldapNbThreadsText, ldapEnabled);
            this.setText(this.ldapNbThreadsText, Integer.toString(ldapServerTransportBean.getTransportNbThreads()));
            this.setEnabled((Control)this.ldapBackLogSizeText, ldapEnabled);
            this.setText(this.ldapBackLogSizeText, Integer.toString(ldapServerTransportBean.getTransportBackLog()));
            TransportBean ldapsServerTransportBean = this.getLdapsServerTransportBean();
            this.setSelection(this.enableLdapsCheckbox, ldapsServerTransportBean.isEnabled());
            boolean ldapsEnabled = this.enableLdapsCheckbox.getSelection();
            this.setEnabled((Control)this.ldapsPortText, ldapsEnabled);
            this.setText(this.ldapsPortText, Integer.toString(ldapsServerTransportBean.getSystemPort()));
            this.setEnabled((Control)this.ldapsAddressText, ldapsEnabled);
            this.setText(this.ldapsAddressText, ldapsServerTransportBean.getTransportAddress());
            this.setEnabled((Control)this.ldapsNbThreadsText, ldapsEnabled);
            this.setText(this.ldapsNbThreadsText, Integer.toString(ldapsServerTransportBean.getTransportNbThreads()));
            this.setEnabled((Control)this.ldapsBackLogSizeText, ldapsEnabled);
            this.setText(this.ldapsBackLogSizeText, Integer.toString(ldapsServerTransportBean.getTransportBackLog()));
            LdapServerBean ldapServerBean = this.getLdapServerBean();
            this.setText(this.saslHostText, ldapServerBean.getLdapServerSaslHost());
            this.setText(this.saslPrincipalText, ldapServerBean.getLdapServerSaslPrincipal());
            this.setText(this.saslSearchBaseDnText, ldapServerBean.getSearchBaseDn().toString());
            this.saslRealmsTableViewer.setInput((Object)ldapServerBean.getLdapServerSaslRealms());
            this.saslRealmsTableViewer.refresh();
            this.setText(this.keystoreFileText, ldapServerBean.getLdapServerKeystoreFile());
            this.setText(this.keystorePasswordText, ldapServerBean.getLdapServerCertificatePassword());
            List saslMechHandlers = ldapServerBean.getSaslMechHandlers();
            this.uncheckAllSupportedAuthenticationMechanisms();
            for (SaslMechHandlerBean saslMechHandler : saslMechHandlers) {
                if (SASL_MECHANISMS_SIMPLE.equalsIgnoreCase(saslMechHandler.getSaslMechName())) {
                    this.setSelection(this.authMechSimpleCheckbox, saslMechHandler.isEnabled());
                    continue;
                }
                if ("GSSAPI".equalsIgnoreCase(saslMechHandler.getSaslMechName())) {
                    this.setSelection(this.authMechGssapiCheckbox, saslMechHandler.isEnabled());
                    continue;
                }
                if ("CRAM-MD5".equalsIgnoreCase(saslMechHandler.getSaslMechName())) {
                    this.setSelection(this.authMechCramMd5Checkbox, saslMechHandler.isEnabled());
                    continue;
                }
                if ("DIGEST-MD5".equalsIgnoreCase(saslMechHandler.getSaslMechName())) {
                    this.setSelection(this.authMechDigestMd5Checkbox, saslMechHandler.isEnabled());
                    continue;
                }
                if ("GSS-SPNEGO".equalsIgnoreCase(saslMechHandler.getSaslMechName())) {
                    this.setSelection(this.authMechGssSpnegoCheckbox, saslMechHandler.isEnabled());
                    this.setEnabled((Control)this.authMechGssSpnegoText, saslMechHandler.isEnabled());
                    this.setText(this.authMechGssSpnegoText, saslMechHandler.getNtlmMechProvider());
                    continue;
                }
                if (!"NTLM".equalsIgnoreCase(saslMechHandler.getSaslMechName())) continue;
                this.setSelection(this.authMechNtlmCheckbox, saslMechHandler.isEnabled());
                this.setEnabled((Control)this.authMechNtlmText, saslMechHandler.isEnabled());
                this.setText(this.authMechNtlmText, saslMechHandler.getNtlmMechProvider());
            }
            this.setText(this.maxTimeLimitText, Integer.toString(ldapServerBean.getLdapServerMaxTimeLimit()));
            this.setText(this.maxSizeLimitText, Integer.toString(ldapServerBean.getLdapServerMaxSizeLimit()));
            this.setText(this.maxPduSizeText, Integer.toString(ldapServerBean.getMaxPDUSize()));
            this.setSelection(this.enableTlsCheckbox, this.getTlsExtendedOpHandlerBean().isEnabled());
            InterceptorBean hashingMethodInterceptor = this.getHashingPasswordInterceptor();
            if (hashingMethodInterceptor == null) {
                this.setSelection(this.enableServerSidePasswordHashingCheckbox, false);
                this.setEnabled((Control)this.hashingMethodComboViewer.getCombo(), this.enableServerSidePasswordHashingCheckbox.getSelection());
                this.setSelection((Viewer)this.hashingMethodComboViewer, LdapSecurityConstants.HASH_METHOD_SSHA);
            } else {
                LdapSecurityConstants hashingMethod = this.getHashingMethodFromInterceptor(hashingMethodInterceptor);
                if (hashingMethod != null) {
                    this.setSelection(this.enableServerSidePasswordHashingCheckbox, hashingMethodInterceptor.isEnabled());
                    this.setEnabled((Control)this.hashingMethodComboViewer.getCombo(), this.enableServerSidePasswordHashingCheckbox.getSelection());
                    this.setSelection((Viewer)this.hashingMethodComboViewer, hashingMethod);
                } else {
                    this.setSelection(this.enableServerSidePasswordHashingCheckbox, false);
                    this.setEnabled((Control)this.hashingMethodComboViewer.getCombo(), this.enableServerSidePasswordHashingCheckbox.getSelection());
                    this.setSelection((Viewer)this.hashingMethodComboViewer, LdapSecurityConstants.HASH_METHOD_SSHA);
                }
            }
            List enabledCiphers = ldapServerTransportBean.getEnabledCiphers();
            ArrayList<SupportedCipher> supportedCiphers = new ArrayList<SupportedCipher>();
            if (enabledCiphers == null) {
                for (SupportedCipher cipher : SupportedCipher.supportedCiphersJava8) {
                    supportedCiphers.add(cipher);
                }
            } else {
                for (String supportedCipher : enabledCiphers) {
                    SupportedCipher cipher = SupportedCipher.getByName(supportedCipher);
                    if (cipher == null) continue;
                    supportedCiphers.add(cipher);
                }
            }
            this.ciphersSuiteTableViewer.setCheckedElements(supportedCiphers.toArray());
            this.ciphersSuiteTableViewer.refresh();
            TransportBean transportBean = this.getLdapTransportBean(TRANSPORT_ID_LDAP);
            List enabledProtocols = transportBean.getEnabledProtocols();
            if (enabledProtocols != null) {
                for (String enabledProtocol : transportBean.getEnabledProtocols()) {
                    if (SSL_V3.equalsIgnoreCase(enabledProtocol)) {
                        this.setSelection(this.sslv3Checkbox, true);
                        continue;
                    }
                    if (TLS_V1_0.equalsIgnoreCase(enabledProtocol)) {
                        this.setSelection(this.tlsv1_0Checkbox, true);
                        continue;
                    }
                    if (TLS_V1_1.equalsIgnoreCase(enabledProtocol)) {
                        this.setSelection(this.tlsv1_1Checkbox, true);
                        continue;
                    }
                    if (!TLS_V1_2.equalsIgnoreCase(enabledProtocol)) continue;
                    this.setSelection(this.tlsv1_2Checkbox, true);
                }
            }
            this.setText(this.replicationPingerSleepText, Integer.toString(ldapServerBean.getReplPingerSleep()));
            this.setText(this.diskSynchronizationDelayText, Long.toString(this.getDirectoryServiceBean().getDsSyncPeriodMillis()));
            this.addListeners();
        }
    }

    private void uncheckAllSupportedAuthenticationMechanisms() {
        this.setSelection(this.authMechSimpleCheckbox, false);
        this.setSelection(this.authMechCramMd5Checkbox, false);
        this.setSelection(this.authMechDigestMd5Checkbox, false);
        this.setSelection(this.authMechGssapiCheckbox, false);
        this.setSelection(this.authMechNtlmCheckbox, false);
        this.setEnabled((Control)this.authMechNtlmText, false);
        this.setSelection(this.authMechGssSpnegoCheckbox, false);
        this.setEnabled((Control)this.authMechGssSpnegoText, false);
    }

    private void setEnableSupportedAuthenticationMechanism(String mechanismName, boolean enabled) {
        List saslMechHandlers = this.getLdapServerBean().getSaslMechHandlers();
        for (SaslMechHandlerBean saslMechHandler : saslMechHandlers) {
            if (!mechanismName.equalsIgnoreCase(saslMechHandler.getSaslMechName())) continue;
            saslMechHandler.setEnabled(enabled);
            return;
        }
    }

    private void setNtlmMechProviderSupportedAuthenticationMechanism(String mechanismName, String ntlmMechProvider) {
        List saslMechHandlers = this.getLdapServerBean().getSaslMechHandlers();
        for (SaslMechHandlerBean saslMechHandler : saslMechHandlers) {
            if (!mechanismName.equalsIgnoreCase(saslMechHandler.getSaslMechName())) continue;
            saslMechHandler.setNtlmMechProvider(ntlmMechProvider);
            return;
        }
    }

    private LdapServerBean getLdapServerBean() {
        return LdapLdapsServersPage.getLdapServerBean(this.getDirectoryServiceBean());
    }

    public static LdapServerBean getLdapServerBean(DirectoryServiceBean directoryServiceBean) {
        LdapServerBean ldapServerBean = directoryServiceBean.getLdapServerBean();
        if (ldapServerBean == null) {
            ldapServerBean = new LdapServerBean();
            directoryServiceBean.addServers(new ServerBean[]{ldapServerBean});
        }
        return ldapServerBean;
    }

    private TransportBean getLdapServerTransportBean() {
        return this.getLdapTransportBean(TRANSPORT_ID_LDAP);
    }

    public static TransportBean getLdapServerTransportBean(DirectoryServiceBean directoryServiceBean) {
        return LdapLdapsServersPage.getLdapTransportBean(directoryServiceBean, TRANSPORT_ID_LDAP);
    }

    private TransportBean getLdapsServerTransportBean() {
        return this.getLdapTransportBean(TRANSPORT_ID_LDAPS);
    }

    public static TransportBean getLdapsServerTransportBean(DirectoryServiceBean directoryServiceBean) {
        return LdapLdapsServersPage.getLdapTransportBean(directoryServiceBean, TRANSPORT_ID_LDAPS);
    }

    private TransportBean getLdapTransportBean(String id) {
        return LdapLdapsServersPage.getLdapTransportBean(this.getDirectoryServiceBean(), id);
    }

    public static TransportBean getLdapTransportBean(DirectoryServiceBean directoryServiceBean, String id) {
        LdapServerBean ldapServerBean = LdapLdapsServersPage.getLdapServerBean(directoryServiceBean);
        TcpTransportBean transportBean = null;
        TransportBean[] ldapServerTransportBeans = ldapServerBean.getTransports();
        if (ldapServerTransportBeans != null) {
            TransportBean[] transportBeanArray = ldapServerTransportBeans;
            int n = ldapServerTransportBeans.length;
            int n2 = 0;
            while (n2 < n) {
                TransportBean ldapServerTransportBean = transportBeanArray[n2];
                if (id.equals(ldapServerTransportBean.getTransportId())) {
                    transportBean = ldapServerTransportBean;
                    break;
                }
                ++n2;
            }
        }
        if (transportBean == null) {
            transportBean = new TcpTransportBean();
            ldapServerBean.addTransports(new TransportBean[]{transportBean});
            transportBean.setTransportId(id);
            transportBean.setTransportAddress("0.0.0.0");
            if (TRANSPORT_ID_LDAP.equals(id)) {
                transportBean.setSystemPort(10389);
            } else if (TRANSPORT_ID_LDAPS.equals(id)) {
                transportBean.setSystemPort(10636);
            }
            if (TRANSPORT_ID_LDAPS.equals(id)) {
                transportBean.setTransportEnableSSL(true);
            }
        }
        return transportBean;
    }

    private ExtendedOpHandlerBean getTlsExtendedOpHandlerBean() {
        ExtendedOpHandlerBean extendedOpHandlerBean2;
        LdapServerBean ldapServerBean = this.getLdapServerBean();
        List extendedOpHandlers = ldapServerBean.getExtendedOps();
        for (ExtendedOpHandlerBean extendedOpHandlerBean2 : extendedOpHandlers) {
            if (!START_TLS_HANDLER_ID.equalsIgnoreCase(extendedOpHandlerBean2.getExtendedOpId())) continue;
            return extendedOpHandlerBean2;
        }
        extendedOpHandlerBean2 = new ExtendedOpHandlerBean();
        extendedOpHandlerBean2.setExtendedOpId(START_TLS_HANDLER_ID);
        extendedOpHandlerBean2.setExtendedOpHandlerClass(START_TLS_HANDLER_CLASS);
        extendedOpHandlerBean2.setEnabled(false);
        extendedOpHandlers.add(extendedOpHandlerBean2);
        return extendedOpHandlerBean2;
    }

    private InterceptorBean getHashingPasswordInterceptor() {
        for (InterceptorBean interceptor : this.getDirectoryServiceBean().getInterceptors()) {
            if (!HASHING_PASSWORD_INTERCEPTOR_ID.equalsIgnoreCase(interceptor.getInterceptorId())) continue;
            return interceptor;
        }
        return null;
    }

    private LdapSecurityConstants getHashingMethodFromInterceptor(InterceptorBean interceptor) {
        if (interceptor != null) {
            String interceptorClassName = interceptor.getInterceptorClassName();
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA)) {
                return LdapSecurityConstants.HASH_METHOD_SHA;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA)) {
                return LdapSecurityConstants.HASH_METHOD_SSHA;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_MD5)) {
                return LdapSecurityConstants.HASH_METHOD_MD5;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SMD5)) {
                return LdapSecurityConstants.HASH_METHOD_SMD5;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_CRYPT)) {
                return LdapSecurityConstants.HASH_METHOD_SMD5;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA256)) {
                return LdapSecurityConstants.HASH_METHOD_SHA256;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA256)) {
                return LdapSecurityConstants.HASH_METHOD_SSHA256;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA384)) {
                return LdapSecurityConstants.HASH_METHOD_SHA384;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA384)) {
                return LdapSecurityConstants.HASH_METHOD_SSHA384;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA512)) {
                return LdapSecurityConstants.HASH_METHOD_SHA512;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA512)) {
                return LdapSecurityConstants.HASH_METHOD_SSHA512;
            }
        }
        return null;
    }

    private int getKeyDerivationInterceptorOrder() {
        for (InterceptorBean interceptor : this.getDirectoryServiceBean().getInterceptors()) {
            if (!"keyDerivationInterceptor".equalsIgnoreCase(interceptor.getInterceptorId())) continue;
            return interceptor.getInterceptorOrder();
        }
        return 0;
    }

    private InterceptorBean createHashingPasswordInterceptor() {
        InterceptorBean hashingPasswordInterceptor = new InterceptorBean();
        hashingPasswordInterceptor.setInterceptorId(HASHING_PASSWORD_INTERCEPTOR_ID);
        hashingPasswordInterceptor.setInterceptorClassName(this.getFqcnForHashingMethod(this.getSelectedHashingMethod()));
        int keyDerivationInterceptorOrder = this.getKeyDerivationInterceptorOrder();
        hashingPasswordInterceptor.setInterceptorOrder(keyDerivationInterceptorOrder + 1);
        for (InterceptorBean interceptor : this.getDirectoryServiceBean().getInterceptors()) {
            if (interceptor.getInterceptorOrder() <= keyDerivationInterceptorOrder) continue;
            interceptor.setInterceptorOrder(interceptor.getInterceptorOrder() + 1);
        }
        this.getDirectoryServiceBean().addInterceptors(new InterceptorBean[]{hashingPasswordInterceptor});
        return hashingPasswordInterceptor;
    }

    private void updateHashingMethod() {
        InterceptorBean hashingPasswordInterceptor = this.getHashingPasswordInterceptor();
        if (hashingPasswordInterceptor != null) {
            hashingPasswordInterceptor.setInterceptorClassName(this.getFqcnForHashingMethod(this.getSelectedHashingMethod()));
        }
    }

    private String getFqcnForHashingMethod(LdapSecurityConstants hashingMethod) {
        switch (hashingMethod) {
            case HASH_METHOD_MD5: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_MD5;
            }
            case HASH_METHOD_SMD5: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SMD5;
            }
            case HASH_METHOD_CRYPT: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_CRYPT;
            }
            case HASH_METHOD_SHA256: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA256;
            }
            case HASH_METHOD_SSHA256: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA256;
            }
            case HASH_METHOD_SHA384: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA384;
            }
            case HASH_METHOD_SSHA384: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA384;
            }
            case HASH_METHOD_SHA512: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA512;
            }
            case HASH_METHOD_SSHA512: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA512;
            }
            case HASH_METHOD_SHA: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA;
            }
        }
        return HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA;
    }

    private LdapSecurityConstants getSelectedHashingMethod() {
        StructuredSelection selection = (StructuredSelection)this.hashingMethodComboViewer.getSelection();
        if (!selection.isEmpty()) {
            return (LdapSecurityConstants)selection.getFirstElement();
        }
        return null;
    }

    private void setProtocol(boolean enabled, String protocol) {
        if (enabled) {
            ArrayList<String> enabledProtocols = this.getLdapTransportBean(TRANSPORT_ID_LDAP).getEnabledProtocols();
            if (enabledProtocols == null) {
                enabledProtocols = new ArrayList<String>();
            }
            if (!enabledProtocols.contains(protocol)) {
                enabledProtocols.add(protocol);
            }
            this.getLdapTransportBean(TRANSPORT_ID_LDAP).setEnabledProtocols(enabledProtocols);
            this.getLdapTransportBean(TRANSPORT_ID_LDAPS).setEnabledProtocols(enabledProtocols);
        } else {
            List enabledProtocols = this.getLdapTransportBean(TRANSPORT_ID_LDAP).getEnabledProtocols();
            enabledProtocols.remove(protocol);
            this.getLdapTransportBean(TRANSPORT_ID_LDAP).setEnabledProtocols(enabledProtocols);
            this.getLdapTransportBean(TRANSPORT_ID_LDAPS).setEnabledProtocols(enabledProtocols);
        }
    }

    private String getSelectedSaslRealms() {
        StructuredSelection selection = (StructuredSelection)this.saslRealmsTableViewer.getSelection();
        if (!selection.isEmpty()) {
            return (String)selection.getFirstElement();
        }
        return null;
    }

    private void editSaslRealmsAction() {
        InputDialog dialog;
        String selectedSaslRealms = this.getSelectedSaslRealms();
        if (selectedSaslRealms != null && (dialog = new InputDialog(this.editSaslRealmsButton.getShell(), Messages.getString("LdapLdapsServersPage.Edit"), Messages.getString("LdapLdapsServersPage.SaslRealms"), selectedSaslRealms, null)).open() == 0) {
            String newSaslRealms = dialog.getValue();
            this.getLdapServerBean().getLdapServerSaslRealms().remove(selectedSaslRealms);
            this.getLdapServerBean().addSaslRealms(new String[]{newSaslRealms});
            this.saslRealmsTableViewer.refresh();
            this.saslRealmsTableViewer.setSelection((ISelection)new StructuredSelection((Object)newSaslRealms));
            this.setEditorDirty();
        }
    }
}

