/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.actions;

import org.apache.directory.studio.apacheds.configuration.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.editor.ConnectionServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.connection.core.Connection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenConfigurationAction
implements IObjectActionDelegate {
    private Connection selectedConnection;

    public void run(IAction action) {
        if (this.selectedConnection != null) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)new ConnectionServerConfigurationInput(this.selectedConnection), ServerConfigurationEditor.ID);
                }
                catch (PartInitException e) {
                    ApacheDS2ConfigurationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.apache.directory.studio.apacheds.configuration", e.getMessage()));
                }
            }
            catch (Exception e) {
                ApacheDS2ConfigurationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.apache.directory.studio.apacheds.configuration", e.getMessage()));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        this.selectedConnection = structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof Connection ? (Connection)structuredSelection.getFirstElement() : null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

