/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ReflectionUtils;
import org.apache.deltaspike.proxy.spi.DeltaSpikeProxyClassGenerator;
import org.apache.deltaspike.proxy.spi.DeltaSpikeProxyClassGeneratorHolder;

public abstract class DeltaSpikeProxyFactory {
    private static final String SUPER_ACCESSOR_METHOD_SUFFIX = "$super";

    private <T> Class<T> resolveAlreadyDefinedProxyClass(Class<T> targetClass) {
        Class proxyClass = ClassUtils.tryToLoadClassForName((String)this.constructProxyClassName(targetClass), targetClass, (ClassLoader)targetClass.getClassLoader());
        return proxyClass;
    }

    public <T> Class<T> getProxyClass(BeanManager beanManager, Class<T> targetClass) {
        Class<T> proxyClass = this.resolveAlreadyDefinedProxyClass(targetClass);
        if (proxyClass == null) {
            proxyClass = this.createProxyClass(beanManager, targetClass.getClassLoader(), targetClass);
        }
        return proxyClass;
    }

    private synchronized <T> Class<T> createProxyClass(BeanManager beanManager, ClassLoader classLoader, Class<T> targetClass) {
        Class<T> proxyClass = this.resolveAlreadyDefinedProxyClass(targetClass);
        if (proxyClass == null) {
            ArrayList<Method> allMethods = this.collectAllMethods(targetClass);
            ArrayList<Method> interceptMethods = this.filterInterceptMethods(targetClass, allMethods);
            Method[] delegateMethods = this.getDelegateMethods(targetClass);
            if (interceptMethods != null && !interceptMethods.isEmpty() && !this.containsInterceptorBinding(beanManager, targetClass.getDeclaredAnnotations())) {
                Iterator<Method> iterator = interceptMethods.iterator();
                while (iterator.hasNext()) {
                    Method method = iterator.next();
                    if (this.containsInterceptorBinding(beanManager, method.getDeclaredAnnotations())) continue;
                    iterator.remove();
                }
            }
            DeltaSpikeProxyClassGenerator proxyClassGenerator = DeltaSpikeProxyClassGeneratorHolder.lookup();
            proxyClass = proxyClassGenerator.generateProxyClass(classLoader, targetClass, this.getProxyClassSuffix(), SUPER_ACCESSOR_METHOD_SUFFIX, this.getAdditionalInterfacesToImplement(targetClass), delegateMethods, interceptMethods == null ? new Method[]{} : interceptMethods.toArray(new Method[interceptMethods.size()]));
        }
        return proxyClass;
    }

    private boolean containsInterceptorBinding(BeanManager beanManager, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            boolean containsInterceptorBinding;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (beanManager.isInterceptorBinding(annotationType)) {
                return true;
            }
            if (!beanManager.isStereotype(annotationType) || !(containsInterceptorBinding = this.containsInterceptorBinding(beanManager, annotationType.getDeclaredAnnotations()))) continue;
            return true;
        }
        return false;
    }

    private String constructProxyClassName(Class<?> clazz) {
        return clazz.getName() + this.getProxyClassSuffix();
    }

    private static String constructSuperAccessorMethodName(Method method) {
        return method.getName() + SUPER_ACCESSOR_METHOD_SUFFIX;
    }

    public static Method getSuperAccessorMethod(Object proxy, Method method) throws NoSuchMethodException {
        return proxy.getClass().getMethod(DeltaSpikeProxyFactory.constructSuperAccessorMethodName(method), method.getParameterTypes());
    }

    public boolean isProxyClass(Class<?> clazz) {
        return clazz.getName().endsWith(this.getProxyClassSuffix());
    }

    private boolean ignoreMethod(Method method, List<Method> methods) {
        if (method.isBridge()) {
            return true;
        }
        if ("finalize".equals(method.getName())) {
            return true;
        }
        if (methods.contains(method)) {
            return true;
        }
        for (Method currentMethod : methods) {
            if (!ReflectionUtils.hasSameSignature((Method)currentMethod, (Method)method)) continue;
            return true;
        }
        return false;
    }

    protected ArrayList<Method> collectAllMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        HashSet<Method> abstractMethodLeaves = new HashSet<Method>();
        for (Method method : clazz.getMethods()) {
            if (this.ignoreMethod(method, methods)) continue;
            methods.add(method);
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            abstractMethodLeaves.add(method);
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (this.ignoreMethod(method, methods)) continue;
            methods.add(method);
        }
        for (Class<?> currentSuperClass = clazz.getSuperclass(); currentSuperClass != null; currentSuperClass = currentSuperClass.getSuperclass()) {
            if (!Modifier.isAbstract(currentSuperClass.getModifiers())) continue;
            for (Method method : currentSuperClass.getDeclaredMethods()) {
                if (this.ignoreMethod(method, methods)) continue;
                methods.add(method);
            }
            for (Method method : currentSuperClass.getMethods()) {
                if (this.ignoreMethod(method, methods)) continue;
                methods.add(method);
            }
        }
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Iterator<Method> methodIterator = methods.iterator();
            while (methodIterator.hasNext()) {
                Method method = methodIterator.next();
                if (!Modifier.isAbstract(method.getModifiers()) || abstractMethodLeaves.contains(method)) continue;
                try {
                    Method foundMethod = currentClass.getMethod(method.getName(), method.getParameterTypes());
                    if (foundMethod == null || Modifier.isAbstract(foundMethod.getModifiers())) continue;
                    methodIterator.remove();
                }
                catch (Exception exception) {}
            }
        }
        return methods;
    }

    protected ArrayList<Method> filterInterceptMethods(Class<?> targetClass, ArrayList<Method> allMethods) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : allMethods) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isFinal(method.getModifiers()) || Modifier.isAbstract(method.getModifiers())) continue;
            methods.add(method);
        }
        return methods;
    }

    protected Class<?>[] getAdditionalInterfacesToImplement(Class<?> targetClass) {
        return null;
    }

    protected abstract ArrayList<Method> getDelegateMethods(Class<?> var1, ArrayList<Method> var2);

    protected abstract String getProxyClassSuffix();

    public Method[] getDelegateMethods(Class<?> targetClass) {
        ArrayList<Method> allMethods = this.collectAllMethods(targetClass);
        ArrayList<Method> delegateMethods = this.getDelegateMethods(targetClass, allMethods);
        if (delegateMethods == null) {
            return new Method[0];
        }
        return delegateMethods.toArray(new Method[delegateMethods.size()]);
    }
}

