/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.spi.scope.window;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.jsf.api.config.JsfModuleConfig;
import org.apache.deltaspike.jsf.api.config.base.JsfBaseConfig;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindowConfig;
import org.apache.deltaspike.jsf.util.ValueExpressionEvaluationInputStream;

@SessionScoped
public class DefaultClientWindowConfig
implements ClientWindowConfig {
    private static final long serialVersionUID = -708423418378550210L;
    private static final String DEFAULT_WINDOW_HANDLER_HTML_FILE = "static/windowhandler.html";
    private volatile Boolean javaScriptEnabled = null;
    private volatile String userAgent = null;
    private String clientWindowtml;
    @Inject
    private JsfModuleConfig jsfModuleConfig;
    @Inject
    private ProjectStage projectStage;
    private ClientWindowConfig.ClientWindowRenderMode defaultClientWindowRenderMode;
    private int maxWindowContextCount;

    @PostConstruct
    protected void init() {
        this.defaultClientWindowRenderMode = this.jsfModuleConfig.getDefaultWindowMode();
        this.maxWindowContextCount = JsfBaseConfig.ScopeCustomization.WindowRestriction.MAX_COUNT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isJavaScriptEnabled() {
        if (this.javaScriptEnabled == null) {
            DefaultClientWindowConfig defaultClientWindowConfig = this;
            synchronized (defaultClientWindowConfig) {
                if (this.javaScriptEnabled == null) {
                    this.javaScriptEnabled = Boolean.TRUE;
                }
            }
        }
        return this.javaScriptEnabled;
    }

    @Override
    public void setJavaScriptEnabled(boolean javaScriptEnabled) {
        this.javaScriptEnabled = javaScriptEnabled;
    }

    @Override
    public ClientWindowConfig.ClientWindowRenderMode getClientWindowRenderMode(FacesContext facesContext) {
        if (!this.isJavaScriptEnabled()) {
            if (this.defaultClientWindowRenderMode != null) {
                return this.defaultClientWindowRenderMode;
            }
            return ClientWindowConfig.ClientWindowRenderMode.NONE;
        }
        String userAgent = this.getUserAgent(facesContext);
        if (userAgent != null && (userAgent.indexOf("bot") >= 0 || userAgent.indexOf("Bot") >= 0 || userAgent.indexOf("Slurp") >= 0 || userAgent.indexOf("Crawler") >= 0)) {
            return ClientWindowConfig.ClientWindowRenderMode.NONE;
        }
        if (this.defaultClientWindowRenderMode != null) {
            return this.defaultClientWindowRenderMode;
        }
        return ClientWindowConfig.ClientWindowRenderMode.LAZY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClientWindowHtml() {
        if (this.projectStage != ProjectStage.Development && this.clientWindowtml != null) {
            return this.clientWindowtml;
        }
        InputStream is = ClassUtils.getClassLoader(null).getResourceAsStream(this.getClientWindowResourceLocation());
        is = new ValueExpressionEvaluationInputStream(FacesContext.getCurrentInstance(), is);
        StringBuffer sb = new StringBuffer();
        try {
            int bytesRead;
            byte[] buf = new byte[16384];
            while ((bytesRead = is.read(buf)) != -1) {
                String sbuf = new String(buf, 0, bytesRead);
                sb.append(sbuf);
            }
        }
        catch (IOException e) {
            ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        this.clientWindowtml = sb.toString();
        return this.clientWindowtml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserAgent(FacesContext facesContext) {
        if (this.userAgent == null) {
            DefaultClientWindowConfig defaultClientWindowConfig = this;
            synchronized (defaultClientWindowConfig) {
                Map requestHeaders;
                if (this.userAgent == null && (requestHeaders = facesContext.getExternalContext().getRequestHeaderValuesMap()) != null && requestHeaders.containsKey("User-Agent")) {
                    String[] userAgents = (String[])requestHeaders.get("User-Agent");
                    this.userAgent = userAgents.length > 0 ? userAgents[0] : null;
                }
            }
        }
        return this.userAgent;
    }

    public String getClientWindowResourceLocation() {
        return DEFAULT_WINDOW_HANDLER_HTML_FILE;
    }

    @Override
    public int getMaxWindowContextCount() {
        return this.maxWindowContextCount;
    }

    @Override
    public boolean isClientWindowStoreWindowTreeEnabledOnLinkClick() {
        return true;
    }

    @Override
    public boolean isClientWindowStoreWindowTreeEnabledOnButtonClick() {
        return false;
    }

    @Override
    public boolean isClientWindowTokenizedRedirectEnabled() {
        return false;
    }
}

