/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.DirectHllArray;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.IntMemorySegmentPairIterator;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;

final class DirectAuxHashMap
implements AuxHashMap {
    private final DirectHllArray host;
    private final boolean readOnly;

    DirectAuxHashMap(DirectHllArray host, boolean initialize) {
        this.host = host;
        this.readOnly = host.wseg == null;
        int initLgArrInts = HllUtil.LG_AUX_ARR_INTS[host.lgConfigK];
        if (initialize) {
            if (this.readOnly) {
                HllUtil.noWriteAccess();
            }
            PreambleUtil.insertLgArr(host.wseg, initLgArrInts);
            Util.clear(host.wseg, host.auxStart, 4 << initLgArrInts);
        } else if (PreambleUtil.extractLgArr(host.seg) < initLgArrInts) {
            if (this.readOnly) {
                throw new SketchesArgumentException("Possible MemorySegment image corruption, incorrect LgArr field in preamble.");
            }
            int lgArr = PreambleUtil.computeLgArr(host.wseg, host.auxHashMap.getAuxCount(), host.lgConfigK);
            PreambleUtil.insertLgArr(host.wseg, lgArr);
        }
    }

    @Override
    public DirectAuxHashMap copy() {
        return null;
    }

    @Override
    public int getAuxCount() {
        return PreambleUtil.extractAuxCount(this.host.seg);
    }

    @Override
    public int[] getAuxIntArr() {
        return null;
    }

    @Override
    public int getCompactSizeBytes() {
        return this.getAuxCount() << 2;
    }

    @Override
    public PairIterator getIterator() {
        return new IntMemorySegmentPairIterator(this.host.seg, (long)this.host.auxStart, 1 << this.getLgAuxArrInts(), this.host.lgConfigK);
    }

    @Override
    public int getLgAuxArrInts() {
        return PreambleUtil.extractLgArr(this.host.seg);
    }

    @Override
    public int getUpdatableSizeBytes() {
        return 4 << this.getLgAuxArrInts();
    }

    @Override
    public boolean hasMemorySegment() {
        return this.host.hasMemorySegment();
    }

    @Override
    public boolean isOffHeap() {
        return this.host.isOffHeap();
    }

    @Override
    public boolean isSameResource(MemorySegment seg) {
        return this.host.isSameResource(seg);
    }

    @Override
    public void mustAdd(int slotNo, int value) {
        if (this.readOnly) {
            HllUtil.noWriteAccess();
        }
        int index = DirectAuxHashMap.find(this.host, slotNo);
        int pair = HllUtil.pair(slotNo, value);
        if (index >= 0) {
            String pairStr = HllUtil.pairString(pair);
            throw new SketchesStateException("Found a slotNo that should not be there: " + pairStr);
        }
        this.host.wseg.set(ValueLayout.JAVA_INT_UNALIGNED, (long)(this.host.auxStart + (~index << 2)), pair);
        int auxCount = PreambleUtil.extractAuxCount(this.host.seg);
        PreambleUtil.insertAuxCount(this.host.wseg, ++auxCount);
        int lgAuxArrInts = PreambleUtil.extractLgArr(this.host.seg);
        if (4 * auxCount > 3 * (1 << lgAuxArrInts)) {
            DirectAuxHashMap.grow(this.host, lgAuxArrInts);
        }
    }

    @Override
    public int mustFindValueFor(int slotNo) {
        int index = DirectAuxHashMap.find(this.host, slotNo);
        if (index >= 0) {
            int pair = this.host.seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)(this.host.auxStart + (index << 2)));
            return HllUtil.getPairValue(pair);
        }
        throw new SketchesStateException("SlotNo not found: " + slotNo);
    }

    @Override
    public void mustReplace(int slotNo, int value) {
        int index;
        if (this.readOnly) {
            HllUtil.noWriteAccess();
        }
        if ((index = DirectAuxHashMap.find(this.host, slotNo)) >= 0) {
            this.host.wseg.set(ValueLayout.JAVA_INT_UNALIGNED, (long)(this.host.auxStart + (index << 2)), HllUtil.pair(slotNo, value));
            return;
        }
        String pairStr = HllUtil.pairString(HllUtil.pair(slotNo, value));
        throw new SketchesStateException("Pair not found: " + pairStr);
    }

    private static int find(DirectHllArray host, int slotNo) {
        int stride;
        int probe;
        int lgAuxArrInts = PreambleUtil.extractLgArr(host.seg);
        assert (lgAuxArrInts < host.lgConfigK) : lgAuxArrInts;
        int auxInts = 1 << lgAuxArrInts;
        int auxArrMask = auxInts - 1;
        int configKmask = (1 << host.lgConfigK) - 1;
        int loopIndex = probe = slotNo & auxArrMask;
        do {
            int arrVal;
            if ((arrVal = host.seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)(host.auxStart + (probe << 2)))) == 0) {
                return ~probe;
            }
            if (slotNo != (arrVal & configKmask)) continue;
            return probe;
        } while ((probe = probe + (stride = slotNo >>> lgAuxArrInts | 1) & auxArrMask) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }

    private static void grow(DirectHllArray host, int oldLgAuxArrInts) {
        if (host.wseg == null) {
            HllUtil.noWriteAccess();
        }
        int oldAuxArrInts = 1 << oldLgAuxArrInts;
        int[] oldIntArray = new int[oldAuxArrInts];
        MemorySegment.copy(host.wseg, ValueLayout.JAVA_INT_UNALIGNED, host.auxStart, oldIntArray, 0, oldAuxArrInts);
        PreambleUtil.insertLgArr(host.wseg, oldLgAuxArrInts + 1);
        long newAuxBytes = oldAuxArrInts << 3;
        long requestBytes = (long)host.auxStart + newAuxBytes;
        long oldCapBytes = host.wseg.byteSize();
        if (requestBytes > oldCapBytes) {
            MemorySegment newWseg = MemorySegment.ofArray(new byte[(int)requestBytes]);
            MemorySegment.copy(host.wseg, 0L, newWseg, 0L, host.auxStart);
            Util.clear(newWseg, host.auxStart, newAuxBytes);
            host.updateMemorySegment(newWseg);
        }
        int configKmask = (1 << host.lgConfigK) - 1;
        for (int i = 0; i < oldAuxArrInts; ++i) {
            int fetched = oldIntArray[i];
            if (fetched == 0) continue;
            int index = DirectAuxHashMap.find(host, fetched & configKmask);
            host.wseg.set(ValueLayout.JAVA_INT_UNALIGNED, (long)(host.auxStart + (~index << 2)), fetched);
        }
    }
}

