/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.utils.OrbConfig;
import org.apache.cxf.common.logging.LogUtils;
import org.omg.CORBA.ORB;

public final class CorbaBindingHelper {
    private static final Logger LOG = LogUtils.getL7dLogger(CorbaBindingHelper.class);
    private static Map<String, ORB> orbList = new HashMap<String, ORB>();
    private static Map<String, Integer> orbUseCount = new HashMap<String, Integer>();
    private static ORB defaultORB;

    private CorbaBindingHelper() {
    }

    public static synchronized ORB getDefaultORB(OrbConfig config) {
        if (defaultORB == null) {
            List<String> orbArgs;
            Properties props = System.getProperties();
            Properties configSpecifiedOrbProperties = config.getOrbProperties();
            props.putAll((Map<?, ?>)configSpecifiedOrbProperties);
            if (config.getOrbClass() != null) {
                props.put("org.omg.CORBA.ORBClass", config.getOrbClass());
            }
            if (config.getOrbSingletonClass() != null) {
                props.put("org.omg.CORBA.ORBSingletonClass", config.getOrbSingletonClass());
            }
            if ((defaultORB = ORB.init((String[])(orbArgs = config.getOrbArgs()).toArray(new String[0]), (Properties)props)) == null) {
                LOG.severe("Could not create instance of the ORB");
                throw new CorbaBindingException("Could not create instance of the ORB");
            }
        }
        return defaultORB;
    }

    public static synchronized ORB getAddressSpecificORB(String address, Properties props, List<String> orbArgs) {
        ORB orb = orbList.get(CorbaBindingHelper.getORBNameFromAddress(address));
        if (orb == null) {
            orb = CorbaBindingHelper.createAddressSpecificORB(address, props, orbArgs);
        }
        return orb;
    }

    private static ORB createAddressSpecificORB(String address, Properties props, List<String> orbArgs) {
        URI addressURI;
        try {
            addressURI = new URI(address);
        }
        catch (URISyntaxException ex) {
            throw new CorbaBindingException("Unable to create ORB with address " + address);
        }
        String scheme = addressURI.getScheme();
        if ("corbaloc".equals(scheme)) {
            schemeSpecificPart = addressURI.getSchemeSpecificPart();
            int keyIndex = schemeSpecificPart.indexOf(47);
            String corbaAddr = schemeSpecificPart.substring(0, keyIndex);
            int index = corbaAddr.indexOf(58);
            String protocol = "iiop";
            if (index != 0) {
                protocol = corbaAddr.substring(0, index);
            }
            int oldIndex = index;
            index = corbaAddr.indexOf(58, oldIndex + 1);
            String host = corbaAddr.substring(oldIndex + 1, index);
            String port = corbaAddr.substring(index + 1);
            props.put("yoko.orb.oa.endpoint", new String(protocol + " --host " + host + " --port " + port));
        } else if ("corbaname".equals(scheme)) {
            schemeSpecificPart = addressURI.getSchemeSpecificPart();
            if (schemeSpecificPart.startsWith(":")) {
                schemeSpecificPart = schemeSpecificPart.substring(1);
            }
            int idx = schemeSpecificPart.indexOf(58);
            props.put("org.omg.CORBA.ORBInitialHost", schemeSpecificPart.substring(0, idx));
            props.put("org.omg.CORBA.ORBInitialPort", schemeSpecificPart.substring(idx + 1));
        } else if (!("file".equals(scheme) || "relfile".equals(scheme) || "IOR".equals(scheme) || "ior".equals(scheme))) {
            throw new CorbaBindingException("Unsupported address scheme type " + scheme);
        }
        ORB orb = ORB.init((String[])orbArgs.toArray(new String[0]), (Properties)props);
        orbList.put(CorbaBindingHelper.getORBNameFromAddress(address), orb);
        return orb;
    }

    private static String getORBNameFromAddress(String address) {
        Object name;
        URI addressURI;
        try {
            addressURI = new URI(address);
        }
        catch (URISyntaxException ex) {
            throw new CorbaBindingException("Unable to locate ORB with address " + address);
        }
        String scheme = addressURI.getScheme();
        if ("corbaloc".equals(scheme) || "corbaname".equals(scheme)) {
            int keyIndex;
            String schemeSpecificPart = addressURI.getSchemeSpecificPart();
            if (schemeSpecificPart.startsWith(":")) {
                schemeSpecificPart = schemeSpecificPart.substring(1);
            }
            name = (keyIndex = schemeSpecificPart.indexOf(47)) != -1 ? schemeSpecificPart.substring(0, keyIndex) : schemeSpecificPart;
            if (addressURI.getRawQuery() != null) {
                name = (String)name + addressURI.getRawQuery();
            }
        } else if ("IOR".equals(scheme) || "ior".equals(scheme)) {
            name = addressURI.toString();
        } else if ("file".equals(scheme) || "relfile".equals(scheme)) {
            name = addressURI.getPath();
            if (name == null) {
                name = addressURI.getSchemeSpecificPart();
            }
        } else {
            throw new CorbaBindingException("Unsupported address scheme type " + scheme);
        }
        return name;
    }

    public static synchronized void keepORBAlive(String address) {
        Integer count = orbUseCount.get(CorbaBindingHelper.getORBNameFromAddress(address));
        if (count == null) {
            orbUseCount.put(CorbaBindingHelper.getORBNameFromAddress(address), 1);
        } else {
            orbUseCount.put(CorbaBindingHelper.getORBNameFromAddress(address), count + 1);
        }
    }

    public static synchronized void destroyORB(String address, ORB orb) throws CorbaBindingException {
        Integer count = orbUseCount.get(CorbaBindingHelper.getORBNameFromAddress(address));
        if (count == null) {
            return;
        }
        if ((count = Integer.valueOf(count - 1)) < 1) {
            orbUseCount.remove(CorbaBindingHelper.getORBNameFromAddress(address));
            orbList.remove(CorbaBindingHelper.getORBNameFromAddress(address));
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                throw new CorbaBindingException(ex);
            }
        } else {
            orbUseCount.put(CorbaBindingHelper.getORBNameFromAddress(address), count);
        }
    }
}

