/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_undertow.blueprint;

import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.Namespaces;
import org.apache.aries.blueprint.ParserContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.http_undertow.blueprint.UndertowServerEngineFactoryParser;
import org.apache.cxf.transport.http_undertow.blueprint.UndertowServerEngineParser;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Namespaces(value={"http://cxf.apache.org/transports/http-undertow/configuration"})
public class HTTPUndertowTransportNamespaceHandler
implements NamespaceHandler {
    public static final String UNDERTOW_TRANSPORT = "http://cxf.apache.org/transports/http-undertow/configuration";
    private static final String UNDERTOW_ENGINE = "engine";
    private static final String UNDERTOW_ENGINE_FACTORY = "engine-factory";
    private static final Logger LOG = LogUtils.getL7dLogger(HTTPUndertowTransportNamespaceHandler.class);

    public URL getSchemaLocation(String s) {
        if (UNDERTOW_TRANSPORT.equals(s)) {
            return this.getClass().getClassLoader().getResource("schemas/configuration/http-undertow.xsd");
        }
        return null;
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    public Metadata parse(Element element, ParserContext parserContext) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Parsing element {{" + element.getNamespaceURI() + "}}{" + element.getLocalName() + "}");
        }
        if (UNDERTOW_ENGINE.equals(element.getLocalName())) {
            return new UndertowServerEngineParser().parse(element, parserContext);
        }
        if (UNDERTOW_ENGINE_FACTORY.equals(element.getLocalName())) {
            return new UndertowServerEngineFactoryParser().parse(element, parserContext);
        }
        return null;
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata componentMetadata, ParserContext parserContext) {
        LOG.info("Decorating node " + String.valueOf(node) + " " + String.valueOf(componentMetadata));
        return componentMetadata;
    }
}

