/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.LSInputImpl;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.tools.validator.internal.SchemaValidator;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

class SchemaResourceResolver
implements LSResourceResolver {
    private static final Logger LOG = LogUtils.getL7dLogger(SchemaValidator.class);
    private static final Map<String, String> NSFILEMAP = new HashMap<String, String>();

    SchemaResourceResolver() {
    }

    private LSInput loadLSInput(String ns) {
        String path = "schemas/wsdl/" + NSFILEMAP.get(ns);
        URL url = this.getClass().getClassLoader().getResource(path);
        LSInputImpl lsin = new LSInputImpl();
        lsin.setSystemId(url.toString());
        try {
            lsin.setByteStream(url.openStream());
        }
        catch (IOException e) {
            return null;
        }
        return lsin;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        String filename;
        Message msg = new Message("RESOLVE_SCHEMA", LOG, new Object[]{namespaceURI, systemId, baseURI});
        LOG.log(Level.FINE, msg.toString());
        if (NSFILEMAP.containsKey(namespaceURI)) {
            return this.loadLSInput(namespaceURI);
        }
        LSInputImpl lsin = null;
        String resURL = null;
        if (systemId != null) {
            String schemaLocation = "";
            if (baseURI != null) {
                schemaLocation = baseURI.substring(0, baseURI.lastIndexOf(47) + 1);
            }
            resURL = systemId.indexOf("http://") < 0 ? schemaLocation + systemId : systemId;
        } else if (namespaceURI != null) {
            resURL = namespaceURI;
        }
        if (resURL == null) {
            return null;
        }
        String localFile = resURL;
        if (resURL.startsWith("http://") && (filename = NSFILEMAP.get(resURL)) != null) {
            localFile = "schemas/wsdl/" + filename;
        }
        try {
            msg = new Message("RESOLVE_FROM_LOCAL", LOG, new Object[]{localFile});
            LOG.log(Level.FINE, msg.toString());
            URIResolver resolver = new URIResolver(localFile);
            if (resolver.isResolved()) {
                lsin = new LSInputImpl();
                lsin.setSystemId(localFile);
                lsin.setByteStream(resolver.getInputStream());
            }
        }
        catch (IOException e) {
            return null;
        }
        return lsin;
    }

    static {
        NSFILEMAP.put("http://www.w3.org/XML/1998/namespace", "xml.xsd");
        NSFILEMAP.put("http://schemas.xmlsoap.org/wsdl/", "wsdl.xsd");
        NSFILEMAP.put("http://www.w3.org/2001/XMLSchema", "XMLSchema.xsd");
    }
}

