/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.performance;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class SleepingObjectFactory
implements PooledObjectFactory<Integer> {
    private int counter = 0;
    private boolean debug = false;

    public PooledObject<Integer> makeObject() throws Exception {
        Integer obj = new Integer(this.counter++);
        this.debug("makeObject", obj);
        this.sleep(500L);
        return new DefaultPooledObject((Object)obj);
    }

    public void destroyObject(PooledObject<Integer> obj) throws Exception {
        this.debug("destroyObject", obj);
        this.sleep(250L);
    }

    public boolean validateObject(PooledObject<Integer> obj) {
        this.debug("validateObject", obj);
        this.sleep(30L);
        return true;
    }

    public void activateObject(PooledObject<Integer> obj) throws Exception {
        this.debug("activateObject", obj);
        this.sleep(10L);
    }

    public void passivateObject(PooledObject<Integer> obj) throws Exception {
        this.debug("passivateObject", obj);
        this.sleep(10L);
    }

    private void debug(String method, Object obj) {
        if (this.debug) {
            String thread = "thread" + Thread.currentThread().getName();
            System.out.println(thread + ": " + method + " " + obj);
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }
}

