/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.core;

import java.net.URL;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.jelly.Jelly;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;

public class TestIncludeTag
extends TestCase {
    Jelly jelly = null;
    JellyContext context = null;
    XMLOutput xmlOutput = null;

    public TestIncludeTag(String name) {
        super(name);
    }

    public static TestSuite suite() throws Exception {
        return new TestSuite(TestIncludeTag.class);
    }

    public void setUp(String scriptName) throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource(scriptName);
        if (url == null) {
            throw new Exception("Could not find Jelly script: " + scriptName + " in package of class: " + ((Object)((Object)this)).getClass().getName());
        }
        this.setUpFromURL(url);
    }

    public void setUpFromURL(URL url) throws Exception {
        this.context = new CoreTaglibOnlyContext();
        this.xmlOutput = XMLOutput.createDummyXMLOutput();
        this.jelly = new Jelly();
        this.jelly.setUrl(url);
        String exturl = url.toExternalForm();
        int lastSlash = exturl.lastIndexOf("/");
        String extBase = exturl.substring(0, lastSlash + 1);
        URL baseurl = new URL(extBase);
        this.context.setCurrentURL(baseurl);
    }

    public void testInnermost() throws Exception {
        this.setUp("c.jelly");
        Script script = this.jelly.compileScript();
        script.run(this.context, this.xmlOutput);
        TestIncludeTag.assertTrue((String)"should have set 'c' variable to 'true'", (boolean)this.context.getVariable("c").equals("true"));
    }

    public void testMiddle() throws Exception {
        this.setUp("b.jelly");
        Script script = this.jelly.compileScript();
        script.run(this.context, this.xmlOutput);
        TestIncludeTag.assertTrue((String)"should have set 'c' variable to 'true'", (boolean)this.context.getVariable("c").equals("true"));
        TestIncludeTag.assertTrue((String)"should have set 'b' variable to 'true'", (boolean)this.context.getVariable("b").equals("true"));
    }

    public void testOutermost() throws Exception {
        this.setUp("a.jelly");
        Script script = this.jelly.compileScript();
        script.run(this.context, this.xmlOutput);
        TestIncludeTag.assertTrue((String)"should have set 'c' variable to 'true'", (boolean)this.context.getVariable("c").equals("true"));
        TestIncludeTag.assertTrue((String)"should have set 'b' variable to 'true'", (boolean)this.context.getVariable("b").equals("true"));
        TestIncludeTag.assertTrue((String)"should have set 'a' variable to 'true'", (boolean)this.context.getVariable("a").equals("true"));
    }

    public void testFileInclude() throws Exception {
        this.setUpFromURL(new URL("file:src/test/org/apache/commons/jelly/core/a.jelly"));
        Script script = this.jelly.compileScript();
        script.run(this.context, this.xmlOutput);
        TestIncludeTag.assertTrue((String)"should have set 'c' variable to 'true'", (boolean)this.context.getVariable("c").equals("true"));
        TestIncludeTag.assertTrue((String)"should have set 'b' variable to 'true'", (boolean)this.context.getVariable("b").equals("true"));
        TestIncludeTag.assertTrue((String)"should have set 'a' variable to 'true'", (boolean)this.context.getVariable("a").equals("true"));
    }

    private class CoreTaglibOnlyContext
    extends JellyContext {
        private CoreTaglibOnlyContext() {
        }

        public TagLibrary getTagLibrary(String namespaceURI) {
            if (namespaceURI.equals("jelly:core")) {
                return super.getTagLibrary(namespaceURI);
            }
            throw new NoClassDefFoundError("Unexpected tag library uri: " + namespaceURI);
        }
    }
}

