/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.transparencyfilters;

import java.io.IOException;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.png.transparencyfilters.AbstractTransparencyFilter;

public class TransparencyFilterIndexedColor
extends AbstractTransparencyFilter {
    public TransparencyFilterIndexedColor(byte[] bytes) {
        super(bytes);
    }

    @Override
    public int filter(int rgb, int index) throws ImagingException, IOException {
        int length = this.getLength();
        if (index >= length) {
            return rgb;
        }
        if (index < 0 || index > length) {
            throw new ImagingException("TransparencyFilterIndexedColor index: " + index + ", bytes.length: " + length);
        }
        byte alpha = this.getByte(index);
        return (0xFF & alpha) << 24 | 0xFFFFFF & rgb;
    }
}

